/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.tools.url;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.CPUKind;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/RemoteDebuggerToolsUrlWithArguments;", "", "baseUrl", "", "RemoteDebuggerToolsUrlWithArguments", "(Ljava/lang/String;)V", "substituteArguments", "cpu", "Lcom/jetbrains/rider/CPUKind;", "currentRiderVersion", "toString", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRemoteDebuggerToolsUrlsWithArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDebuggerToolsUrlsWithArguments.kt\ncom/jetbrains/rider/debugger/attach/remoting/tools/url/RemoteDebuggerToolsUrlWithArguments\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n13#2:63\n13#3:64\n*S KotlinDebug\n*F\n+ 1 RemoteDebuggerToolsUrlsWithArguments.kt\ncom/jetbrains/rider/debugger/attach/remoting/tools/url/RemoteDebuggerToolsUrlWithArguments\n*L\n42#1:63\n42#1:64\n*E\n"})
public class RemoteDebuggerToolsUrlWithArguments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String CPU_PATTERN;
    @NotNull
    private static final String RIDER_VERSION_PATTERN;

    public RemoteDebuggerToolsUrlWithArguments(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = baseUrl;
    }

    @NotNull
    public final String substituteArguments(@NotNull CPUKind cpu, @NotNull String currentRiderVersion) {
        Intrinsics.checkNotNullParameter((Object)cpu, (String)"cpu");
        Intrinsics.checkNotNullParameter((Object)currentRiderVersion, (String)"currentRiderVersion");
        logger.trace("Substituting arguments for url " + this.baseUrl + ", cpu = " + cpu + ", Rider version = " + currentRiderVersion);
        String string = cpu.getDirectoryName();
        String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)this.baseUrl, (String)RIDER_VERSION_PATTERN, (String)currentRiderVersion, (boolean)false, (int)4, null), (String)CPU_PATTERN, (String)string, (boolean)false, (int)4, null);
        logger.trace("Result url: " + string2);
        return string2;
    }

    @NotNull
    public String toString() {
        return this.baseUrl;
    }

    @NotNull
    protected static final String getCPU_PATTERN() {
        return Companion.getCPU_PATTERN();
    }

    @NotNull
    protected static final String getRIDER_VERSION_PATTERN() {
        return Companion.getRIDER_VERSION_PATTERN();
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(RemoteDebuggerToolsUrlWithArguments.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteDebuggerToolsUrlWithArguments.logger = logger;
        CPU_PATTERN = "%CPU_VERSION%";
        RIDER_VERSION_PATTERN = "%RIDER_VERSION%";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u00078\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/tools/url/RemoteDebuggerToolsUrlWithArguments$Companion;", "", "RemoteDebuggerToolsUrlWithArguments$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "CPU_PATTERN", "", "getCPU_PATTERN$annotations", "getCPU_PATTERN", "()Ljava/lang/String;", "RIDER_VERSION_PATTERN", "getRIDER_VERSION_PATTERN$annotations", "getRIDER_VERSION_PATTERN", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final String getCPU_PATTERN() {
            return CPU_PATTERN;
        }

        @JvmStatic
        protected static /* synthetic */ void getCPU_PATTERN$annotations() {
        }

        @NotNull
        protected final String getRIDER_VERSION_PATTERN() {
            return RIDER_VERSION_PATTERN;
        }

        @JvmStatic
        protected static /* synthetic */ void getRIDER_VERSION_PATTERN$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

