/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.machines;

import com.intellij.remote.RemoteCredentials;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.debugger.attach.remoting.SshExtKt;
import com.jetbrains.rider.debugger.attach.remoting.machines.RemoteLinuxMachine;
import com.jetbrains.rider.debugger.attach.remoting.machines.RemoteMachine;
import com.jetbrains.rider.debugger.attach.remoting.machines.RemoteMachineUtil;
import com.jetbrains.rider.debugger.attach.remoting.ssh.SshExecutor;
import com.jetbrains.rider.util.OSKind;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0014J\u000e\u0010\r\u001a\u00020\u000eH\u0094@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0012\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/machines/RemoteLinuxMachine;", "Lcom/jetbrains/rider/debugger/attach/remoting/machines/RemoteMachine;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "RemoteLinuxMachine", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/remote/RemoteCredentials;)V", "getAppDataCmd", "", "getHomeCmd", "getFileExistsCmd", "path", "determineCpuKind", "Lcom/jetbrains/rider/CPUKind;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasIcuPackages", "", "k", "intellij.rider"})
public final class RemoteLinuxMachine
extends RemoteMachine {
    public RemoteLinuxMachine(@NotNull CoroutineScope scope, @NotNull RemoteCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        super(scope, credentials, OSKind.Linux);
    }

    @Override
    @NotNull
    protected String getAppDataCmd() {
        return "echo $HOME/.local/share";
    }

    @Override
    @NotNull
    protected String getHomeCmd() {
        return "echo $HOME";
    }

    @Override
    @NotNull
    protected String getFileExistsCmd(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return "test -f " + SshExtKt.shellQuote(path, this.getOsKind()) + " && echo \"Yes, there is such file\" ||:";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object determineCpuKind(@NotNull Continuation<? super CPUKind> $completion) {
        if (!($completion instanceof determineCpuKind.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var5_2 = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteLinuxMachine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.determineCpuKind((Continuation<? super CPUKind>)((Continuation)this));
                }
            };
        }
        var4_3 = var5_2.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var5_2.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var4_3);
                var5_2.label = 1;
                v0 = RemoteMachineUtil.execCmdOrThrow$default(RemoteMachineUtil.INSTANCE, this, "uname -m", 0L, "detect remote CPU type", (Continuation)var5_2, 2, null);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)var4_3);
                v0 = var4_3;
lbl20:
                // 2 sources

                var2_5 = ((SshExecutor.RemoteExecutionResult)v0).getOutput();
                RemoteMachine.getLogger().info("Output of 'uname -m' command: \"" + StringsKt.trim((CharSequence)var2_5).toString() + "\"");
                var5_2.L$0 = var2_5;
                var5_2.label = 2;
                v1 = this.k((Continuation<? super Boolean>)var5_2);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl33
            }
            case 2: {
                var2_5 = (String)var5_2.L$0;
                ResultKt.throwOnFailure((Object)var4_3);
                v1 = var4_3;
lbl33:
                // 2 sources

                var3_6 = (Boolean)v1;
                if (StringsKt.contains$default((CharSequence)var2_5, (CharSequence)"armv8", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)var2_5, (CharSequence)"aarch64", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)var2_5, (CharSequence)"arm64", (boolean)false, (int)2, null)) {
                    return var3_6 != false ? CPUKind.LinuxMuslArm64 : CPUKind.LinuxArm64;
                }
                if (StringsKt.contains$default((CharSequence)var2_5, (CharSequence)"arm", (boolean)false, (int)2, null)) {
                    return var3_6 != false ? CPUKind.LinuxMuslArm32 : CPUKind.LinuxArm32;
                }
                if (StringsKt.contains$default((CharSequence)var2_5, (CharSequence)"64", (boolean)false, (int)2, null)) {
                    return var3_6 != false ? CPUKind.LinuxMusl64 : CPUKind.Linux64;
                }
                return CPUKind.Linux32;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object hasIcuPackages(@NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof hasIcuPackages.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var4_2 = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ RemoteLinuxMachine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.hasIcuPackages((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        var3_3 = var4_2.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var4_2.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var3_3);
                var4_2.label = 1;
                v0 = RemoteMachineUtil.INSTANCE.execCmd(this, "find /usr/lib -name \"*libicu\"", 5000L, "Detecting libicu packages", (Continuation<? super SshExecutor.RemoteExecutionResult>)var4_2);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)var3_3);
                v0 = var3_3;
lbl20:
                // 2 sources

                if ((var2_5 = (SshExecutor.RemoteExecutionResult)v0).getExitCode() != 0) {
                    return Boxing.boxBoolean((boolean)true);
                }
                return Boxing.boxBoolean((boolean)(StringsKt.isBlank((CharSequence)var2_5.getOutput()) == false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object k(Continuation<? super Boolean> var1_1) {
        if (!(var1_1 instanceof isMusl.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var5_2 = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteLinuxMachine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RemoteLinuxMachine.access$isMusl(this.this$0, (Continuation)this);
                }
            };
        }
        var4_3 = var5_2.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var5_2.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var4_3);
                var2_5 = "ldd /bin/ls | grep musl ||:";
                var5_2.L$0 = var2_5;
                var5_2.label = 1;
                v0 = RemoteMachineUtil.execCmd$default(RemoteMachineUtil.INSTANCE, this, var2_5, 0L, "detect remote CPU type", (Continuation)var5_2, 2, null);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                var2_5 = (String)var5_2.L$0;
                ResultKt.throwOnFailure((Object)var4_3);
                v0 = var4_3;
lbl23:
                // 2 sources

                var3_6 = ((SshExecutor.RemoteExecutionResult)v0).getOutput();
                RemoteMachine.getLogger().info("Checking musl, cmd = '" + var2_5 + "', output: " + var3_6);
                return Boxing.boxBoolean((boolean)(StringsKt.isBlank((CharSequence)var3_6) == false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$isMusl(RemoteLinuxMachine $this, Continuation $completion) {
        return $this.k((Continuation<? super Boolean>)$completion);
    }
}

