/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting.errors;

import com.intellij.openapi.project.Project;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.SshException;
import com.jetbrains.rider.debugger.attach.remoting.RemoteDebuggerToolsUploadStatus;
import com.jetbrains.rider.debugger.attach.remoting.errors.AuthFailedError;
import com.jetbrains.rider.debugger.attach.remoting.errors.ConnectionFailedError;
import com.jetbrains.rider.debugger.attach.remoting.errors.FailedToOpenSftpConnectionError;
import com.jetbrains.rider.debugger.attach.remoting.errors.FailedToResolveHostError;
import com.jetbrains.rider.debugger.attach.remoting.errors.ProcessEnumeratorFailedError;
import com.jetbrains.rider.debugger.attach.remoting.errors.RemoteDebugErrorDescription;
import com.jetbrains.rider.debugger.attach.remoting.errors.RemoteDebugErrorDescriptionFactory;
import com.jetbrains.rider.debugger.attach.remoting.errors.RemoteDebuggerProcessException;
import com.jetbrains.rider.debugger.attach.remoting.errors.RemoteDebuggerToolsErrorKind;
import com.jetbrains.rider.debugger.attach.remoting.errors.UnknownError;
import java.net.ConnectException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/errors/RemoteDebugErrorDescriptionFactoryImpl;", "Lcom/jetbrains/rider/debugger/attach/remoting/errors/RemoteDebugErrorDescriptionFactory;", "RemoteDebugErrorDescriptionFactoryImpl", "()V", "createDescription", "Lcom/jetbrains/rider/debugger/attach/remoting/errors/RemoteDebugErrorDescription;", "project", "Lcom/intellij/openapi/project/Project;", "error", "Lcom/jetbrains/rider/debugger/attach/remoting/RemoteDebuggerToolsUploadStatus$ExceptionOccurred;", "intellij.rider"})
public final class RemoteDebugErrorDescriptionFactoryImpl
implements RemoteDebugErrorDescriptionFactory {
    @NotNull
    public static final RemoteDebugErrorDescriptionFactoryImpl INSTANCE = new RemoteDebugErrorDescriptionFactoryImpl();

    private RemoteDebugErrorDescriptionFactoryImpl() {
    }

    @Override
    @NotNull
    public RemoteDebugErrorDescription createDescription(@NotNull Project project, @NotNull RemoteDebuggerToolsUploadStatus.ExceptionOccurred error) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        RemoteDebuggerToolsUploadStatus.ExceptionOccurred exceptionOccurred = error;
        boolean bl = false;
        return exceptionOccurred.getE() instanceof SshException && exceptionOccurred.getE().getCause() instanceof UnknownHostException ? (RemoteDebugErrorDescription)new FailedToResolveHostError(project, exceptionOccurred.getCredentials()) : (exceptionOccurred.getE() instanceof SshException && exceptionOccurred.getE().getCause() instanceof ConnectException ? (RemoteDebugErrorDescription)new ConnectionFailedError(project, exceptionOccurred.getCredentials()) : (exceptionOccurred.getE() instanceof AuthFailSshTransportException ? (RemoteDebugErrorDescription)new AuthFailedError(project, exceptionOccurred.getCredentials()) : (exceptionOccurred.getE() instanceof SshException && exceptionOccurred.getKind() == RemoteDebuggerToolsErrorKind.OPEN_SFTP ? (RemoteDebugErrorDescription)new FailedToOpenSftpConnectionError(project, exceptionOccurred.getCredentials()) : (exceptionOccurred.getE() instanceof RemoteDebuggerProcessException ? (RemoteDebugErrorDescription)new ProcessEnumeratorFailedError(project, exceptionOccurred.getCredentials(), (RemoteDebuggerProcessException)exceptionOccurred.getE()) : (RemoteDebugErrorDescription)new UnknownError(project, exceptionOccurred.getCredentials(), exceptionOccurred.getE())))));
    }
}

