/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.debugger.modulesView.AssemblyVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/RiderVersions;", "", "RiderVersions", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getExpectedBuildArtifactVersion", "Lcom/jetbrains/rider/debugger/modulesView/AssemblyVersion;", "getBuildNumber", "x", "", "fullVersion", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderVersions.kt\ncom/jetbrains/rider/debugger/attach/remoting/RiderVersions\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n648#2,5:72\n13#3:77\n13#4:78\n*S KotlinDebug\n*F\n+ 1 RiderVersions.kt\ncom/jetbrains/rider/debugger/attach/remoting/RiderVersions\n*L\n64#1:72,5\n9#1:77\n9#1:78\n*E\n"})
public final class RiderVersions {
    @NotNull
    public static final RiderVersions INSTANCE = new RiderVersions();
    @NotNull
    private static final Logger logger;

    private RiderVersions() {
    }

    @NotNull
    public final AssemblyVersion getExpectedBuildArtifactVersion() {
        int n;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        AssemblyVersion assemblyVersion = this.getBuildNumber();
        if (PluginManagerCore.isRunningFromSources()) {
            n = -1;
        } else if (applicationInfoEx.isEAP()) {
            String string = applicationInfoEx.getFullVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
            n = this.x(string);
        } else {
            n = 65536;
        }
        int n2 = n;
        return new AssemblyVersion(assemblyVersion.getMajor(), assemblyVersion.getMinor(), assemblyVersion.getBuild(), n2);
    }

    @NotNull
    public final AssemblyVersion getBuildNumber() {
        Object object;
        Object object2;
        char[] cArray;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        boolean bl = false;
        Object object3 = applicationInfoEx.getMajorVersion();
        int n = object3 != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object object4 = applicationInfoEx.getMinorVersion();
        if (object4 == null || (object4 = StringsKt.split$default((CharSequence)((CharSequence)object4), (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) == null) {
            object4 = CollectionsKt.emptyList();
        }
        if (CollectionsKt.any((Iterable)((Iterable)(object2 = object4)))) {
            Integer n5 = StringsKt.toIntOrNull((String)((String)object2.get(0)));
            int n6 = n2 = n5 != null ? n5 : 0;
            if (object2.size() > 1) {
                Integer n7 = StringsKt.toIntOrNull((String)((String)object2.get(1)));
                int n8 = n3 = n7 != null ? n7 : 0;
                if (object2.size() > 2) {
                    Integer n9 = StringsKt.toIntOrNull((String)((String)object2.get(2)));
                    n4 = n9 != null ? n9 : 0;
                    return new AssemblyVersion(n, n2, n3, n4);
                }
                Object object5 = applicationInfoEx.getMicroVersion();
                n4 = object5 != null && (object5 = StringsKt.toIntOrNull((String)object5)) != null ? (Integer)object5 : 0;
                return new AssemblyVersion(n, n2, n3, n4);
            }
        } else {
            n2 = 0;
        }
        n3 = (object = applicationInfoEx.getMicroVersion()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
        Object object6 = applicationInfoEx.getPatchVersion();
        n4 = object6 != null && (object6 = StringsKt.toIntOrNull((String)object6)) != null ? (Integer)object6 : 0;
        return new AssemblyVersion(n, n2, n3, n4);
    }

    private final int x(String string) {
        String string2;
        block2: {
            int n = StringsKt.indexOf$default((CharSequence)string, (String)"eap", (int)0, (boolean)true, (int)2, null);
            if (n == -1) {
                logger.warn("Unable to find eap marker inside full version " + string);
                return -1;
            }
            String string3 = ((Object)StringsKt.trim((CharSequence)StringsKt.drop((String)string, (int)(n + 3)))).toString();
            logger.info("IDE version: " + string + ", eap suffix: " + string3);
            String string4 = string3;
            boolean bl = false;
            int n2 = string4.length();
            for (int j = 0; j < n2; ++j) {
                char c = string4.charAt(j);
                int n3 = 0;
                if (Character.isDigit(c)) continue;
                String string5 = string4;
                n3 = 0;
                String string6 = string5.substring(n3, j);
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                break block2;
            }
            string2 = string4;
        }
        String string7 = string2;
        Integer n = StringsKt.toIntOrNull((String)string7);
        int n4 = n != null ? n : -1;
        logger.info("EAP version: " + n4);
        return n4;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(RiderVersions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderVersions.logger = logger;
    }
}

