/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.dotnet;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.RunsInMixedMode;
import com.jetbrains.rider.debugger.attach.AttachDebuggerSupportsMixedMode;
import com.jetbrains.rider.debugger.attach.RiderAttachDebuggerBase;
import com.jetbrains.rider.debugger.attach.RiderJitDebuggerKeyProvider;
import com.jetbrains.rider.debugger.attach.remoting.RiderSshAttachHostBase;
import com.jetbrains.rider.model.DesktopClrRuntime;
import com.jetbrains.rider.model.GenericCoreClrRuntime;
import com.jetbrains.rider.model.GenericProcessInfoBase;
import com.jetbrains.rider.model.ProcessRuntimeInformation;
import com.jetbrains.rider.model.RdProcessInfoBase;
import com.jetbrains.rider.model.UwpCoreClrRuntime;
import com.jetbrains.rider.model.WindowsProcessInfo;
import com.jetbrains.rider.model.debuggerHelper.PlatformArchitecture;
import com.jetbrains.rider.run.dotNetCore.DotNetCoreAttachProfile;
import com.jetbrains.rider.run.dotNetCore.DotNetCoreRemoteAttachProfile;
import com.jetbrains.rider.run.dotNetCore.PlatformUtilKt;
import com.jetbrains.rider.run.msNet.MsNetAttachRunProfile;
import com.jetbrains.rider.run.msNet.MsNetRemoteAttachRunProfile;
import com.jetbrains.rider.run.uwp.UwpAttachRunProfile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/debugger/attach/dotnet/MsNetAttachDebugger;", "Lcom/jetbrains/rider/debugger/attach/RiderAttachDebuggerBase;", "Lcom/jetbrains/rider/model/RdProcessInfoBase;", "Lcom/jetbrains/rider/debugger/attach/RiderJitDebuggerKeyProvider;", "Lcom/jetbrains/rider/debugger/attach/AttachDebuggerSupportsMixedMode;", "processInfo", "runtime", "Lcom/jetbrains/rider/model/ProcessRuntimeInformation;", "runsInMixedMode", "Lcom/jetbrains/rider/debugger/RunsInMixedMode;", "MsNetAttachDebugger", "(Lcom/jetbrains/rider/model/RdProcessInfoBase;Lcom/jetbrains/rider/model/ProcessRuntimeInformation;Lcom/jetbrains/rider/debugger/RunsInMixedMode;)V", "getRuntime", "()Lcom/jetbrains/rider/model/ProcessRuntimeInformation;", "getRunsInMixedMode", "()Lcom/jetbrains/rider/debugger/RunsInMixedMode;", "createLocalAttachProfile", "Lcom/intellij/execution/configurations/RunProfile;", "Lcom/intellij/execution/process/ProcessInfo;", "rdProcessInfo", "localAttachHost", "Lcom/intellij/xdebugger/attach/LocalAttachHost;", "createRemoteAttachProfile", "remoteAttachHost", "Lcom/jetbrains/rider/debugger/attach/remoting/RiderSshAttachHostBase;", "getDebuggerDisplayName", "", "getDebuggerKey", "", "intellij.rider"})
public final class MsNetAttachDebugger
extends RiderAttachDebuggerBase<RdProcessInfoBase>
implements RiderJitDebuggerKeyProvider,
AttachDebuggerSupportsMixedMode {
    @NotNull
    private final ProcessRuntimeInformation runtime;
    @NotNull
    private final RunsInMixedMode runsInMixedMode;

    public MsNetAttachDebugger(@NotNull RdProcessInfoBase processInfo, @NotNull ProcessRuntimeInformation runtime, @NotNull RunsInMixedMode runsInMixedMode) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)runsInMixedMode, (String)"runsInMixedMode");
        super(processInfo);
        this.runtime = runtime;
        this.runsInMixedMode = runsInMixedMode;
    }

    @NotNull
    public final ProcessRuntimeInformation getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final RunsInMixedMode getRunsInMixedMode() {
        return this.runsInMixedMode;
    }

    @Override
    @NotNull
    public RunProfile createLocalAttachProfile(@NotNull ProcessInfo processInfo, @NotNull RdProcessInfoBase rdProcessInfo, @NotNull LocalAttachHost localAttachHost) {
        RunProfile runProfile2;
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)rdProcessInfo, (String)"rdProcessInfo");
        Intrinsics.checkNotNullParameter((Object)localAttachHost, (String)"localAttachHost");
        if ((rdProcessInfo instanceof GenericProcessInfoBase ? (GenericProcessInfoBase)rdProcessInfo : null) == null) {
            throw new IllegalStateException("Process info is expected to be " + GenericProcessInfoBase.class.getSimpleName());
        }
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            runProfile2 = new MsNetAttachRunProfile(processInfo, PlatformUtilKt.toWindowsCPUKind(((GenericProcessInfoBase)rdProcessInfo).getPlatform()), (DesktopClrRuntime)this.runtime, this.getDebuggerDisplayName(), this.runsInMixedMode);
        } else if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
            runProfile2 = new UwpAttachRunProfile(processInfo, PlatformUtilKt.toWindowsCPUKind(((GenericProcessInfoBase)rdProcessInfo).getPlatform()), null, this.getDebuggerDisplayName(), this.runsInMixedMode);
        } else if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
            runProfile2 = new DotNetCoreAttachProfile(processInfo, ((GenericProcessInfoBase)rdProcessInfo).getPlatform(), this.getDebuggerDisplayName(), this.runsInMixedMode);
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.runtime.getClass().getSimpleName(), (String)"getSimpleName(...)");
            throw new CantRunException(RiderDebuggerBundle.Companion.message("rider.debug.attach.unknown.runtime.message", objectArray));
        }
        return runProfile2;
    }

    @Override
    @NotNull
    public RunProfile createRemoteAttachProfile(@NotNull ProcessInfo processInfo, @NotNull RdProcessInfoBase rdProcessInfo, @NotNull RiderSshAttachHostBase remoteAttachHost) {
        RunProfile runProfile2;
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)rdProcessInfo, (String)"rdProcessInfo");
        Intrinsics.checkNotNullParameter((Object)remoteAttachHost, (String)"remoteAttachHost");
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            if ((rdProcessInfo instanceof WindowsProcessInfo ? (WindowsProcessInfo)rdProcessInfo : null) == null) {
                throw new IllegalStateException("Process info is expected to be " + WindowsProcessInfo.class.getSimpleName());
            }
            runProfile2 = new MsNetRemoteAttachRunProfile(processInfo, ((WindowsProcessInfo)rdProcessInfo).getPlatform(), (DesktopClrRuntime)this.runtime, remoteAttachHost);
        } else {
            if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
                throw new CantRunException(RiderDebuggerBundle.Companion.message("dialog.message.remote.debugging.uwp.not.supported", new Object[0]));
            }
            if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
                GenericProcessInfoBase genericProcessInfoBase = rdProcessInfo instanceof GenericProcessInfoBase ? (GenericProcessInfoBase)rdProcessInfo : null;
                if (genericProcessInfoBase == null || (genericProcessInfoBase = genericProcessInfoBase.getPlatform()) == null) {
                    genericProcessInfoBase = PlatformArchitecture.Unknown;
                }
                runProfile2 = new DotNetCoreRemoteAttachProfile(processInfo, (PlatformArchitecture)genericProcessInfoBase, remoteAttachHost);
            } else {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.runtime.getClass().getSimpleName(), (String)"getSimpleName(...)");
                throw new CantRunException(RiderDebuggerBundle.Companion.message("rider.debug.attach.unknown.runtime.message", objectArray));
            }
        }
        return runProfile2;
    }

    @NotNull
    public String getDebuggerDisplayName() {
        String string;
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            string = this.runsInMixedMode.getState() ? RiderDebuggerBundle.Companion.message("MsNetAttachProvider.mixed.debug.display.name", new Object[0]) : RiderDebuggerBundle.Companion.message("MsNetAttachProvider.display.name", new Object[0]);
        } else if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
            string = this.runsInMixedMode.getState() ? RiderDebuggerBundle.Companion.message("MsNetAttachProvider.mixed.debug.display.name", new Object[0]) : RiderDebuggerBundle.Companion.message("MsNetAttachProvider.display.name", new Object[0]);
        } else if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
            string = this.runsInMixedMode.getState() ? RiderDebuggerBundle.Companion.message("MsNetUwpAttachDebugger.mixed.debug.display.name", new Object[0]) : RiderDebuggerBundle.Companion.message("MsNetUwpAttachDebugger.display.name", new Object[0]);
        } else {
            throw new IllegalStateException("Unexpected type of runtime: " + this.runtime.getClass().getSimpleName());
        }
        return string;
    }

    @Override
    @NotNull
    public String getDebuggerKey() {
        String string;
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            string = "netframework";
        } else if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
            string = "netcore";
        } else if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
            string = "netcore";
        } else {
            throw new IllegalStateException("Unexpected type of runtime: " + this.runtime.getClass().getSimpleName());
        }
        return string;
    }

    @Override
    public boolean runsInMixedMode() {
        return this.runsInMixedMode.getState();
    }
}

