/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.dotnet;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogProcessItem;
import com.intellij.xdebugger.impl.ui.attach.dialog.extensions.XAttachDialogItemPresentationProvider;
import com.jetbrains.rider.debugger.attach.dotnet.MsNetAttachDebugger;
import com.jetbrains.rider.model.GenericCoreClrRuntime;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/debugger/attach/dotnet/DotnetAttachItemPresentationProvider;", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/extensions/XAttachDialogItemPresentationProvider;", "DotnetAttachItemPresentationProvider", "()V", "isApplicableFor", "", "item", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachDialogProcessItem;", "getProcessExecutableText", "", "getPriority", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotnetAttachItemPresentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotnetAttachItemPresentationProvider.kt\ncom/jetbrains/rider/debugger/attach/dotnet/DotnetAttachItemPresentationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,27:1\n1761#2,3:28\n1563#2:31\n1634#2,3:32\n295#2,2:35\n*S KotlinDebug\n*F\n+ 1 DotnetAttachItemPresentationProvider.kt\ncom/jetbrains/rider/debugger/attach/dotnet/DotnetAttachItemPresentationProvider\n*L\n14#1:28,3\n20#1:31\n20#1:32,3\n21#1:35,2\n*E\n"})
public final class DotnetAttachItemPresentationProvider
implements XAttachDialogItemPresentationProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isApplicableFor(@NotNull AttachDialogProcessItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        HashSet<String> hashSet = DotNetCoreRuntime.Companion.getPossibleDotNetCoreExecutables();
        String string = item.getProcessInfo().getExecutableDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableDisplayName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!hashSet.contains(string2)) return false;
        Iterable iterable = item.getDebuggers();
        boolean bl2 = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator2 = iterable.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object t = iterator2.next();
            XAttachDebugger xAttachDebugger = (XAttachDebugger)t;
            boolean bl3 = false;
            if (xAttachDebugger instanceof MsNetAttachDebugger && ((MsNetAttachDebugger)xAttachDebugger).getRuntime() instanceof GenericCoreClrRuntime) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public String getProcessExecutableText(@NotNull AttachDialogProcessItem item) {
        Collection collection;
        block3: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            List list2 = StringUtil.splitHonorQuotes((String)item.getProcessInfo().getCommandLine(), (char)' ');
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"splitHonorQuotes(...)");
            Iterable iterable = CollectionsKt.drop((Iterable)list2, (int)1);
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            Iterator iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                String string = (String)t;
                Collection collection3 = collection22;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)string);
                char[] cArray = new char[]{'\'', '\"'};
                collection3.add(StringsKt.trim((String)string, (char[])cArray));
            }
            iterable = (List)collection22;
            bl = false;
            for (Collection collection22 : iterable) {
                String string = (String)((Object)collection22);
                boolean bl4 = false;
                if (!(StringsKt.endsWith((String)string, (String)".dll", (boolean)true) || StringsKt.endsWith((String)string, (String)".exe", (boolean)true))) continue;
                collection = collection22;
                break block3;
            }
            collection = null;
        }
        String string = (String)((Object)collection);
        if (string == null) {
            String string2 = item.getProcessInfo().getExecutableDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExecutableDisplayName(...)");
            return string2;
        }
        String string3 = string;
        return item.getProcessInfo().getExecutableDisplayName() + " (" + new File(string3).getName() + ")";
    }

    public int getPriority() {
        return 5;
    }
}

