/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeUtilsKt;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.actions.handlers.IRiderActionEnabledChecker;
import com.jetbrains.rider.debugger.util.DotNetDebugProcessUtilKt;
import com.jetbrains.rider.debugger.util.JumpToStatementUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/actions/handlers/RiderJumpToStatementHandler;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "Lcom/jetbrains/rider/debugger/actions/handlers/IRiderActionEnabledChecker;", "RiderJumpToStatementHandler", "()V", "isEnabled", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isHidden", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "x", "intellij.rider"})
public final class RiderJumpToStatementHandler
extends XDebuggerSuspendedActionHandler
implements IRiderActionEnabledChecker {
    protected boolean isEnabled(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!XDebuggerSuspendedActionHandler.Companion.isEnabled(session) || !super.isEnabled(session, dataContext)) {
            return false;
        }
        return this.x(session, dataContext);
    }

    public boolean isHidden(@NotNull Project project, @NotNull AnActionEvent event) {
        XDebugSession xDebugSession;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        XDebugSession xDebugSession2 = xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if ((xDebugSession2 != null ? DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession2) : null) == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)event.getPlace(), (Object)"EditorHint") || Intrinsics.areEqual((Object)event.getPlace(), (Object)"EditorPopup")) {
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            if (!this.x(xDebugSession, dataContext)) {
                return true;
            }
        }
        return super.isHidden(project, event);
    }

    protected void perform(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(session);
        if (dotNetDebugProcess == null) {
            return;
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext);
        if (xSourcePosition != null) {
            if (session.isMixedMode()) {
                XMixedModeUtilsKt.getMixedModeDebugProcessOrThrow((XDebugSession)session).setNextStatement(xSourcePosition);
            } else {
                dotNetDebugProcess2.setNextStatement$intellij_rider(xSourcePosition);
            }
        }
    }

    private final boolean x(XDebugSession xDebugSession, DataContext dataContext) {
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession);
        if (!(dotNetDebugProcess != null ? DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess) : false)) {
            return false;
        }
        DotNetExecutionStack dotNetExecutionStack = DotnetDebuggerExtKt.getDotnetActiveExecutionContext(xDebugSession);
        if (dotNetExecutionStack == null) {
            return false;
        }
        DotNetExecutionStack dotNetExecutionStack2 = dotNetExecutionStack;
        XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)xDebugSession.getProject(), (DataContext)dataContext);
        if (xSourcePosition == null) {
            return false;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        return JumpToStatementUtilKt.canJumpToStatement(xSourcePosition2, dotNetExecutionStack2);
    }
}

