/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.SmartStepIntoAction;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.actions.handlers.SmartStepEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebugSmartStepIntoEnterHandler;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.actions.handlers.IRiderActionEnabledChecker;
import com.jetbrains.rider.rdclient.languages.assists.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/debugger/actions/RiderSmartStepIntoAction;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerActionBase;", "Lcom/jetbrains/rider/debugger/actions/handlers/IRiderActionEnabledChecker;", "RiderSmartStepIntoAction", "()V", "getHandler", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "debuggerSupport", "Lcom/intellij/xdebugger/impl/DebuggerSupport;", "isEnabled", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isHidden", "EnterHandler", "intellij.rider"})
public final class RiderSmartStepIntoAction
extends XDebuggerActionBase
implements IRiderActionEnabledChecker {
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        Intrinsics.checkNotNullParameter((Object)debuggerSupport, (String)"debuggerSupport");
        DebuggerActionHandler debuggerActionHandler = SmartStepIntoAction.HANDLER;
        Intrinsics.checkNotNullExpressionValue((Object)debuggerActionHandler, (String)"HANDLER");
        return debuggerActionHandler;
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.isEnabledAction(e) && super.isEnabled(e);
    }

    protected boolean isHidden(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return super.isHidden(e);
        }
        Project project2 = project;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (xDebugSession == null) {
            return super.isHidden(e);
        }
        XDebugSession xDebugSession2 = xDebugSession;
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession2);
        if (dotNetDebugProcess == null) {
            return super.isHidden(e);
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        if (dotNetDebugProcess2.getSmartStepIntoHandler() == null) {
            return true;
        }
        return super.isHidden(e);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/actions/RiderSmartStepIntoAction$EnterHandler;", "Lcom/intellij/xdebugger/impl/actions/handlers/XDebugSmartStepIntoEnterHandler;", "original", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "RiderSmartStepIntoAction$EnterHandler", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rider"})
    public static final class EnterHandler
    extends XDebugSmartStepIntoEnterHandler {
        public EnterHandler(@NotNull EditorActionHandler original) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            super(original);
        }

        protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (SmartStepEditorActionHandler.Companion.hasSmartStepDebugData(editor2)) {
                editor2.putUserData(UtilsKt.getEXECUTE_ON_FRONTEND(), (Object)true);
            }
            super.doExecute(editor2, caret, dataContext);
        }
    }
}

