/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.debugger.actions.RiderJumpToStatementActionKt;
import com.jetbrains.rider.debugger.actions.handlers.IRiderActionEnabledChecker;
import com.jetbrains.rider.debugger.actions.handlers.RiderJumpToStatementHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/actions/RiderJumpToStatementAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/jetbrains/rider/debugger/actions/handlers/IRiderActionEnabledChecker;", "RiderJumpToStatementAction", "()V", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "e", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderJumpToStatementAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderJumpToStatementAction.kt\ncom/jetbrains/rider/debugger/actions/RiderJumpToStatementAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,121:1\n30#2,2:122\n30#2,2:124\n*S KotlinDebug\n*F\n+ 1 RiderJumpToStatementAction.kt\ncom/jetbrains/rider/debugger/actions/RiderJumpToStatementAction\n*L\n110#1:122,2\n119#1:124,2\n*E\n"})
public final class RiderJumpToStatementAction
extends AnAction
implements IRiderActionEnabledChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ACTION_ID = "JumpToStatement";

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (Intrinsics.areEqual((Object)event.getPlace(), (Object)"EditorPopup")) {
            event.getPresentation().setText(RiderActionsBundle.Companion.message("RiderJumpToStatementAction.action.skip.to.here.text", new Object[0]));
        } else {
            event.getPresentation().setText(RiderActionsBundle.Companion.message("action.JumpToStatement.text", new Object[0]));
        }
        ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
        boolean bl = false;
        Class<RiderJumpToStatementHandler> clazz = RiderJumpToStatementHandler.class;
        Object object = componentManager.getService(clazz);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
        }
        RiderJumpToStatementHandler riderJumpToStatementHandler = (RiderJumpToStatementHandler)object;
        event.getPresentation().setVisible(!riderJumpToStatementHandler.isHidden(project, event));
        event.getPresentation().setEnabled(riderJumpToStatementHandler.isEnabled(project, event));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
        boolean bl = false;
        Class<RiderJumpToStatementHandler> clazz = RiderJumpToStatementHandler.class;
        Object object = componentManager.getService(clazz);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
        }
        ((RiderJumpToStatementHandler)object).perform(project2, e);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/debugger/actions/RiderJumpToStatementAction$Companion;", "", "RiderJumpToStatementAction$Companion", "()V", "ACTION_ID", "", "executeWithLineNumberForceOpenEditor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "place", "line", "", "executeWithLineNumber", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean executeWithLineNumberForceOpenEditor(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String place, int line) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditor fileEditor = fileEditorManager.getSelectedEditor(file2);
            if (fileEditor == null) {
                RiderJumpToStatementActionKt.access$getLogger$p().warn("Editor for file '" + file2 + "' was not opened");
                List list2 = fileEditorManager.openFile(file2);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"openFile(...)");
                fileEditor = (FileEditor)CollectionsKt.firstOrNull((List)list2);
            }
            return this.x(fileEditor, file2, place, line);
        }

        public final boolean executeWithLineNumber(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String place, int line) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
            return this.x(fileEditor, file2, place, line);
        }

        private final boolean x(FileEditor fileEditor, VirtualFile virtualFile, String string, int n) {
            if (fileEditor == null) {
                RiderJumpToStatementActionKt.access$getLogger$p().warn("Unable to get file editor for file '" + virtualFile + "'");
                return false;
            }
            if (!(fileEditor instanceof TextEditor)) {
                RiderJumpToStatementActionKt.access$getLogger$p().warn("File editor for file " + virtualFile + " is not a " + TextEditor.class.getSimpleName() + " (actual type is " + fileEditor.getClass().getSimpleName() + ")");
                return false;
            }
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            return this.executeWithLineNumber(editor2, string, n);
        }

        public final boolean executeWithLineNumber(@NotNull Editor editor2, @NotNull String place, int line) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            AnAction anAction = ActionManager.getInstance().getAction(RiderJumpToStatementAction.ACTION_ID);
            if (anAction == null) {
                RiderJumpToStatementActionKt.access$getLogger$p().error("Action JumpToStatement is not available");
            }
            AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)place, null, arg_0 -> Companion.x(editor2, line, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
            AnActionEvent anActionEvent2 = anActionEvent;
            anAction.update(anActionEvent2);
            if (!anActionEvent2.getPresentation().isEnabled()) {
                RiderJumpToStatementActionKt.access$getLogger$p().warn("Action JumpToStatement is not available");
                return false;
            }
            Intrinsics.checkNotNull((Object)anAction);
            ActionUtil.performAction((AnAction)anAction, (AnActionEvent)anActionEvent2);
            return true;
        }

        private static final Object x(Editor editor2, int n, String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"it");
            if (CommonDataKeys.PROJECT.is(string)) {
                return editor2.getProject();
            }
            if (CommonDataKeys.EDITOR.is(string)) {
                return editor2;
            }
            if (XDebuggerUtilImpl.LINE_NUMBER.is(string)) {
                return n;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

