/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import icons.ReSharperIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u000b"}, d2={"showElevationDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "showElevationDialogForDebug", "showElevationDialogForRun", "showElevationDialogIfNeeded", "throwable", "", "intellij.rider"})
public final class RiderDebuggerElevationUtilKt {
    public static final void showElevationDialog(@NotNull Project project, @NlsContexts.DialogMessage @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (Messages.showYesNoDialog((Project)project, (String)message2, (String)RiderDebuggerBundle.Companion.message("dialog.title.elevated.permissions.required", new Object[0]), (Icon)ReSharperIcons.Common.Warning) == 0) {
            ApplicationKt.getApplicationEx().restart(true, true);
        }
    }

    public static final void showElevationDialogForDebug(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RiderDebuggerElevationUtilKt.showElevationDialog(project, RiderDebuggerBundle.Companion.message("dialog.message.rider.has.to.be.restarted.elevation.for.debug", new Object[0]));
    }

    public static final void showElevationDialogForRun(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RiderDebuggerElevationUtilKt.showElevationDialog(project, RiderDebuggerBundle.Companion.message("dialog.message.rider.has.to.be.restarted.elevation.for.run", new Object[0]));
    }

    public static final void showElevationDialogIfNeeded(@NotNull Throwable throwable, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = throwable instanceof ProcessNotCreatedException ? (ProcessNotCreatedException)throwable : null;
        boolean bl = object != null && (object = object.getMessage()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"CreateProcess error=740", (boolean)false, (int)2, null) : false;
        if (bl) {
            com.intellij.util.ApplicationKt.getApplication().invokeLater(() -> RiderDebuggerElevationUtilKt.x(project));
        }
    }

    private static final void x(Project project) {
        RiderDebuggerElevationUtilKt.showElevationDialogForRun(project);
    }
}

