/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeCombinedDebugProcess;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.IDebugProcessWithId;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0012\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "RiderDebugActiveDotNetSessionsTracker", "(Lcom/intellij/openapi/project/Project;)V", "dotNetDebugProcessSet", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "dotNetDebugProcesses", "Lcom/jetbrains/rd/util/reactive/IViewableSet;", "getDotNetDebugProcesses", "()Lcom/jetbrains/rd/util/reactive/IViewableSet;", "hasActiveDotNetDebugSessions", "", "getHasActiveDotNetDebugSessions", "()Z", "lastSessionLogFolder", "Lcom/jetbrains/rd/util/reactive/Property;", "Ljava/nio/file/Path;", "getLastSessionLogFolder", "()Lcom/jetbrains/rd/util/reactive/Property;", "myCurrentSessionId", "Lcom/jetbrains/rider/debugger/IDebugProcessWithId;", "currentSessionId", "Lcom/jetbrains/rd/util/reactive/ISource;", "getCurrentSessionId", "()Lcom/jetbrains/rd/util/reactive/ISource;", "x", "", "x", "debugProcess", "x", "newSession", "Lcom/intellij/xdebugger/XDebugSession;", "G", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderDebugActiveDotNetSessionsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n13805#2,2:101\n*S KotlinDebug\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker\n*L\n42#1:101,2\n*E\n"})
public final class RiderDebugActiveDotNetSessionsTracker
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewableSet<DotNetDebugProcess> dotNetDebugProcessSet;
    @NotNull
    private final Property<Path> lastSessionLogFolder;
    @NotNull
    private final Property<IDebugProcessWithId> myCurrentSessionId;

    public RiderDebugActiveDotNetSessionsTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.dotNetDebugProcessSet = new ViewableSet(null, 1, null);
        this.lastSessionLogFolder = new Property(null);
        this.myCurrentSessionId = new Property(null);
        this.x(project);
    }

    @NotNull
    public final IViewableSet<DotNetDebugProcess> getDotNetDebugProcesses() {
        return (IViewableSet)this.dotNetDebugProcessSet;
    }

    public final boolean getHasActiveDotNetDebugSessions() {
        return CollectionsKt.any((Iterable)((Iterable)this.getDotNetDebugProcesses()));
    }

    @NotNull
    public final Property<Path> getLastSessionLogFolder() {
        return this.lastSessionLogFolder;
    }

    @NotNull
    public final ISource<IDebugProcessWithId> getCurrentSessionId() {
        return (ISource)this.myCurrentSessionId;
    }

    private final void x(Project project) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)project).getDebugSessions();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
        Object[] objectArray = xDebugSessionArray;
        boolean bl = false;
        for (Object object : objectArray) {
            XDebugSession xDebugSession = (XDebugSession)object;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)xDebugSession);
            DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession);
            if (dotNetDebugProcess == null) continue;
            this.x(dotNetDebugProcess);
        }
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new XDebuggerManagerListener(this){
            final /* synthetic */ RiderDebugActiveDotNetSessionsTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void processStarted(XDebugProcess debugProcess) {
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                XMixedModeCombinedDebugProcess xMixedModeCombinedDebugProcess = debugProcess instanceof XMixedModeCombinedDebugProcess ? (XMixedModeCombinedDebugProcess)debugProcess : null;
                XDebugProcess xDebugProcess = xMixedModeCombinedDebugProcess != null ? xMixedModeCombinedDebugProcess.getHigh() : null;
                DotNetDebugProcess dotNetDebugProcess = xDebugProcess instanceof DotNetDebugProcess ? (DotNetDebugProcess)xDebugProcess : null;
                if (dotNetDebugProcess == null && (dotNetDebugProcess = DotnetDebuggerExtKt.getAsDotNet(debugProcess)) == null) {
                    return;
                }
                DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
                RiderDebugActiveDotNetSessionsTracker.access$onDebugProcessStarted(this.this$0, dotNetDebugProcess2);
            }

            public void currentSessionChanged(XDebugSession previousSession, XDebugSession currentSession) {
                RiderDebugActiveDotNetSessionsTracker.access$onCurrentSessionChanged(this.this$0, currentSession);
            }

            public void processStopped(XDebugProcess debugProcess) {
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getAsDotNet(debugProcess);
                if (dotNetDebugProcess == null) {
                    return;
                }
                RiderDebugActiveDotNetSessionsTracker.access$onDebugProcessTerminated(this.this$0, dotNetDebugProcess);
            }
        });
        MessageBusConnection messageBusConnection2 = project.getMessageBus().connect((Disposable)project);
        Topic topic2 = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new AnActionListener(this){
            final /* synthetic */ RiderDebugActiveDotNetSessionsTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = ActionManager.getInstance().getId(action2);
                if (Intrinsics.areEqual((Object)string, (Object)"Stop")) {
                    Project project = event.getProject();
                    if (project == null) {
                        return;
                    }
                    Project project2 = project;
                    XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
                    if (xDebugSession != null) {
                        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession);
                        if (dotNetDebugProcess == null) {
                            return;
                        }
                        RiderDebugActiveDotNetSessionsTracker.access$onDebugProcessTerminated(this.this$0, dotNetDebugProcess);
                    }
                }
            }
        });
    }

    private final void x(DotNetDebugProcess dotNetDebugProcess) {
        UIUtil.invokeLaterIfNeeded(() -> RiderDebugActiveDotNetSessionsTracker.G(this, dotNetDebugProcess));
    }

    private final void x(XDebugSession xDebugSession) {
        block0: {
            XDebugSession xDebugSession2 = xDebugSession;
            DotNetDebugProcess dotNetDebugProcess = xDebugSession2 != null ? DotnetDebuggerExtKt.getDotnetDebugProcess(xDebugSession2) : null;
            IDebugProcessWithId iDebugProcessWithId = dotNetDebugProcess instanceof IDebugProcessWithId ? (IDebugProcessWithId)dotNetDebugProcess : null;
            UIUtil.invokeLaterIfNeeded(() -> RiderDebugActiveDotNetSessionsTracker.x(this, iDebugProcessWithId));
            Object object = dotNetDebugProcess;
            if (object == null || (object = object.getProcessHandler()) == null || (object = (File)object.getUserData(DebuggerWorkerProcessHandler.Companion.getLOG_DIR_KEY())) == null || (object = ((File)object).toPath()) == null) break block0;
            DotNetDebugProcess dotNetDebugProcess2 = object;
            boolean bl = false;
            this.lastSessionLogFolder.setValue((Object)dotNetDebugProcess2);
        }
    }

    private final void G(DotNetDebugProcess dotNetDebugProcess) {
        UIUtil.invokeLaterIfNeeded(() -> RiderDebugActiveDotNetSessionsTracker.x(this, dotNetDebugProcess));
    }

    private static final void G(RiderDebugActiveDotNetSessionsTracker riderDebugActiveDotNetSessionsTracker, DotNetDebugProcess dotNetDebugProcess) {
        CollectionExKt.addUnique((Collection)((Collection)riderDebugActiveDotNetSessionsTracker.dotNetDebugProcessSet), (Lifetime)dotNetDebugProcess.getSessionLifetime(), (Object)((Object)dotNetDebugProcess));
    }

    private static final void x(RiderDebugActiveDotNetSessionsTracker riderDebugActiveDotNetSessionsTracker, IDebugProcessWithId iDebugProcessWithId) {
        riderDebugActiveDotNetSessionsTracker.myCurrentSessionId.set((Object)iDebugProcessWithId);
    }

    private static final void x(RiderDebugActiveDotNetSessionsTracker riderDebugActiveDotNetSessionsTracker, DotNetDebugProcess dotNetDebugProcess) {
        riderDebugActiveDotNetSessionsTracker.dotNetDebugProcessSet.remove((Object)dotNetDebugProcess);
    }

    public static final /* synthetic */ void access$onDebugProcessStarted(RiderDebugActiveDotNetSessionsTracker $this, DotNetDebugProcess debugProcess) {
        $this.x(debugProcess);
    }

    public static final /* synthetic */ void access$onCurrentSessionChanged(RiderDebugActiveDotNetSessionsTracker $this, XDebugSession newSession2) {
        $this.x(newSession2);
    }

    public static final /* synthetic */ void access$onDebugProcessTerminated(RiderDebugActiveDotNetSessionsTracker $this, DotNetDebugProcess debugProcess) {
        $this.G(debugProcess);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker$Companion;", "", "RiderDebugActiveDotNetSessionsTracker$Companion", "()V", "getInstance", "Lcom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderDebugActiveDotNetSessionsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,100:1\n17#2,2:101\n*S KotlinDebug\n*F\n+ 1 RiderDebugActiveDotNetSessionsTracker.kt\ncom/jetbrains/rider/debugger/RiderDebugActiveDotNetSessionsTracker$Companion\n*L\n26#1:101,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderDebugActiveDotNetSessionsTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Object object = componentManager.getService(RiderDebugActiveDotNetSessionsTracker.class);
            if (object == null) {
                throw new IllegalStateException("Service " + RiderDebugActiveDotNetSessionsTracker.class + " not found in container " + componentManager);
            }
            return (RiderDebugActiveDotNetSessionsTracker)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

