/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/debugger/DotNetSourcePositionWrapper;", "Lcom/intellij/xdebugger/XSourcePositionWrapper;", "Lcom/intellij/xdebugger/impl/ui/ExecutionPointHighlighter$HighlighterProvider;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "positionProxy", "Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "DotNetSourcePositionWrapper", "(Lcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;)V", "getPositionProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "location", "", "getLocation", "()Ljava/lang/String;", "endOffset", "", "getEndOffset", "()I", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "startOffset", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetSourcePositionWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetSourcePositionWrapper.kt\ncom/jetbrains/rider/debugger/DotNetSourcePositionWrapper\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n13#2:110\n13#3:111\n*S KotlinDebug\n*F\n+ 1 DotNetSourcePositionWrapper.kt\ncom/jetbrains/rider/debugger/DotNetSourcePositionWrapper\n*L\n24#1:110\n24#1:111\n*E\n"})
public final class DotNetSourcePositionWrapper
extends XSourcePositionWrapper
implements ExecutionPointHighlighter.HighlighterProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SourcePositionProxy positionProxy;
    @Nullable
    private final XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint;
    @NotNull
    private static final Logger logger;

    public DotNetSourcePositionWrapper(@NotNull XSourcePosition position, @NotNull SourcePositionProxy positionProxy, @Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)positionProxy, (String)"positionProxy");
        super(position);
        this.positionProxy = positionProxy;
        this.breakpoint = breakpoint;
    }

    public /* synthetic */ DotNetSourcePositionWrapper(XSourcePosition xSourcePosition, SourcePositionProxy sourcePositionProxy, XLineBreakpoint xLineBreakpoint, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            xLineBreakpoint = null;
        }
        this(xSourcePosition, sourcePositionProxy, (XLineBreakpoint<DotNetLineBreakpointProperties>)xLineBreakpoint);
    }

    @NotNull
    public final SourcePositionProxy getPositionProxy() {
        return this.positionProxy;
    }

    @NotNull
    public final String getLocation() {
        return this.positionProxy.getFilename();
    }

    public final int getEndOffset() {
        Document document = FileDocumentManager.getInstance().getDocument(this.getFile());
        if (document == null) {
            return -1;
        }
        Document document2 = document;
        if (this.positionProxy.getEndLine() < 0 || this.positionProxy.getEndColumn() < 0) {
            return -1;
        }
        int n = Math.min(document2.getLineStartOffset(this.positionProxy.getEndLine()) + this.positionProxy.getEndColumn(), document2.getLineEndOffset(this.positionProxy.getEndLine()));
        if (n >= document2.getTextLength()) {
            return -1;
        }
        return n;
    }

    @Nullable
    public TextRange getHighlightRange() {
        if (this.positionProxy.getLine() < 0 || this.positionProxy.getColumn() < 0) {
            logger.debug("Source position is incomplete or invalid to create range: " + IPrintableKt.printToString((Object)this.positionProxy));
            return null;
        }
        return (TextRange)ApplicationKt.getApplication().runReadAction(() -> DotNetSourcePositionWrapper.x(this));
    }

    private final int x(Document document, int n) {
        int n2;
        int n3 = this.positionProxy.getEndLine() >= 0 && this.positionProxy.getEndColumn() >= 0 ? Math.min(document.getLineStartOffset(this.positionProxy.getEndLine()) + this.positionProxy.getEndColumn(), document.getLineEndOffset(this.positionProxy.getEndLine())) : (n2 = document.getLineCount() - 1 <= this.positionProxy.getLine() ? document.getTextLength() - 1 : document.getLineStartOffset(this.positionProxy.getLine() + 1) - 1);
        if (n2 < n) {
            n2 = n;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        while (n2 > n && n2 < string2.length() && CharsKt.isWhitespace((char)string2.charAt(n2 - 1))) {
            --n2;
        }
        return n2;
    }

    private static final TextRange x(DotNetSourcePositionWrapper dotNetSourcePositionWrapper) {
        if (dotNetSourcePositionWrapper.getFile() instanceof LightVirtualFile || dotNetSourcePositionWrapper.getFile() instanceof HttpVirtualFile) {
            return null;
        }
        if (!dotNetSourcePositionWrapper.getFile().isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(dotNetSourcePositionWrapper.getFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (dotNetSourcePositionWrapper.positionProxy.getLine() >= document2.getLineCount()) {
            logger.error("Start line " + dotNetSourcePositionWrapper.positionProxy.getLine() + " is out of document lines " + document2.getLineCount());
            return null;
        }
        int n = document2.getLineStartOffset(dotNetSourcePositionWrapper.positionProxy.getLine()) + dotNetSourcePositionWrapper.positionProxy.getColumn();
        if (n >= document2.getTextLength()) {
            logger.error("Resulting start offset " + n + " is out of document length " + document2.getTextLength());
            return null;
        }
        if (dotNetSourcePositionWrapper.positionProxy.getEndLine() >= document2.getLineCount()) {
            logger.error("End line " + dotNetSourcePositionWrapper.positionProxy.getEndLine() + " is out of document lines " + document2.getLineCount());
            return null;
        }
        int n2 = dotNetSourcePositionWrapper.x(document2, n);
        if (n2 > document2.getTextLength()) {
            logger.error("Resulting end offset " + n2 + " is out of document length " + document2.getTextLength());
            return null;
        }
        TextRange textRange = new TextRange(n, n2);
        Object object = dotNetSourcePositionWrapper.breakpoint;
        TextRange textRange2 = object != null && (object = (DotNetLineBreakpointProperties)object.getProperties()) != null ? ((DotNetLineBreakpointProperties)((Object)object)).getTextRange() : null;
        return textRange2 != null && !Intrinsics.areEqual((Object)textRange2, (Object)textRange) ? null : textRange;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(DotNetSourcePositionWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DotNetSourcePositionWrapper.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/debugger/DotNetSourcePositionWrapper$Companion;", "", "DotNetSourcePositionWrapper$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

