/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.DebuggerInitializingState;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/debugger/DotNetInitializeDebuggerTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "DotNetInitializeDebuggerTask", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "debuggerInitializingState", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rider/debugger/DebuggerInitializingState;", "getDebuggerInitializingState", "()Lcom/jetbrains/rd/util/reactive/Property;", "debuggerStartDate", "Ljava/time/LocalDateTime;", "kotlin.jvm.PlatformType", "debuggerLastMessageTime", "listenForDebuggerOutputMessagesDelay", "", "debuggerInitializationGlobalTimeout", "isCancelled", "", "firstEventReceived", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onFinished", "onCancel", "prolongateTask", "cancel", "intellij.rider"})
public final class DotNetInitializeDebuggerTask
extends Task.Backgroundable {
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final Property<DebuggerInitializingState> debuggerInitializingState;
    private final LocalDateTime debuggerStartDate;
    private LocalDateTime debuggerLastMessageTime;
    private final long listenForDebuggerOutputMessagesDelay;
    private final long debuggerInitializationGlobalTimeout;
    private boolean isCancelled;
    private boolean firstEventReceived;

    public DotNetInitializeDebuggerTask(@NotNull XDebugSession session, @NotNull Lifetime sessionLifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        super(session.getProject(), RiderDebuggerBundle.Companion.message("DotNetInitializeDebuggerTask.progress.title.initializing.debugger", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND);
        this.session = session;
        this.debuggerInitializingState = new Property((Object)DebuggerInitializingState.Initializing);
        this.debuggerStartDate = LocalDateTime.now();
        this.debuggerLastMessageTime = LocalDateTime.now();
        this.listenForDebuggerOutputMessagesDelay = 1000L;
        this.debuggerInitializationGlobalTimeout = 15000L;
        sessionLifetime.onTermination(() -> DotNetInitializeDebuggerTask.x(this));
    }

    @NotNull
    public final Property<DebuggerInitializingState> getDebuggerInitializingState() {
        return this.debuggerInitializingState;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        while (true) {
            LocalDateTime localDateTime = LocalDateTime.now();
            if (this.isCancelled || !this.isHeadless() && !this.debuggerStartDate.isAfter(localDateTime.minus(this.debuggerInitializationGlobalTimeout, ChronoUnit.MILLIS)) || this.firstEventReceived && !this.debuggerLastMessageTime.isAfter(localDateTime.minus(this.listenForDebuggerOutputMessagesDelay, ChronoUnit.MILLIS))) break;
            Thread.sleep(this.listenForDebuggerOutputMessagesDelay);
        }
    }

    public void onFinished() {
        if (!this.isCancelled) {
            this.debuggerInitializingState.set((Object)DebuggerInitializingState.Initialized);
        }
    }

    public void onCancel() {
        this.cancel();
        this.session.stop();
    }

    public final void prolongateTask() {
        this.firstEventReceived = true;
        this.debuggerLastMessageTime = LocalDateTime.now();
    }

    public final void cancel() {
        this.isCancelled = true;
        this.debuggerInitializingState.set((Object)DebuggerInitializingState.Canceled);
    }

    private static final Unit x(DotNetInitializeDebuggerTask dotNetInitializeDebuggerTask) {
        dotNetInitializeDebuggerTask.cancel();
        return Unit.INSTANCE;
    }
}

