/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.debugger.DotNetParallelsStack;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.memoryView.RiderClassesHeapView;
import com.jetbrains.rider.debugger.modulesView.DotNetModulesView;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerTabsStatisticsCollector;
import com.jetbrains.rider.debugger.tasksView.TasksView;
import com.jetbrains.rider.debugger.util.RunnerLayoutUiUtilKt;
import icons.RiderIcons;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001c\u0010\u0011\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0011\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017*\u00020\u0002\u00a8\u0006\u0018"}, d2={"registerParallelStacksTab", "", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "parallelStacksDebugView", "Lcom/jetbrains/rider/debugger/DotNetParallelsStack;", "registerDebugOutputTab", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "registerMemoryViewPanel", "Lcom/intellij/ui/content/Content;", "classesFilteredView", "Lcom/jetbrains/rider/debugger/memoryView/RiderClassesHeapView;", "registerModulesViewTab", "modulesView", "Lcom/jetbrains/rider/debugger/modulesView/DotNetModulesView;", "registerTasksViewTab", "tasksView", "Lcom/jetbrains/rider/debugger/tasksView/TasksView;", "registerStatisticsCollector", "getRunnerContentUi", "Lcom/intellij/execution/ui/layout/impl/RunnerContentUi;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider"})
public final class DotNetDebugTabsRegistatorKt {
    public static final void registerParallelStacksTab(@NotNull RunnerLayoutUi $this$registerParallelStacksTab, @NotNull Lifetime lifetime, @NotNull DotNetParallelsStack parallelStacksDebugView) {
        Intrinsics.checkNotNullParameter((Object)$this$registerParallelStacksTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)parallelStacksDebugView), (String)"parallelStacksDebugView");
        Content content = $this$registerParallelStacksTab.createContent("ParallelStacks", (JComponent)parallelStacksDebugView.getMainComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.parallel.stacks", new Object[0]), RiderIcons.Debugger.ParallelStacks, null);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        $this$registerParallelStacksTab.addListener(new ContentManagerListener(lifetime, content2, parallelStacksDebugView){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ Content $parallelStacksContent;
            final /* synthetic */ DotNetParallelsStack $parallelStacksDebugView;
            {
                this.$lifetime = $lifetime;
                this.$parallelStacksContent = $parallelStacksContent;
                this.$parallelStacksDebugView = $parallelStacksDebugView;
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (RLifetimeKt.isNotAlive((Lifetime)this.$lifetime)) {
                    return;
                }
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                Content content2 = content;
                if (content2 == this.$parallelStacksContent && content2.isSelected()) {
                    this.$parallelStacksDebugView.updateView(false);
                }
            }
        }, (Disposable)content2);
        $this$registerParallelStacksTab.addContent(content2, 3, PlaceInGrid.center, false);
    }

    public static final void registerDebugOutputTab(@NotNull RunnerLayoutUi $this$registerDebugOutputTab, @NotNull Lifetime lifetime, @NotNull ConsoleViewImpl console2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerDebugOutputTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        Content content = $this$registerDebugOutputTab.createContent("DebuggerOutput", console2.getComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.debug.output", new Object[0]), AllIcons.Debugger.Console, console2.getPreferredFocusableComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions((ExecutionConsole)((ExecutionConsole)console2), (Content)content2);
        $this$registerDebugOutputTab.addContent(content2, 2, PlaceInGrid.center, false);
        console2.addChangeListener(new ObservableConsoleView.ChangeListener(content2){
            final /* synthetic */ Content $debuggerOutputConsoleContent;
            {
                this.$debuggerOutputConsoleContent = $debuggerOutputConsoleContent;
            }

            public void contentAdded(Collection<? extends ConsoleViewContentType> types) {
                Intrinsics.checkNotNullParameter(types, (String)"types");
                if (CollectionsKt.contains((Iterable)types, (Object)ConsoleViewContentType.NORMAL_OUTPUT) || CollectionsKt.contains((Iterable)types, (Object)ConsoleViewContentType.ERROR_OUTPUT)) {
                    this.$debuggerOutputConsoleContent.fireAlert();
                }
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    @NotNull
    public static final Content registerMemoryViewPanel(@NotNull RunnerLayoutUi $this$registerMemoryViewPanel, @NotNull Lifetime lifetime, @NotNull RiderClassesHeapView classesFilteredView) {
        Content content;
        Intrinsics.checkNotNullParameter((Object)$this$registerMemoryViewPanel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)classesFilteredView), (String)"classesFilteredView");
        Content content2 = content = $this$registerMemoryViewPanel.createContent("MemoryView", (JComponent)((Object)classesFilteredView), RiderDebuggerBundle.Companion.message("display.name.memory", new Object[0]), RiderIcons.Debugger.MemoryView, null);
        boolean bl = false;
        content2.setCloseable(false);
        content2.setShouldDisposeContent(true);
        Content content3 = content;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"apply(...)");
        Content content4 = content3;
        $this$registerMemoryViewPanel.addContent(content4, 4, PlaceInGrid.center, false);
        RunnerLayoutUiUtilKt.adviseOnSelectionChange($this$registerMemoryViewPanel, lifetime, content4, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> DotNetDebugTabsRegistatorKt.x(classesFilteredView, arg_0)));
        return content4;
    }

    public static final void registerModulesViewTab(@NotNull RunnerLayoutUi $this$registerModulesViewTab, @NotNull DotNetModulesView modulesView) {
        Intrinsics.checkNotNullParameter((Object)$this$registerModulesViewTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modulesView, (String)"modulesView");
        Content content = $this$registerModulesViewTab.createContent("ModulesView", (JComponent)modulesView.getMainComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.modules", new Object[0]), RiderIcons.Debugger.ModulesView, null);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        $this$registerModulesViewTab.addContent(content2, 5, PlaceInGrid.center, false);
    }

    @NotNull
    public static final Content registerTasksViewTab(@NotNull RunnerLayoutUi $this$registerTasksViewTab, @NotNull Lifetime lifetime, @NotNull TasksView tasksView) {
        Intrinsics.checkNotNullParameter((Object)$this$registerTasksViewTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)tasksView), (String)"tasksView");
        Content content = $this$registerTasksViewTab.createContent("TasksView", tasksView.getMainComponent(), RiderDebuggerBundle.Companion.message("tab.display.name.tasks", new Object[0]), RiderIcons.Debugger.Tasks, null);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        $this$registerTasksViewTab.addContent(content2, 6, PlaceInGrid.center, false);
        RunnerLayoutUiUtilKt.adviseOnSelectionChange($this$registerTasksViewTab, lifetime, content2, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> DotNetDebugTabsRegistatorKt.x(tasksView, arg_0)));
        return content2;
    }

    public static final void registerStatisticsCollector(@NotNull RunnerLayoutUi $this$registerStatisticsCollector, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)$this$registerStatisticsCollector, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        $this$registerStatisticsCollector.addListener(new ContentManagerListener(){

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                    return;
                }
                String string = (String)event.getContent().getUserData(ViewImpl.ID);
                if (string == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(RiderDebuggerTabsStatisticsCollector.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Missing View Id for content " + event.getContent().getTabName());
                    string = "UnknownTab";
                }
                RiderDebuggerTabsStatisticsCollector.INSTANCE.debuggerTabSelected(string);
            }
        }, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"Session lifetime nested disposable for tabs statistics"));
    }

    @Nullable
    public static final RunnerContentUi getRunnerContentUi(@NotNull RunnerLayoutUi $this$getRunnerContentUi) {
        Intrinsics.checkNotNullParameter((Object)$this$getRunnerContentUi, (String)"<this>");
        RunnerLayoutUiImpl runnerLayoutUiImpl = $this$getRunnerContentUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)$this$getRunnerContentUi : null;
        return runnerLayoutUiImpl != null ? runnerLayoutUiImpl.getContentUI() : null;
    }

    private static final Unit x(RiderClassesHeapView riderClassesHeapView, boolean bl) {
        riderClassesHeapView.setActive(bl);
        return Unit.INSTANCE;
    }

    private static final Unit x(TasksView tasksView, boolean bl) {
        if (bl) {
            tasksView.activate();
        } else {
            tasksView.deactivate();
        }
        return Unit.INSTANCE;
    }
}

