/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.DFA;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.debugger.DFA.DFAManager;
import com.jetbrains.rider.debugger.DFA.DFAManagerUtilsKt;
import com.jetbrains.rider.debugger.DFA.DFAOperationStatus;
import com.jetbrains.rider.debugger.DFA.DFAOperationStatusKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/DFA/DisableDFAForThisSessionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DisableDFAForThisSessionAction", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "dfaCanShowElementsInEditor", "", "intellij.rider"})
public class DisableDFAForThisSessionAction
extends AnAction {
    @NotNull
    private final Logger logger;

    public DisableDFAForThisSessionAction(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DFAManagerUtilsKt.disableDFAForThisSession(e);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean bl = this.dfaCanShowElementsInEditor(e);
        e.getPresentation().setText(RiderDebuggerBundle.Companion.message("rider.debugger.DFA.mode.exit.debugger.DFA.mode", new Object[0]));
        e.getPresentation().setEnabledAndVisible(bl);
    }

    protected final boolean dfaCanShowElementsInEditor(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        DFAManager dFAManager = DFAManagerUtilsKt.getDFAManager(project);
        if (dFAManager == null) {
            DisableDFAForThisSessionAction disableDFAForThisSessionAction = this;
            boolean bl = false;
            disableDFAForThisSessionAction.logger.trace("No active debug session. Exiting");
            return false;
        }
        DFAManager dFAManager2 = dFAManager;
        if (!DFAOperationStatusKt.canHaveGutterTracker((DFAOperationStatus)((Object)dFAManager2.getDFAOperationStatusSource().getValue()))) {
            this.logger.trace("DFA is not in a state where gutter line can be drown. Exiting");
            return false;
        }
        return true;
    }
}

