/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.ui.old;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.diagnostics.DiagnosticKind;
import com.jetbrains.rider.build.ui.RiderBuildResultTreeNode;
import com.jetbrains.rider.build.ui.old.RiderBuildResultTreeModel;
import com.jetbrains.rider.ui.RiderUI;
import java.awt.Color;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\r\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0016J\u0006\u00100\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/build/ui/old/RiderBuildResultTreePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/ide/CopyProvider;", "project", "Lcom/intellij/openapi/project/Project;", "RiderBuildResultTreePanel", "(Lcom/intellij/openapi/project/Project;)V", "hasError", "", "errors", "Lcom/jetbrains/rider/build/ui/old/RiderBuildResultTreeModel;", "warnings", "activeModel", "hasErrors", "getHasErrors", "()Z", "hasWarnings", "getHasWarnings", "hasEvents", "getHasEvents", "clearTree", "", "getBackground", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "addBuildEvent", "buildEvent", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "hasNextOccurence", "hasPreviousOccurence", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "getNextOccurenceActionName", "", "getPreviousOccurenceActionName", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "performCopy", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyEnabled", "isCopyVisible", "activate", "intellij.rider"})
public final class RiderBuildResultTreePanel
extends BorderLayoutPanel
implements UiDataProvider,
OccurenceNavigator,
CopyProvider {
    @NotNull
    private final Project project;
    private boolean hasError;
    @NotNull
    private final RiderBuildResultTreeModel errors;
    @NotNull
    private final RiderBuildResultTreeModel warnings;
    @NotNull
    private RiderBuildResultTreeModel activeModel;

    public RiderBuildResultTreePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.errors = new RiderBuildResultTreeModel(this.project);
        this.activeModel = this.warnings = new RiderBuildResultTreeModel(this.project);
        this.addToCenter(this.warnings.getTreeScrollPane());
    }

    public final boolean getHasErrors() {
        return this.errors.getRoot().getChildCount() > 0;
    }

    public final boolean getHasWarnings() {
        return this.warnings.getRoot().getChildCount() > 0;
    }

    public final boolean getHasEvents() {
        return this.activeModel.getRoot().getChildCount() > 0;
    }

    public final void clearTree() {
        this.errors.clearTree();
        this.warnings.clearTree();
        this.hasError = false;
        this.activeModel = this.warnings;
        this.remove(0);
        this.addToCenter(this.warnings.getTreeScrollPane());
    }

    @NotNull
    public Color getBackground() {
        return RiderUI.Companion.getUsualBackgroundColor();
    }

    public final void addBuildEvent(@NotNull BuildDiagnostic buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        switch (WhenMappings.$EnumSwitchMapping$0[buildEvent.getKind().ordinal()]) {
            case 1: {
                this.activeModel.addBuildEvent(buildEvent);
                break;
            }
            case 2: {
                if (!this.hasError) {
                    this.hasError = true;
                    this.warnings.clearTree();
                    this.remove(this.warnings.getTreeScrollPane());
                    this.addToCenter(this.errors.getTreeScrollPane());
                    this.activeModel = this.errors;
                    this.activeModel.getTree().updateUI();
                }
                this.activeModel.addBuildEvent(buildEvent);
                break;
            }
            case 3: {
                if (this.hasError) break;
                this.activeModel.addBuildEvent(buildEvent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public boolean hasNextOccurence() {
        return this.activeModel.getNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.activeModel.getNavigator().hasPreviousOccurence();
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.activeModel.getNavigator().goNextOccurence();
    }

    @NotNull
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.activeModel.getNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.activeModel.getNavigator().getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.activeModel.getNavigator().getPreviousOccurenceActionName();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        RiderBuildResultTreeNode riderBuildResultTreeNode = this.activeModel.getSelectedNode();
        DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
        sink.set(dataKey, (Object)this);
        DataKey dataKey2 = LangDataKeys.NO_NEW_ACTION;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"NO_NEW_ACTION");
        sink.set(dataKey2, (Object)true);
        if (riderBuildResultTreeNode == null) {
            return;
        }
        DataKey dataKey3 = CommonDataKeys.NAVIGATABLE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"NAVIGATABLE");
        sink.lazy(dataKey3, () -> RiderBuildResultTreePanel.x(riderBuildResultTreeNode, this));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (((CharSequence)this.activeModel.getTextForCopy()).length() > 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.activeModel.getTextForCopy()));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return ((CharSequence)this.activeModel.getTextForCopy()).length() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final void activate() {
        if (this.activeModel.getTree().getSelectionCount() == 0) {
            TreeUtil.selectFirstNode((JTree)((JTree)this.activeModel.getTree()));
        }
        this.activeModel.getTree().updateUI();
    }

    private static final Navigatable x(RiderBuildResultTreeNode riderBuildResultTreeNode, RiderBuildResultTreePanel riderBuildResultTreePanel) {
        return riderBuildResultTreeNode.createNavigatable(riderBuildResultTreePanel.project);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagnosticKind.values().length];
            try {
                nArray[DiagnosticKind.Reference.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticKind.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticKind.Warning.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

