/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.tasks;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.rider.build.BuildHost;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.tasks.BeforeRunTaskWithProjectProvider;
import com.jetbrains.rider.build.tasks.CleanProjectBeforeRunTask;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.CleanTarget;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfiguration;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/build/tasks/CleanProjectBeforeRunTaskProvider;", "Lcom/jetbrains/rider/build/tasks/BeforeRunTaskWithProjectProvider;", "Lcom/jetbrains/rider/build/tasks/CleanProjectBeforeRunTask;", "CleanProjectBeforeRunTaskProvider", "()V", "baseDescription", "", "Lorg/jetbrains/annotations/Nls;", "getBaseDescription", "()Ljava/lang/String;", "getId", "Lcom/intellij/openapi/util/Key;", "getName", "getIcon", "Ljavax/swing/Icon;", "createTask", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "canExecuteTask", "", "configuration", "task", "executeTask", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nCleanProjectBeforeRunTaskProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanProjectBeforeRunTaskProvider.kt\ncom/jetbrains/rider/build/tasks/CleanProjectBeforeRunTaskProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n1#2:74\n13#3:75\n13#4:76\n*S KotlinDebug\n*F\n+ 1 CleanProjectBeforeRunTaskProvider.kt\ncom/jetbrains/rider/build/tasks/CleanProjectBeforeRunTaskProvider\n*L\n24#1:75\n24#1:76\n*E\n"})
public final class CleanProjectBeforeRunTaskProvider
extends BeforeRunTaskWithProjectProvider<CleanProjectBeforeRunTask> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<CleanProjectBeforeRunTask> providerId;
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    public String getBaseDescription() {
        return RiderBuildBundle.Companion.message("description.clean.project", new Object[0]);
    }

    @NotNull
    public Key<CleanProjectBeforeRunTask> getId() {
        return providerId;
    }

    @NotNull
    public String getName() {
        return RiderBuildBundle.Companion.message("CleanProjectBeforeRunTaskProvider.task.name.clean.project", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public CleanProjectBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        return new CleanProjectBeforeRunTask();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull CleanProjectBeforeRunTask task2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (Boolean)BuildHost.Companion.getInstance(project).getReady().getValue();
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull CleanProjectBeforeRunTask task2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BuildHost buildHost = BuildHost.Companion.getInstance(project);
        RunConfiguration runConfiguration = configuration;
        if (runConfiguration instanceof IProjectBasedRunConfiguration) {
            v1 = CollectionsKt.listOf((Object)((IProjectBasedRunConfiguration)configuration).getProjectFilePath());
        } else if (runConfiguration instanceof RiderMultiPlatformConfiguration) {
            v1 = CollectionsKt.listOf((Object)((RiderMultiPlatformConfiguration)configuration).getParameters().getProjectFilePath().getValue());
        } else {
            Object object = task2.getSelectedProject().getPath();
            if (object != null && (object = ((Object)object.toAbsolutePath()).toString()) != null) {
                Object object2 = object;
                boolean bl = false;
                v1 = CollectionsKt.listOf((Object)object2);
            } else {
                v1 = list2 = null;
            }
        }
        if (list2 == null) {
            logger.warn("projectToBuildPath is null");
            return false;
        }
        if (!((Boolean)buildHost.getReady().getValue()).booleanValue()) {
            logger.warn("buildHost is not ready");
            return false;
        }
        runConfiguration = new Semaphore();
        runConfiguration.down();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        ApplicationKt.getApplication().invokeLater(() -> CleanProjectBeforeRunTaskProvider.x(booleanRef, buildHost, list2, (Semaphore)runConfiguration));
        runConfiguration.waitFor();
        return booleanRef.element;
    }

    private static final void x(Ref.BooleanRef booleanRef, BuildHost buildHost, List list2, Semaphore semaphore) {
        booleanRef.element = buildHost.requestBuild(new BuildParameters((BuildTargetBase)new CleanTarget(), list2, false, false, false, false, false, 124, null), (Function1<? super BuildResultKind, Unit>)((Function1)arg_0 -> CleanProjectBeforeRunTaskProvider.x(booleanRef, semaphore, arg_0)));
    }

    private static final Unit x(Ref.BooleanRef booleanRef, Semaphore semaphore, BuildResultKind buildResultKind) {
        Intrinsics.checkNotNullParameter((Object)buildResultKind, (String)"it");
        booleanRef.element = buildResultKind == BuildResultKind.Successful || buildResultKind == BuildResultKind.HasWarnings;
        semaphore.up();
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"CleanProject");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        providerId = key;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(CleanProjectBeforeRunTaskProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CleanProjectBeforeRunTaskProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/build/tasks/CleanProjectBeforeRunTaskProvider$Companion;", "", "CleanProjectBeforeRunTaskProvider$Companion", "()V", "providerId", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/build/tasks/CleanProjectBeforeRunTask;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProviderId", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<CleanProjectBeforeRunTask> getProviderId() {
            return providerId;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

