/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build.redesign;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.rider.build.BuildEventsService;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.build.redesign.BuildToolwindowWidget;
import com.jetbrains.rider.build.redesign.ProjectKey;
import com.jetbrains.rider.build.ui.RiderBuildResultItemTreeNode;
import com.jetbrains.rider.build.ui.RiderBuildResultProjectTreeNode;
import com.jetbrains.rider.ideaInterop.fileTypes.sln.SolutionFileType;
import com.jetbrains.rider.model.BuildEventKind;
import com.jetbrains.rider.model.BuildEventRef;
import com.jetbrains.rider.model.build.BuildEvent;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J8\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010!\u001a\u00020\u0007H\u0002J\"\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0003J\u0018\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0002J8\u0010,\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u000205H\u0002J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000207H\u0016J\b\u00109\u001a\u00020:H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006;"}, d2={"Lcom/jetbrains/rider/build/redesign/BuildMessagesTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "BuildMessagesTreeCellRenderer", "(Lcom/intellij/openapi/project/Project;)V", "offsetBetweenTextAndFileName", "", "leftAlignedText", "", "getLeftAlignedText", "()Ljava/lang/String;", "setLeftAlignedText", "(Ljava/lang/String;)V", "rightAlignedText", "getRightAlignedText", "setRightAlignedText", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "hasFocus", "x", "node", "Ljavax/swing/tree/TreeNode;", "treeWidth", "x", "x", "buildEvent", "Lcom/jetbrains/rider/model/build/BuildEvent;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventRef", "Lcom/jetbrains/rider/model/BuildEventRef;", "x", "line", "column", "x", "Lcom/jetbrains/rider/build/ui/RiderBuildResultItemTreeNode;", "isSelected", "cellHasFocus", "x", "Ljavax/swing/Icon;", "kind", "Lcom/jetbrains/rider/model/BuildEventKind;", "x", "Lcom/jetbrains/rider/build/ui/RiderBuildResultProjectTreeNode;", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "getLocation", "Ljava/awt/Point;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuildMessagesTreeCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildMessagesTreeCellRenderer.kt\ncom/jetbrains/rider/build/redesign/BuildMessagesTreeCellRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n774#2:237\n865#2,2:238\n1869#2,2:246\n37#3,2:240\n11561#4:242\n11896#4,3:243\n1#5:248\n*S KotlinDebug\n*F\n+ 1 BuildMessagesTreeCellRenderer.kt\ncom/jetbrains/rider/build/redesign/BuildMessagesTreeCellRenderer\n*L\n114#1:237\n114#1:238,2\n127#1:246,2\n114#1:240,2\n127#1:242\n127#1:243,3\n*E\n"})
public final class BuildMessagesTreeCellRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final Project project;
    private final int offsetBetweenTextAndFileName;
    @Nullable
    private String leftAlignedText;
    @Nullable
    private String rightAlignedText;

    public BuildMessagesTreeCellRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.offsetBetweenTextAndFileName = JBUIScale.scale((int)60);
    }

    @Nullable
    public final String getLeftAlignedText() {
        return this.leftAlignedText;
    }

    public final void setLeftAlignedText(@Nullable String string) {
        this.leftAlignedText = string;
    }

    @Nullable
    public final String getRightAlignedText() {
        return this.rightAlignedText;
    }

    public final void setRightAlignedText(@Nullable String string) {
        this.rightAlignedText = string;
    }

    public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        if (this.project.isDisposed()) {
            return;
        }
        if (value2 != null && value2 instanceof TreeNode) {
            int n = tree2.getVisibleRect().width;
            if (n == 0) {
                ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Build");
                Object object = toolWindow;
                n = object != null && (object = object.getComponent()) != null ? ((JComponent)object).getWidth() : 0;
            }
            this.x((TreeNode)value2, selected, hasFocus, n, tree2, row);
            return;
        }
    }

    private final void x(TreeNode treeNode, boolean bl, boolean bl2, int n, JTree jTree, int n2) {
        TreeNode treeNode2 = treeNode;
        if (treeNode2 instanceof RiderBuildResultItemTreeNode) {
            this.x((RiderBuildResultItemTreeNode)treeNode, bl, bl2, n, jTree, n2);
            return;
        }
        if (treeNode2 instanceof RiderBuildResultProjectTreeNode) {
            this.x((RiderBuildResultProjectTreeNode)treeNode);
            return;
        }
    }

    private final int x() {
        return AllIcons.General.Error.getIconWidth() * 3;
    }

    @NlsSafe
    private final String x(BuildEvent buildEvent, VirtualFile virtualFile, BuildEventRef buildEventRef) {
        String string;
        String string2;
        String string3 = string2 = buildEventRef.getOffset() == -1L && buildEventRef.getCustomMessage() != null ? buildEventRef.getCustomMessage() : buildEvent.getMessage();
        if (virtualFile == null) {
            string = string2;
            if (string == null) {
                string = "";
            }
        } else {
            string = String.valueOf(string2);
        }
        return string;
    }

    private final String x(int n, int n2) {
        return n > 0 && n2 > 0 ? "(" + n + ", " + n2 + ")" : (n > 0 ? "(" + n + ")" : "");
    }

    private final void x(RiderBuildResultItemTreeNode riderBuildResultItemTreeNode, boolean bl, boolean bl2, int n, JTree jTree, int n2) {
        String string;
        int n3;
        boolean bl3;
        Object object;
        VirtualFile virtualFile;
        int n4 = jTree.getRowHeight() * n2;
        if (jTree.getVisibleRect().y - jTree.getRowHeight() > n4 || jTree.getVisibleRect().y + jTree.getVisibleRect().height + jTree.getRowHeight() < n4) {
            return;
        }
        this.setIcon(this.x(riderBuildResultItemTreeNode.getEventRef().getKind()));
        BuildEventsService buildEventsService = BuildEventsService.Companion.getInstance(this.project);
        BuildEvent buildEvent = buildEventsService.getEvent(riderBuildResultItemTreeNode.getEventRef().getOffset());
        String string2 = buildEvent.getFilePath();
        boolean bl4 = string2 != null ? ((CharSequence)string2).length() > 0 : false;
        if (bl4 && buildEvent.getProjectId() != null) {
            BuildToolwindowWidget buildToolwindowWidget = riderBuildResultItemTreeNode.getWidget();
            String string3 = buildEvent.getFilePath();
            Intrinsics.checkNotNull((Object)string3);
            Integer n5 = riderBuildResultItemTreeNode.getEventRef().getProjectId();
            Intrinsics.checkNotNull((Object)n5);
            virtualFile = buildToolwindowWidget.resolveSourceFile$intellij_rider(new BuildToolwindowWidget.ProjectFileKey(string3, n5));
        } else {
            virtualFile = null;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string4 = this.x(buildEvent, virtualFile2, riderBuildResultItemTreeNode.getEventRef());
        Object object2 = new char[]{'\r', '\n'};
        object2 = StringsKt.split$default((CharSequence)string4, (char[])object2, (boolean)false, (int)0, (int)6, null);
        int n6 = 0;
        Object object3 = object2;
        Collection collection = new ArrayList();
        int n7 = 0;
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            Object t = object4.next();
            object = (String[])t;
            bl3 = false;
            boolean bl5 = ((CharSequence)object).length() > 0;
            if (!bl5) continue;
            collection.add(t);
        }
        object2 = (List)collection;
        n6 = 0;
        object3 = object2;
        String[] stringArray = object3.toArray(new String[0]);
        VirtualFile virtualFile3 = virtualFile2;
        String string5 = this.rightAlignedText = virtualFile3 != null ? virtualFile3.getName() : null;
        if (this.rightAlignedText == null) {
            this.rightAlignedText = "";
        }
        String string6 = this.rightAlignedText;
        Intrinsics.checkNotNull((Object)string6);
        int n8 = GraphicsUtil.stringWidth((String)string6, (Font)this.getFont());
        n6 = 0;
        n6 = this.getPreferredSize().width - n8;
        if (n6 < 0) {
            n6 = 0;
        }
        int n9 = 0;
        this.leftAlignedText = "";
        int n10 = GraphicsUtil.stringWidth((String)" ", (Font)this.getFont());
        object4 = this;
        int n11 = 0;
        object = stringArray;
        bl3 = false;
        Object object5 = object;
        Collection collection2 = new ArrayList(((String[])object).length);
        boolean bl6 = false;
        int n12 = ((String[])object5).length;
        for (n3 = 0; n3 < n12; ++n3) {
            String string7;
            String string8 = string7 = object5[n3];
            Collection collection3 = collection2;
            boolean bl7 = false;
            collection3.add(((Object)StringsKt.trim((CharSequence)string8)).toString());
        }
        object = (List)collection2;
        bl3 = false;
        object5 = object.iterator();
        while (object5.hasNext()) {
            collection2 = object5.next();
            String string9 = (String)((Object)collection2);
            n3 = 0;
            if (n9 > n6) break;
            String string10 = ((BuildMessagesTreeCellRenderer)((Object)object4)).leftAlignedText;
            Intrinsics.checkNotNull((Object)string10);
            if (!StringsKt.isBlank((CharSequence)string10)) {
                ((BuildMessagesTreeCellRenderer)((Object)object4)).leftAlignedText = ((BuildMessagesTreeCellRenderer)((Object)object4)).leftAlignedText + " ";
                n9 += n10;
            }
            n12 = GraphicsUtil.stringWidth((String)string9, (Font)object4.getFont());
            ((BuildMessagesTreeCellRenderer)((Object)object4)).leftAlignedText = ((BuildMessagesTreeCellRenderer)((Object)object4)).leftAlignedText + string9;
            n9 += n12;
        }
        String string11 = this.leftAlignedText;
        Intrinsics.checkNotNull((Object)string11);
        n7 = GraphicsUtil.stringWidth((String)string11, (Font)this.getFont());
        boolean bl8 = false;
        n11 = 0;
        if (n7 + n8 >= this.getPreferredSize().width) {
            int n13 = this.getPreferredSize().width - n8 - this.offsetBetweenTextAndFileName;
            double d = (double)n13 * 1.0 / (double)n7;
            String string12 = this.leftAlignedText;
            Intrinsics.checkNotNull((Object)string12);
            n11 = MathKt.roundToInt((double)(d * (double)string12.length()));
            if (n11 < 0) {
                return;
            }
            String string13 = this.leftAlignedText;
            Intrinsics.checkNotNull((Object)string13);
            String string14 = string13.substring(0, n11);
            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"substring(...)");
            this.leftAlignedText = string14 + "...";
            bl8 = true;
        }
        if (bl8 || stringArray.length > 1) {
            String string15;
            String string16 = HtmlChunk.raw((String)("<pre>" + XmlStringUtil.escapeString((String)string4) + "</pre>")).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"toString(...)");
            string = string15 = string16;
        } else {
            string = null;
        }
        this.setToolTipText(string);
        String string17 = this.leftAlignedText;
        Intrinsics.checkNotNull((Object)string17);
        this.append(string17);
        String string18 = this.rightAlignedText;
        Intrinsics.checkNotNull((Object)string18);
        this.append(string18, SimpleTextAttributes.GRAYED_ATTRIBUTES, n - this.x() - JBUIScale.scale((int)3), 4);
    }

    private final Icon x(BuildEventKind buildEventKind) {
        if (buildEventKind == BuildEventKind.Error) {
            Icon icon = AllIcons.General.Error;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
            return icon;
        }
        if (buildEventKind == BuildEventKind.Warning) {
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
            return icon;
        }
        if (buildEventKind == BuildEventKind.Reference) {
            Icon icon = AllIcons.General.Information;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Information");
            return icon;
        }
        throw new InvalidDataException("Unknown diagnostic kind");
    }

    private final void x(RiderBuildResultProjectTreeNode riderBuildResultProjectTreeNode) {
        ProjectModelEntity projectModelEntity;
        this.setToolTipText(null);
        Object object = riderBuildResultProjectTreeNode.getProjectKey();
        if (object != null && (object = ((ProjectKey)object).getId()) != null) {
            int n = ((Number)object).intValue();
            boolean bl = false;
            projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project), (int)n);
        } else {
            projectModelEntity = null;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        this.setIcon(projectModelEntity2 == null ? SolutionFileType.INSTANCE.getIcon() : ProjectModelIconsKt.calculateIcon(projectModelEntity2, (Project)this.project));
        Object object2 = projectModelEntity2;
        if (object2 == null || (object2 = object2.getName()) == null) {
            object2 = RiderBuildBundle.Companion.message("BuildEvents.global", new Object[0]);
        }
        this.append((String)object2);
        if (riderBuildResultProjectTreeNode.getShouldDetailTfid()) {
            ProjectKey projectKey = riderBuildResultProjectTreeNode.getProjectKey();
            String string = projectKey != null ? projectKey.getTargetFrameworkId() : null;
            CharSequence charSequence = string;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                this.append(" (" + string + ")");
            }
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.getTree().getRowCount() > 0) {
            dimension = new Dimension(this.getTree().getWidth() - this.x(), super.getPreferredSize().height);
        } else {
            Dimension dimension2 = super.getPreferredSize();
            Intrinsics.checkNotNull((Object)dimension2);
            dimension = dimension2;
        }
        return dimension;
    }

    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @NotNull
    public Point getLocation() {
        return new Point(-this.getPreferredSize().width, -this.getPreferredSize().height);
    }
}

