/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.notification.NotificationType;
import com.jetbrains.rider.build.BuildResultKindHelper;
import com.jetbrains.rider.build.RiderBuildBundle;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.CleanTarget;
import com.jetbrains.rider.model.CustomTarget;
import com.jetbrains.rider.model.RebuildTarget;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001H\u0007\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0007\u00a8\u0006\n"}, d2={"toShortStatusText", "", "Lcom/jetbrains/rider/model/BuildResultKind;", "buildTargetNameNonLocalized", "toStatusText", "buildTargetName", "toNotificationType", "Lcom/intellij/notification/NotificationType;", "toProgressText", "Lcom/jetbrains/rider/model/BuildTargetBase;", "intellij.rider"})
public final class RdBuildExtensionsKt {
    @Nls
    @NotNull
    public static final String toShortStatusText(@NotNull BuildResultKind $this$toShortStatusText, @NotNull String buildTargetNameNonLocalized) {
        Intrinsics.checkNotNullParameter((Object)$this$toShortStatusText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buildTargetNameNonLocalized, (String)"buildTargetNameNonLocalized");
        String string = switch (buildTargetNameNonLocalized) {
            case "Build" -> RiderBuildBundle.Companion.message("RdBuildExtensions.target.build", new Object[0]);
            case "Rebuild" -> RiderBuildBundle.Companion.message("RdBuildExtensions.target.rebuild", new Object[0]);
            case "Clean" -> RiderBuildBundle.Companion.message("RdBuildExtensions.target.clean", new Object[0]);
            default -> buildTargetNameNonLocalized;
        };
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toShortStatusText.ordinal()]) {
            case 1 -> {
                Object[] var4_4 = new Object[]{string};
                yield RiderBuildBundle.Companion.message("RdBuildExtensions.build.result.short.status.text.succeeded", var4_4);
            }
            case 2 -> {
                Object[] var4_5 = new Object[]{string};
                yield RiderBuildBundle.Companion.message("RdBuildExtensions.build.result.short.status.text.failed", var4_5);
            }
            case 3 -> {
                Object[] var4_6 = new Object[]{string};
                yield RiderBuildBundle.Companion.message("RdBuildExtensions.build.result.short.status.text.succeeded.with.warnings", var4_6);
            }
            case 4 -> {
                Object[] var4_7 = new Object[]{string};
                yield RiderBuildBundle.Companion.message("RdBuildExtensions.build.result.short.status.text.canceled", var4_7);
            }
            case 5 -> {
                Object[] var4_8 = new Object[]{string};
                yield RiderBuildBundle.Companion.message("RdBuildExtensions.build.result.short.status.text.crashed", var4_8);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nls
    @NotNull
    public static final String toStatusText(@NotNull BuildResultKind $this$toStatusText, @NotNull String buildTargetName) {
        Intrinsics.checkNotNullParameter((Object)$this$toStatusText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buildTargetName, (String)"buildTargetName");
        Object[] objectArray = new Object[]{RdBuildExtensionsKt.toShortStatusText($this$toStatusText, buildTargetName), BuildResultKindHelper.Companion.currentTime()};
        return RiderBuildBundle.Companion.message("RdBuildExtensions.build.result.status.text", objectArray) + "\n";
    }

    @NotNull
    public static final NotificationType toNotificationType(@NotNull BuildResultKind $this$toNotificationType) {
        Intrinsics.checkNotNullParameter((Object)$this$toNotificationType, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toNotificationType.ordinal()]) {
            case 1 -> NotificationType.INFORMATION;
            case 2 -> NotificationType.ERROR;
            case 3 -> NotificationType.WARNING;
            case 4 -> NotificationType.INFORMATION;
            case 5 -> NotificationType.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nls
    @NotNull
    public static final String toProgressText(@NotNull BuildTargetBase $this$toProgressText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toProgressText, (String)"<this>");
        BuildTargetBase buildTargetBase = $this$toProgressText;
        if (buildTargetBase instanceof BuildTarget) {
            string = RiderBuildBundle.Companion.message("RdBuildExtensions.progress.text.executing.build", new Object[0]);
        } else if (buildTargetBase instanceof RebuildTarget) {
            string = RiderBuildBundle.Companion.message("RdBuildExtensions.progress.text.executing.build", new Object[0]);
        } else if (buildTargetBase instanceof CleanTarget) {
            string = RiderBuildBundle.Companion.message("RdBuildExtensions.progress.text.executing.clean", new Object[0]);
        } else if (buildTargetBase instanceof CustomTarget) {
            Object[] objectArray = new Object[]{((CustomTarget)$this$toProgressText).getTargetName()};
            string = RiderBuildBundle.Companion.message("RdBuildExtensions.progress.text.executing.target", objectArray);
        } else {
            throw new IllegalArgumentException("target");
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildResultKind.values().length];
            try {
                nArray[BuildResultKind.Successful.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildResultKind.HasErrors.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildResultKind.HasWarnings.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildResultKind.Canceled.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildResultKind.Crashed.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

