/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.build;

import com.intellij.util.ObjectUtils;
import com.jetbrains.rd.framework.SerializationCtx;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.build.BuildEventsStorageUtilsKt;
import com.jetbrains.rider.model.build.BuildEvent;
import com.jetbrains.rider.model.build.BuildEventKind;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0010J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/build/InFileBuildEventsLoader;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "storagePath", "", "InFileBuildEventsLoader", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;)V", "myCtx", "Lcom/jetbrains/rd/framework/SerializationCtx;", "myFile", "Ljava/io/RandomAccessFile;", "LOCK", "Lorg/jetbrains/annotations/NotNull;", "myCache", "", "", "Lcom/jetbrains/rider/model/build/BuildEvent;", "OutputErrorEvent", "getOutputErrorEvent", "()Lcom/jetbrains/rider/model/build/BuildEvent;", "loadEvent", "offset", "getLoadedEventsCount", "", "intellij.rider"})
public final class InFileBuildEventsLoader {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final String storagePath;
    @NotNull
    private final SerializationCtx myCtx;
    @Nullable
    private RandomAccessFile myFile;
    @NotNull
    private final Object LOCK;
    @NotNull
    private final Map<Long, BuildEvent> myCache;
    @NotNull
    private final BuildEvent OutputErrorEvent;

    public InFileBuildEventsLoader(@NotNull Lifetime lifetime, @NotNull String storagePath) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        this.lifetime = lifetime;
        this.storagePath = storagePath;
        this.myCtx = BuildEventsStorageUtilsKt.prepareSerializers();
        Object object = ObjectUtils.sentinel((String)"InFileBuildEventsLoader lock");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.LOCK = object;
        this.myCache = new LinkedHashMap();
        this.OutputErrorEvent = new BuildEvent(BuildEventKind.Error, "Check output", null, null, null, null, null, null, null, null, null, null);
    }

    @NotNull
    public final BuildEvent getOutputErrorEvent() {
        return this.OutputErrorEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BuildEvent loadEvent(long offset) {
        if (offset == -1L) {
            return this.OutputErrorEvent;
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (!this.myCache.containsKey(offset)) {
                boolean bl2 = false;
                if (this.myFile == null) {
                    String[] stringArray = new String[]{"events.bin"};
                    this.myFile = new RandomAccessFile(((Object)Paths.get(this.storagePath, stringArray)).toString(), "r");
                    bl2 = !this.lifetime.onTerminationIfAlive(() -> InFileBuildEventsLoader.x(this));
                }
                Long l = offset;
                RandomAccessFile randomAccessFile = this.myFile;
                Intrinsics.checkNotNull((Object)randomAccessFile);
                this.myCache.put(l, BuildEventsStorageUtilsKt.loadBuildEvent(offset, this.myCtx, randomAccessFile));
                if (bl2) {
                    RandomAccessFile randomAccessFile2 = this.myFile;
                    Intrinsics.checkNotNull((Object)randomAccessFile2);
                    randomAccessFile2.close();
                    this.myFile = null;
                }
            }
            BuildEvent buildEvent = this.myCache.get(offset);
            Intrinsics.checkNotNull((Object)buildEvent);
            BuildEvent buildEvent2 = buildEvent;
            return buildEvent2;
        }
    }

    public final int getLoadedEventsCount() {
        return this.myCache.size();
    }

    private static final Unit x(InFileBuildEventsLoader inFileBuildEventsLoader) {
        RandomAccessFile randomAccessFile = inFileBuildEventsLoader.myFile;
        Intrinsics.checkNotNull((Object)randomAccessFile);
        randomAccessFile.close();
        return Unit.INSTANCE;
    }
}

