/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.modulesView.table;

import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B7\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001eH\u0016J\"\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\t2\b\u0010\u0011\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0017\u0010#\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010$R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006%"}, d2={"Lcom/intellij/xdebugger/impl/modulesView/table/FastIndexListTableModel;", "Item", "Lcom/intellij/util/ui/ListTableModel;", "columnNames", "", "Lcom/intellij/util/ui/ColumnInfo;", "items", "", "selectedColumn", "", "FastIndexListTableModel", "([Lcom/intellij/util/ui/ColumnInfo;Ljava/util/List;I)V", "rowIndexMap", "", "x", "", "addRow", "item", "(Ljava/lang/Object;)V", "insertRow", "index", "(ILjava/lang/Object;)V", "removeRow", "idx", "exchangeRows", "idx1", "idx2", "addRows", "", "setItems", "", "setItem", "rowIndex", "x", "startingIndex", "indexOf", "(Ljava/lang/Object;)I", "intellij.platform.debugger.modulesView"})
public class FastIndexListTableModel<Item>
extends ListTableModel<Item> {
    @NotNull
    private final Map<Item, Integer> rowIndexMap;

    public FastIndexListTableModel(@NotNull ColumnInfo<Item, ?>[] columnNames, @NotNull List<Item> items, int selectedColumn) {
        Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        super(columnNames, items, selectedColumn);
        this.rowIndexMap = new HashMap();
        this.x();
    }

    private final void x() {
        this.rowIndexMap.clear();
        int n = ((Collection)this.myItems).size();
        for (int j = 0; j < n; ++j) {
            this.rowIndexMap.put(this.myItems.get(j), j);
        }
    }

    public void addRow(Item item) {
        this.myItems.add(item);
        this.rowIndexMap.put(item, this.myItems.size() - 1);
        this.fireTableRowsInserted(this.myItems.size() - 1, this.myItems.size() - 1);
    }

    public void insertRow(int index, Item item) {
        this.myItems.add(index, item);
        this.x(index);
        this.fireTableRowsInserted(index, index);
    }

    public void removeRow(int idx) {
        Object e = this.myItems.get(idx);
        this.myItems.remove(idx);
        TypeIntrinsics.asMutableMap(this.rowIndexMap).remove(e);
        this.x(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    public void exchangeRows(int idx1, int idx2) {
        Collections.swap(this.myItems, idx1, idx2);
        this.rowIndexMap.put(this.myItems.get(idx1), idx1);
        this.rowIndexMap.put(this.myItems.get(idx2), idx2);
        if (idx1 < idx2) {
            this.fireTableRowsUpdated(idx1, idx2);
        } else {
            this.fireTableRowsUpdated(idx2, idx1);
        }
    }

    public void addRows(@NotNull Collection<? extends Item> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (items.isEmpty()) {
            return;
        }
        int n = this.myItems.size();
        this.myItems.addAll(items);
        int n2 = n;
        for (Item Item2 : items) {
            this.rowIndexMap.put(Item2, n2++);
        }
        this.fireTableRowsInserted(n, this.myItems.size() - 1);
    }

    public void setItems(@NotNull List<? extends Item> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.myItems = items;
        this.x();
        this.fireTableDataChanged();
    }

    public void setItem(int rowIndex, @NotNull Item item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Object e = this.myItems.get(rowIndex);
        this.myItems.set(rowIndex, item);
        TypeIntrinsics.asMutableMap(this.rowIndexMap).remove(e);
        this.rowIndexMap.put(item, rowIndex);
        this.fireTableCellUpdated(rowIndex, -1);
    }

    private final void x(int n) {
        int n2 = this.myItems.size();
        for (int j = n; j < n2; ++j) {
            this.rowIndexMap.put(this.myItems.get(j), j);
        }
    }

    public int indexOf(@Nullable Item item) {
        Integer n = this.rowIndexMap.get(item);
        return n != null ? n : -1;
    }
}

