/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.customization.dotUltimate;

import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.rider.customization.dotUltimate.DULPromoManagerKt;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/rider/customization/dotUltimate/DULPromoRequestHandler;", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/ClassLoader;)V", "shouldInterceptRequest", "", "request", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceRequest;", "handleResourceRequest", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceResponse;", "(Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$ResourceHandler$ResourceRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMIMEType", "", "extension", "intellij.rider.customization.dotUltimate"})
@SourceDebugExtension(value={"SMAP\nDULPromoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DULPromoManager.kt\ncom/intellij/rider/customization/dotUltimate/DULPromoRequestHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,369:1\n1#2:370\n*E\n"})
final class DULPromoRequestHandler
implements HTMLEditorProvider.ResourceHandler {
    @NotNull
    private final ClassLoader classLoader;

    public DULPromoRequestHandler(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
    }

    public boolean shouldInterceptRequest(@NotNull HTMLEditorProvider.ResourceHandler.ResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URI uri = request.getUri();
        return uri.getScheme().equals("dul-promo-vision") && uri.getHost().equals("localhost");
    }

    @Nullable
    public Object handleResourceRequest(@NotNull HTMLEditorProvider.ResourceHandler.ResourceRequest request, @NotNull Continuation<? super HTMLEditorProvider.ResourceHandler.ResourceResponse> $completion) {
        String string = request.getUri().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        char[] cArray = new char[]{'/'};
        String resourceName = StringsKt.trim((String)string, (char[])cArray);
        InputStream contentResource = this.classLoader.getResourceAsStream("DULPromo/" + resourceName);
        if (contentResource == null) {
            return HTMLEditorProvider.ResourceHandler.ResourceResponse.NotFound.INSTANCE;
        }
        String string2 = request.getUri().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        Object object = NioPathUtil.toNioPathOrNull((String)string2);
        if (object == null || (object = PathsKt.getExtension((Path)object)) == null) {
            object = "";
        }
        String mimeType = this.getMIMEType((String)object);
        HTMLEditorProvider.ResourceHandler.Resource resource2 = new HTMLEditorProvider.ResourceHandler.Resource(mimeType, contentResource){
            final /* synthetic */ String $mimeType;
            final /* synthetic */ InputStream $contentResource;
            {
                this.$mimeType = $mimeType;
                this.$contentResource = $contentResource;
            }

            public String getMimeType() {
                return this.$mimeType;
            }

            public Object getResourceStream(Continuation<? super InputStream> $completion) {
                return this.$contentResource;
            }
        };
        return new HTMLEditorProvider.ResourceHandler.ResourceResponse.HandleResource(resource2);
    }

    private final String getMIMEType(String extension) {
        return switch (extension) {
            case "gif" -> "image/gif";
            case "png" -> "image/png";
            case "jpg", "jpeg" -> "image/jpeg";
            case "svg" -> "image/svg+xml";
            case "mp4" -> "video/mp4";
            case "webm" -> "video/webm";
            case "webp" -> "image/webp";
            default -> {
                String var3_3;
                String it = var3_3 = "";
                boolean $i$a$-also-DULPromoRequestHandler$getMIMEType$1 = false;
                DULPromoManagerKt.access$getLogger$p().warn("Unknown file extension: '" + extension + "' for MIME type. Falling back to '" + it + "'.");
                yield var3_3;
            }
        };
    }
}

