/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.vfs;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.sqlproj.generated.RdRefreshFileSystemRequest;
import com.jetbrains.rider.sqlproj.host.SqlProjHost;
import com.jetbrains.rider.sqlproj.host.extensions.SqlprojHostStartedListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fJ2\u0010\u0010\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J$\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/sqlproj/vfs/FileSystemRefresher;", "Lcom/jetbrains/rider/sqlproj/host/extensions/SqlprojHostStartedListener;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "onCreated", "", "host", "Lcom/jetbrains/rider/sqlproj/host/SqlProjHost;", "refresh", "addedFiles", "", "", "removedFiles", "updatedFiles", "addAddedAndUpdatedFilesToRefresh", "filesToRefresh", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "addDeletedFilesToRefresh", "files", "", "findValidParent", "file", "Ljava/nio/file/Path;", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nFileSystemRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemRefresher.kt\ncom/jetbrains/rider/sqlproj/vfs/FileSystemRefresher\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,46:1\n37#2,2:47\n1625#3:49\n1869#3:50\n1870#3:52\n1626#3:53\n1625#3:54\n1869#3:55\n1870#3:57\n1626#3:58\n1#4:51\n1#4:56\n183#5,2:59\n*S KotlinDebug\n*F\n+ 1 FileSystemRefresher.kt\ncom/jetbrains/rider/sqlproj/vfs/FileSystemRefresher\n*L\n29#1:47,2\n33#1:49\n33#1:50\n33#1:52\n33#1:53\n39#1:54\n39#1:55\n39#1:57\n39#1:58\n33#1:51\n39#1:56\n45#1:59,2\n*E\n"})
public final class FileSystemRefresher
implements SqlprojHostStartedListener {
    @NotNull
    private final CoroutineScope scope;

    public FileSystemRefresher(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    @Override
    public void onCreated(@NotNull SqlProjHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        host.getModel().getRefreshFileSystem().advise(host.getLifetime(), arg_0 -> FileSystemRefresher.onCreated$lambda$0(this, arg_0));
    }

    public final void refresh(@NotNull List<String> addedFiles, @NotNull List<String> removedFiles, @NotNull List<String> updatedFiles) {
        VirtualFile[] virtualFileArray;
        Intrinsics.checkNotNullParameter(addedFiles, (String)"addedFiles");
        Intrinsics.checkNotNullParameter(removedFiles, (String)"removedFiles");
        Intrinsics.checkNotNullParameter(updatedFiles, (String)"updatedFiles");
        VirtualFile[] $this$refresh_u24lambda_u241 = virtualFileArray = (VirtualFile[])new LinkedHashSet();
        boolean bl = false;
        this.addDeletedFilesToRefresh((Collection<String>)removedFiles, (Set<VirtualFile>)$this$refresh_u24lambda_u241);
        this.addAddedAndUpdatedFilesToRefresh(addedFiles, updatedFiles, (Set<VirtualFile>)$this$refresh_u24lambda_u241);
        VirtualFile[] filesToRefresh = virtualFileArray;
        Collection $this$toTypedArray$iv = (Collection)filesToRefresh;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    private final void addAddedAndUpdatedFilesToRefresh(List<String> addedFiles, List<String> updatedFiles, Set<VirtualFile> filesToRefresh) {
        Iterable $this$mapNotNullTo$iv = CollectionsKt.union((Iterable)addedFiles, (Iterable)updatedFiles);
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Path path = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            if (localFileSystem.findFileByNioFile(path) == null) continue;
            boolean bl3 = false;
            ((Collection)filesToRefresh).add(it$iv);
        }
    }

    private final void addDeletedFilesToRefresh(Collection<String> files, Set<VirtualFile> filesToRefresh) {
        Iterable $this$mapNotNullTo$iv = files;
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            Path path = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            if (this.findValidParent(path.getParent()) == null) continue;
            boolean bl3 = false;
            ((Collection)filesToRefresh).add(it$iv);
        }
    }

    private final VirtualFile findValidParent(Path file) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)file, FileSystemRefresher::findValidParent$lambda$4), FileSystemRefresher::findValidParent$lambda$5);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Unit onCreated$lambda$0(FileSystemRefresher this$0, RdRefreshFileSystemRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)this$0.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, it, null){
            int label;
            final /* synthetic */ FileSystemRefresher this$0;
            final /* synthetic */ RdRefreshFileSystemRequest $it;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.refresh(this.$it.getAddedFiles(), this.$it.getRemovedFiles(), this.$it.getUpdatedFiles());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Path findValidParent$lambda$4(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final VirtualFile findValidParent$lambda$5(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocalFileSystem.getInstance().findFileByNioFile(it);
    }
}

