/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.variables;

import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.jetbrains.rider.sqlproj.SqlprojBundle;
import com.jetbrains.rider.sqlproj.variables.VariableDialogModel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H$J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0015*\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/sqlproj/variables/ModifyVariableDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "dialogTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "variableName", "defaultValue", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "viewModel", "Lcom/jetbrains/rider/sqlproj/variables/VariableDialogModel;", "getViewModel", "()Lcom/jetbrains/rider/sqlproj/variables/VariableDialogModel;", "nameRegex", "Lkotlin/text/Regex;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "performModification", "variableNameTextField", "Lcom/intellij/ui/dsl/builder/Row;", "variableValueTextField", "sqlproj-plugin"})
public abstract class ModifyVariableDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final VariableDialogModel viewModel;
    @NotNull
    private final Regex nameRegex;

    public ModifyVariableDialog(@NotNull String dialogTitle, @NotNull Project project, @Nullable String variableName, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.viewModel = new VariableDialogModel(variableName, defaultValue);
        this.nameRegex = new Regex("^[a-zA-Z][a-zA-Z0-9_]*$");
        this.setTitle(dialogTitle);
        this.setModal(true);
        this.init();
    }

    public /* synthetic */ ModifyVariableDialog(String string, Project project, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        this(string, project, string2, string3);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final VariableDialogModel getViewModel() {
        return this.viewModel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> ModifyVariableDialog.createCenterPanel$lambda$2(this, arg_0));
    }

    protected void doOKAction() {
        this.performModification();
        this.close(0, ExitActionType.OK);
    }

    protected abstract void performModification();

    private final void variableNameTextField(Row $this$variableNameTextField) {
        TextFieldKt.bindText((Cell)$this$variableNameTextField.textField(), (ObservableMutableProperty)((ObservableMutableProperty)this.viewModel.getVariableName())).validationInfo((arg_0, arg_1) -> ModifyVariableDialog.variableNameTextField$lambda$3(this, arg_0, arg_1));
    }

    private final void variableValueTextField(Row $this$variableValueTextField) {
        TextFieldKt.bindText((Cell)$this$variableValueTextField.textField(), (ObservableMutableProperty)((ObservableMutableProperty)this.viewModel.getDefaultValue())).validationInfo(ModifyVariableDialog::variableValueTextField$lambda$4);
    }

    private static final Unit createCenterPanel$lambda$2$lambda$0(ModifyVariableDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.variableNameTextField($this$row);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$2$lambda$1(ModifyVariableDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.variableValueTextField($this$row);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$2(ModifyVariableDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(SqlprojBundle.message("variable.name", new Object[0]), arg_0 -> ModifyVariableDialog.createCenterPanel$lambda$2$lambda$0(this$0, arg_0));
        $this$panel.row(SqlprojBundle.message("variable.default.value", new Object[0]), arg_0 -> ModifyVariableDialog.createCenterPanel$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo variableNameTextField$lambda$3(ModifyVariableDialog this$0, ValidationInfoBuilder $this$validationInfo, JBTextField it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$validationInfo, (String)"$this$validationInfo");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            object = $this$validationInfo.error(SqlprojBundle.message("variable.name.not.empty", new Object[0]));
        } else {
            Regex regex = this$0.nameRegex;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            object = !regex.matches((CharSequence)string) ? $this$validationInfo.error(SqlprojBundle.message("variable.name.is.invalid", new Object[0])) : null;
        }
        return object;
    }

    private static final ValidationInfo variableValueTextField$lambda$4(ValidationInfoBuilder $this$validationInfo, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationInfo, (String)"$this$validationInfo");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getText();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? $this$validationInfo.error(SqlprojBundle.message("variable.default.value.not.empty", new Object[0])) : null;
    }
}

