/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.utils;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.sqlproj.SqlprojBundle;
import com.jetbrains.rider.sqlproj.utils.SqlProjException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u001a,\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u0014\u001a\u00020\u00122\b\b\u0001\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0018"}, d2={"SQL_PROJ_WORKER", "Lcom/intellij/notification/NotificationGroup;", "getSQL_PROJ_WORKER", "()Lcom/intellij/notification/NotificationGroup;", "showNotificationThatWorkerFailedToStart", "", "project", "Lcom/intellij/openapi/project/Project;", "failureReason", "", "showNotificationThatPublishSessionFailed", "showNotificationThatConversionToCrossPlatformSucceeded", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "showNotificationThatConversionToCrossPlatformFailed", "showNotificationThatInclusionFailed", "blockingDependencies", "", "", "showNotification", "title", "content", "type", "Lcom/intellij/notification/NotificationType;", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Notifications.kt\ncom/jetbrains/rider/sqlproj/utils/NotificationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1869#2,2:86\n*S KotlinDebug\n*F\n+ 1 Notifications.kt\ncom/jetbrains/rider/sqlproj/utils/NotificationsKt\n*L\n68#1:86,2\n*E\n"})
public final class NotificationsKt {
    @NotNull
    private static final NotificationGroup SQL_PROJ_WORKER;

    @NotNull
    public static final NotificationGroup getSQL_PROJ_WORKER() {
        return SQL_PROJ_WORKER;
    }

    public static final void showNotificationThatWorkerFailedToStart(@NotNull Project project, @NotNull Throwable failureReason) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)failureReason, (String)"failureReason");
        String defaultMessage = SqlprojBundle.message("sql.projects.worker.failed.to.start", new Object[0]);
        Throwable throwable = failureReason;
        if (throwable instanceof TimeoutException) {
            string = SqlprojBundle.message("sqlproj.worker.startupStatus.failure.notification.content.timeout", new Object[0]);
        } else if (throwable instanceof SqlProjException) {
            string = failureReason.getMessage();
            if (string == null) {
                string = defaultMessage;
            }
        } else {
            string = defaultMessage;
        }
        String message = string;
        NotificationsKt.showNotification(project, SqlprojBundle.message("sqlproj.worker.startupStatus.failure.notification.title", new Object[0]), message, NotificationType.ERROR);
    }

    public static final void showNotificationThatPublishSessionFailed(@NotNull Project project, @NotNull Throwable failureReason) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)failureReason, (String)"failureReason");
        String defaultMessage = SqlprojBundle.message("unknown.error.occurred", new Object[0]);
        if (failureReason instanceof SqlProjException) {
            string = failureReason.getMessage();
            if (string == null) {
                string = defaultMessage;
            }
        } else {
            string = defaultMessage;
        }
        String message = string;
        NotificationsKt.showNotification(project, SqlprojBundle.message("notification.title.failed.to.start.publishing.project", new Object[0]), message, NotificationType.ERROR);
    }

    public static final void showNotificationThatConversionToCrossPlatformSucceeded(@NotNull Project project, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NotificationsKt.showNotification(project, "Success", entity.getName() + " was successfully converted to a cross-platform project", NotificationType.INFORMATION);
    }

    public static final void showNotificationThatConversionToCrossPlatformFailed(@NotNull Project project, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NotificationsKt.showNotification(project, "Failure", "Failed to convert " + entity.getName() + " to a cross-platform project", NotificationType.ERROR);
    }

    public static final void showNotificationThatInclusionFailed(@NotNull Project project, @NotNull List<String> blockingDependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(blockingDependencies, (String)"blockingDependencies");
        StringBuilder builder = new StringBuilder();
        if (blockingDependencies.isEmpty()) {
            builder.append("Included dependents exist");
        } else {
            builder.append("Included dependents exist, such as:<br>");
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)blockingDependencies, (int)3);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                builder.append("- " + it + "<br>");
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        NotificationsKt.showNotification(project, "Node inclusion can't be changed", string, NotificationType.ERROR);
    }

    private static final void showNotification(Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String content, NotificationType type) {
        SQL_PROJ_WORKER.createNotification(title, content, type).notify(project);
    }

    static {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Startup status of Sqlproj Worker");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        SQL_PROJ_WORKER = notificationGroup;
    }
}

