/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.utils;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mssql.MsDialectBase;
import com.intellij.sql.psi.SqlLanguage;
import com.jetbrains.rider.ideaInterop.fileTypes.msbuild.SqlprojFileType;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.sqlproj.generated.RdSqlProject;
import com.jetbrains.rider.sqlproj.host.SqlProjHost;
import com.jetbrains.rider.sqlproj.host.SqlProjectWorkerManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\u0006\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u0006\u001a\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0005*\u00020\u0006\u001a\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0015\u001a\u0012\u0010\u0016\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0017"}, d2={"knownBuildActions", "", "", "[Ljava/lang/String;", "isDatabaseProject", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isUnloadedDatabaseProject", "shouldBeSynced", "getFileStructure", "isFileWithMsDialect", "psiFile", "Lcom/intellij/psi/PsiFile;", "isFileWithSqlDialect", "projectEntityNeedsBinding", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isSqlProjFileToBind", "isCrossPlatformSqlProject", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;", "isSqlProjectReady", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseExtensions.kt\ncom/jetbrains/rider/sqlproj/utils/DatabaseExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,69:1\n12970#2,2:70\n1761#3,3:72\n30#4,2:75\n30#4,2:77\n*S KotlinDebug\n*F\n+ 1 DatabaseExtensions.kt\ncom/jetbrains/rider/sqlproj/utils/DatabaseExtensionsKt\n*L\n33#1:70,2\n52#1:72,3\n61#1:75,2\n67#1:77,2\n*E\n"})
public final class DatabaseExtensionsKt {
    @NotNull
    private static final String[] knownBuildActions;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDatabaseProject(@NotNull ProjectModelEntity $this$isDatabaseProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isDatabaseProject, (String)"<this>");
        if (!ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)$this$isDatabaseProject)) return false;
        VirtualFileUrl virtualFileUrl = $this$isDatabaseProject.getUrl();
        Object object = virtualFileUrl;
        if (virtualFileUrl == null) return false;
        String string = object.getFileName();
        object = string;
        if (string == null) return false;
        if (!StringsKt.endsWith((String)object, (String)SqlprojFileType.INSTANCE.getDefaultExtension(), (boolean)true)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isUnloadedDatabaseProject(@NotNull ProjectModelEntity $this$isUnloadedDatabaseProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnloadedDatabaseProject, (String)"<this>");
        if (!ProjectModelEntityExtensionsKt.isUnloadedProject((ProjectModelEntity)$this$isUnloadedDatabaseProject)) return false;
        VirtualFileUrl virtualFileUrl = $this$isUnloadedDatabaseProject.getUrl();
        Object object = virtualFileUrl;
        if (virtualFileUrl == null) return false;
        String string = object.getFileName();
        object = string;
        if (string == null) return false;
        if (!StringsKt.endsWith((String)object, (String)SqlprojFileType.INSTANCE.getDefaultExtension(), (boolean)true)) return false;
        return true;
    }

    public static final boolean shouldBeSynced(@NotNull ProjectModelEntity $this$shouldBeSynced) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$shouldBeSynced, (String)"<this>");
            RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$shouldBeSynced.getDescriptor();
            RdProjectFileDescriptor rdProjectFileDescriptor = rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? (RdProjectFileDescriptor)rdProjectModelItemDescriptor : null;
            if (rdProjectFileDescriptor == null) {
                return false;
            }
            RdProjectFileDescriptor descriptor = rdProjectFileDescriptor;
            String[] $this$any$iv = knownBuildActions;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.equals((String)it, (String)descriptor.getBuildAction(), (boolean)true)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final String getFileStructure(@NotNull ProjectModelEntity $this$getFileStructure) {
        Intrinsics.checkNotNullParameter((Object)$this$getFileStructure, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$getFileStructure.getDescriptor();
        RdProjectDescriptor rdProjectDescriptor = rdProjectModelItemDescriptor instanceof RdProjectDescriptor ? (RdProjectDescriptor)rdProjectModelItemDescriptor : null;
        return rdProjectDescriptor != null ? ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((RdProjectModelItemDescriptor)rdProjectDescriptor), (String)"DefaultFileStructure") : null;
    }

    public static final boolean isFileWithMsDialect(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile.getLanguage() instanceof MsDialectBase;
    }

    public static final boolean isFileWithSqlDialect(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile.getLanguage() instanceof SqlLanguageDialect || psiFile.getLanguage() instanceof SqlLanguage;
    }

    public static final boolean projectEntityNeedsBinding(@NotNull VirtualFile file, @NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$any$iv = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)file, (Project)project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProjectModelEntity it = (ProjectModelEntity)element$iv;
                    boolean bl2 = false;
                    if (!DatabaseExtensionsKt.isSqlProjFileToBind(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isSqlProjFileToBind(@NotNull ProjectModelEntity $this$isSqlProjFileToBind) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$isSqlProjFileToBind, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isSqlProjFileToBind.getDescriptor();
        boolean bl = false;
        return it instanceof RdProjectFileDescriptor && !((charSequence = (CharSequence)ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)$this$isSqlProjFileToBind.getDescriptor(), (String)"SqlProj.DocumentToBind")) == null || charSequence.length() == 0);
    }

    @Nullable
    public static final Boolean isCrossPlatformSqlProject(@NotNull ProjectModelEntity $this$isCrossPlatformSqlProject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isCrossPlatformSqlProject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!DatabaseExtensionsKt.isDatabaseProject($this$isCrossPlatformSqlProject) && !DatabaseExtensionsKt.isUnloadedDatabaseProject($this$isCrossPlatformSqlProject)) {
            return null;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SqlProjectWorkerManager> serviceClass$iv = SqlProjectWorkerManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        SqlProjHost sqlProjHost = ((SqlProjectWorkerManager)((Object)object)).tryGetHost();
        if (sqlProjHost == null) {
            return null;
        }
        SqlProjHost host = sqlProjHost;
        RdSqlProject rdSqlProject = host.getSqlProject($this$isCrossPlatformSqlProject);
        if (rdSqlProject == null) {
            return null;
        }
        RdSqlProject sqlProject = rdSqlProject;
        return sqlProject.isCrossPlatform();
    }

    public static final boolean isSqlProjectReady(@NotNull ProjectModelEntity $this$isSqlProjectReady, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isSqlProjectReady, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SqlProjectWorkerManager> serviceClass$iv = SqlProjectWorkerManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        SqlProjHost sqlProjHost = ((SqlProjectWorkerManager)((Object)object)).tryGetHost();
        if (sqlProjHost == null) {
            return false;
        }
        SqlProjHost host = sqlProjHost;
        return host.isProjectLoaded($this$isSqlProjectReady);
    }

    static {
        String[] stringArray = new String[]{"Build", "Content"};
        knownBuildActions = stringArray;
    }
}

