/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.services.tree.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.jetbrains.rider.sqlproj.generated.RdOutputKind;
import com.jetbrains.rider.sqlproj.services.tree.nodes.SqlProjOperationsTreeNode;
import icons.ReSharperIcons;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/sqlproj/services/tree/nodes/SqlProjOperationMessageTreeNode;", "Lcom/jetbrains/rider/sqlproj/services/tree/nodes/SqlProjOperationsTreeNode;", "message", "", "kind", "Lcom/jetbrains/rider/sqlproj/generated/RdOutputKind;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/sqlproj/generated/RdOutputKind;)V", "getMessage", "()Ljava/lang/String;", "getKind", "()Lcom/jetbrains/rider/sqlproj/generated/RdOutputKind;", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "render", "", "renderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "isUnderMouse", "", "getSeverityIcon", "Ljavax/swing/Icon;", "sqlproj-plugin"})
public final class SqlProjOperationMessageTreeNode
implements SqlProjOperationsTreeNode {
    @NotNull
    private final String message;
    @NotNull
    private final RdOutputKind kind;
    @NotNull
    private final UUID id;

    public SqlProjOperationMessageTreeNode(@NotNull String message, @NotNull RdOutputKind kind) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.message = message;
        this.kind = kind;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.id = uUID;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final RdOutputKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.id;
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer2, boolean isUnderMouse) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        renderer2.setIcon(this.getSeverityIcon());
        renderer2.append(this.message);
    }

    private final Icon getSeverityIcon() {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                Icon icon2 = AllIcons.General.Error;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Error");
                break;
            }
            case 2: {
                Icon icon3 = ReSharperIcons.Common.Warning;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Warning");
                break;
            }
            case 3: {
                Icon icon4 = AllIcons.General.Information;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Information");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdOutputKind.values().length];
            try {
                nArray[RdOutputKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdOutputKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdOutputKind.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

