/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.services.tree.nodes;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.sqlproj.generated.RdOperationOutput;
import com.jetbrains.rider.sqlproj.generated.RdOperationStatus;
import com.jetbrains.rider.sqlproj.operations.SqlProjOperation;
import com.jetbrains.rider.sqlproj.services.IconsKt;
import com.jetbrains.rider.sqlproj.services.tree.SqlProjOperationsTreeModel;
import com.jetbrains.rider.sqlproj.services.tree.links.ClickableNodeLink;
import com.jetbrains.rider.sqlproj.services.tree.nodes.SqlProjOperationsTreeNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u001d*\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010\u00112\b\u0010$\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0011H\u0003J\u0012\u0010'\u001a\u00020\u001d*\u00020\u001f2\u0006\u0010 \u001a\u00020!J\n\u0010(\u001a\u0004\u0018\u00010)H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/sqlproj/services/tree/nodes/OperationTreeNode;", "Lcom/jetbrains/rider/sqlproj/services/tree/nodes/SqlProjOperationsTreeNode;", "operation", "Lcom/jetbrains/rider/sqlproj/operations/SqlProjOperation;", "model", "Lcom/jetbrains/rider/sqlproj/services/tree/SqlProjOperationsTreeModel;", "<init>", "(Lcom/jetbrains/rider/sqlproj/operations/SqlProjOperation;Lcom/jetbrains/rider/sqlproj/services/tree/SqlProjOperationsTreeModel;)V", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "operationName", "", "getOperationName", "()Ljava/lang/String;", "startTime", "Ljava/util/Date;", "getStartTime", "()Ljava/util/Date;", "endTime", "getEndTime", "status", "Ljava/util/EnumSet;", "Lcom/jetbrains/rider/sqlproj/generated/RdOperationStatus;", "Lcom/jetbrains/rd/util/EnumSet;", "getStatus", "()Ljava/util/EnumSet;", "render", "", "renderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "isUnderMouse", "", "appendTime", "start", "end", "formatAsTime", "date", "appendResultLink", "getResultLink", "Lcom/jetbrains/rider/sqlproj/services/tree/links/ClickableNodeLink;", "Companion", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nOperationTreeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperationTreeNode.kt\ncom/jetbrains/rider/sqlproj/services/tree/nodes/OperationTreeNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public class OperationTreeNode
implements SqlProjOperationsTreeNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SqlProjOperation operation;
    @NotNull
    private final SqlProjOperationsTreeModel model;
    @NotNull
    private final UUID id;
    @NotNull
    private final String operationName;
    @NotNull
    private static final SimpleTextAttributes INACTIVE_LINK_ATTRS;
    @NotNull
    private static final SimpleTextAttributes ACTIVE_LINK_ATTRS;

    public OperationTreeNode(@NotNull SqlProjOperation operation, @NotNull SqlProjOperationsTreeModel model) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.operation = operation;
        this.model = model;
        this.id = this.operation.getId();
        this.operationName = this.operation.getName();
        this.operation.getStatus().getChange().advise(this.operation.getLifetime(), arg_0 -> OperationTreeNode._init_$lambda$0(this, arg_0));
        this.operation.getStartTime().getChange().advise(this.operation.getLifetime(), arg_0 -> OperationTreeNode._init_$lambda$1(this, arg_0));
        this.operation.getEndTime().getChange().advise(this.operation.getLifetime(), arg_0 -> OperationTreeNode._init_$lambda$2(this, arg_0));
        this.operation.getOutput().view(this.operation.getLifetime(), (arg_0, arg_1, arg_2) -> OperationTreeNode._init_$lambda$3(this, arg_0, arg_1, arg_2));
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.id;
    }

    @NotNull
    public final String getOperationName() {
        return this.operationName;
    }

    @Nullable
    public final Date getStartTime() {
        return (Date)this.operation.getStartTime().getValueOrNull();
    }

    @Nullable
    public final Date getEndTime() {
        return (Date)this.operation.getEndTime().getValueOrNull();
    }

    @NotNull
    public final EnumSet<RdOperationStatus> getStatus() {
        return this.operation.getCurrentStatus();
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer2, boolean isUnderMouse) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        renderer2.append(this.operationName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendTime(renderer2, this.getStartTime(), this.getEndTime());
        this.appendResultLink(renderer2, isUnderMouse);
        renderer2.setIcon(IconsKt.getStatusIcon(this.operation));
    }

    private final void appendTime(ColoredTreeCellRenderer $this$appendTime, Date start2, Date end) {
        block2: {
            Object object;
            String startTime;
            block4: {
                block3: {
                    if (start2 == null) break block2;
                    startTime = this.formatAsTime(start2);
                    object = end;
                    if (object == null) break block3;
                    Date it = object;
                    boolean bl = false;
                    String string = this.formatAsTime(it);
                    object = string;
                    if (string != null) break block4;
                }
                object = "...";
            }
            Object endTime = object;
            $this$appendTime.append("  [" + startTime + " - " + (String)endTime + "]  ", SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    @NlsSafe
    private final String formatAsTime(Date date) {
        String string = new SimpleDateFormat("HH:mm:ss").format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final void appendResultLink(@NotNull ColoredTreeCellRenderer $this$appendResultLink, boolean isUnderMouse) {
        Intrinsics.checkNotNullParameter((Object)$this$appendResultLink, (String)"<this>");
        ClickableNodeLink clickableNodeLink = this.getResultLink();
        if (clickableNodeLink == null) {
            return;
        }
        ClickableNodeLink link = clickableNodeLink;
        SimpleTextAttributes textAttributes = isUnderMouse ? ACTIVE_LINK_ATTRS : INACTIVE_LINK_ATTRS;
        $this$appendResultLink.append(link.getText(), textAttributes);
    }

    @Nullable
    protected ClickableNodeLink getResultLink() {
        return null;
    }

    private static final Unit _init_$lambda$0(OperationTreeNode this$0, EnumSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.model.nodePresentationChanged(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(OperationTreeNode this$0, Date it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.model.nodePresentationChanged(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(OperationTreeNode this$0, Date it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.model.nodePresentationChanged(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(OperationTreeNode this$0, Lifetime outputLifetime, int n, RdOperationOutput output) {
        Intrinsics.checkNotNullParameter((Object)outputLifetime, (String)"outputLifetime");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this$0.model.addMessage(output, this$0);
        return Unit.INSTANCE;
    }

    static {
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.LINK_ATTRIBUTES.derive(SimpleTextAttributes.LINK_ATTRIBUTES.getStyle() | 0x200 | 0x800, null, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"derive(...)");
        INACTIVE_LINK_ATTRS = simpleTextAttributes;
        SimpleTextAttributes simpleTextAttributes2 = INACTIVE_LINK_ATTRS.derive(INACTIVE_LINK_ATTRS.getStyle() | 0x400 | 0x800, UIUtil.getLabelForeground(), null, null);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"derive(...)");
        ACTIVE_LINK_ATTRS = simpleTextAttributes2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/sqlproj/services/tree/nodes/OperationTreeNode$Companion;", "", "<init>", "()V", "INACTIVE_LINK_ATTRS", "Lcom/intellij/ui/SimpleTextAttributes;", "getINACTIVE_LINK_ATTRS", "()Lcom/intellij/ui/SimpleTextAttributes;", "ACTIVE_LINK_ATTRS", "getACTIVE_LINK_ATTRS", "sqlproj-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleTextAttributes getINACTIVE_LINK_ATTRS() {
            return INACTIVE_LINK_ATTRS;
        }

        @NotNull
        public final SimpleTextAttributes getACTIVE_LINK_ATTRS() {
            return ACTIVE_LINK_ATTRS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

