/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.services.tree;

import com.jetbrains.rider.sqlproj.services.tree.NodeChildren;
import com.jetbrains.rider.sqlproj.services.tree.SqlProjOperationsTree;
import com.jetbrains.rider.sqlproj.services.tree.nodes.SqlProjOperationsTreeNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\u0014\u001a\u00020\u0015J\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/sqlproj/services/tree/NodesStorage;", "", "tree", "Lcom/jetbrains/rider/sqlproj/services/tree/SqlProjOperationsTree;", "<init>", "(Lcom/jetbrains/rider/sqlproj/services/tree/SqlProjOperationsTree;)V", "idToNode", "", "Ljava/util/UUID;", "Lcom/jetbrains/rider/sqlproj/services/tree/nodes/SqlProjOperationsTreeNode;", "parentToChildren", "Lcom/jetbrains/rider/sqlproj/services/tree/NodeChildren;", "nodeToParent", "getParent", "node", "getNodeById", "id", "getChildren", "", "parent", "isEmpty", "", "addFirst", "", "(Lcom/jetbrains/rider/sqlproj/services/tree/nodes/SqlProjOperationsTreeNode;Lcom/jetbrains/rider/sqlproj/services/tree/nodes/SqlProjOperationsTreeNode;)Ljava/lang/Integer;", "addLast", "clear", "", "onVisibilityChange", "add", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nNodesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodesStorage.kt\ncom/jetbrains/rider/sqlproj/services/tree/NodesStorage\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n382#2,7:49\n382#2,7:56\n1869#3,2:63\n*S KotlinDebug\n*F\n+ 1 NodesStorage.kt\ncom/jetbrains/rider/sqlproj/services/tree/NodesStorage\n*L\n21#1:49,7\n28#1:56,7\n41#1:63,2\n*E\n"})
public final class NodesStorage {
    @NotNull
    private final SqlProjOperationsTree tree;
    @NotNull
    private final Map<UUID, SqlProjOperationsTreeNode> idToNode;
    @NotNull
    private final Map<SqlProjOperationsTreeNode, NodeChildren> parentToChildren;
    @NotNull
    private final Map<SqlProjOperationsTreeNode, SqlProjOperationsTreeNode> nodeToParent;

    public NodesStorage(@NotNull SqlProjOperationsTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.tree = tree;
        this.idToNode = new LinkedHashMap();
        this.parentToChildren = new LinkedHashMap();
        this.nodeToParent = new LinkedHashMap();
    }

    @Nullable
    public final SqlProjOperationsTreeNode getParent(@NotNull SqlProjOperationsTreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.nodeToParent.get(node);
    }

    @Nullable
    public final SqlProjOperationsTreeNode getNodeById(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.idToNode.get(id);
    }

    @NotNull
    public final List<SqlProjOperationsTreeNode> getChildren(@Nullable Object parent) {
        Object object = this.parentToChildren.get(parent);
        if (object == null || (object = ((NodeChildren)object).getFilteredChildren()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final boolean isEmpty() {
        return this.idToNode.isEmpty();
    }

    @Nullable
    public final Integer addFirst(@NotNull SqlProjOperationsTreeNode node, @NotNull SqlProjOperationsTreeNode parent) {
        NodeChildren nodeChildren;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Map<SqlProjOperationsTreeNode, NodeChildren> $this$getOrPut$iv = this.parentToChildren;
        boolean $i$f$getOrPut = false;
        NodeChildren value$iv = $this$getOrPut$iv.get(parent);
        if (value$iv == null) {
            boolean bl = false;
            NodeChildren answer$iv = new NodeChildren(this.tree);
            $this$getOrPut$iv.put(parent, answer$iv);
            nodeChildren = answer$iv;
        } else {
            nodeChildren = value$iv;
        }
        Integer filteredIndex = (Integer)nodeChildren.addFirst(node).component2();
        this.add(node, parent);
        return filteredIndex;
    }

    @Nullable
    public final Integer addLast(@NotNull SqlProjOperationsTreeNode node, @NotNull SqlProjOperationsTreeNode parent) {
        NodeChildren nodeChildren;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Map<SqlProjOperationsTreeNode, NodeChildren> $this$getOrPut$iv = this.parentToChildren;
        boolean $i$f$getOrPut = false;
        NodeChildren value$iv = $this$getOrPut$iv.get(parent);
        if (value$iv == null) {
            boolean bl = false;
            NodeChildren answer$iv = new NodeChildren(this.tree);
            $this$getOrPut$iv.put(parent, answer$iv);
            nodeChildren = answer$iv;
        } else {
            nodeChildren = value$iv;
        }
        Integer filteredIndex = (Integer)nodeChildren.addLast(node).component2();
        this.add(node, parent);
        return filteredIndex;
    }

    public final void clear() {
        this.idToNode.clear();
        this.parentToChildren.clear();
        this.nodeToParent.clear();
    }

    public final void onVisibilityChange() {
        Iterable $this$forEach$iv = this.parentToChildren.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeChildren it = (NodeChildren)element$iv;
            boolean bl = false;
            it.onVisibilityChange();
        }
    }

    private final void add(SqlProjOperationsTreeNode node, SqlProjOperationsTreeNode parent) {
        this.nodeToParent.put(node, parent);
        this.idToNode.put(node.getId(), node);
    }
}

