/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.services;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rider.sqlproj.operations.SqlProjOperation;
import com.jetbrains.rider.sqlproj.services.OperationContributor;
import com.jetbrains.rider.sqlproj.services.OperationsServiceViewContributor;
import com.jetbrains.rider.sqlproj.services.ServiceViewOperationsPerProject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/sqlproj/services/ServicesOperationsNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "operations", "Lcom/jetbrains/rider/sqlproj/services/ServiceViewOperationsPerProject;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/sqlproj/services/ServiceViewOperationsPerProject;)V", "structureChanged", "", "operationAdded", "operation", "Lcom/jetbrains/rider/sqlproj/operations/SqlProjOperation;", "parent", "operationRemoved", "operationChanged", "publish", "event", "Lcom/intellij/execution/services/ServiceEventListener$ServiceEvent;", "sqlproj-plugin"})
public final class ServicesOperationsNotifier {
    @NotNull
    private final Project project;
    @NotNull
    private final ServiceViewOperationsPerProject operations;

    public ServicesOperationsNotifier(@NotNull Project project, @NotNull ServiceViewOperationsPerProject operations) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        this.project = project;
        this.operations = operations;
    }

    public final void structureChanged() {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.RESET, (Object)ObjectUtils.NULL, OperationsServiceViewContributor.class);
        Intrinsics.checkNotNull((Object)event);
        this.publish(event);
    }

    public final void operationAdded(@NotNull SqlProjOperation operation, @Nullable SqlProjOperation parent) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        ServiceEventListener.ServiceEvent event = parent == null ? ServiceEventListener.ServiceEvent.createServiceAddedEvent((Object)new OperationContributor(this.operations, operation), OperationsServiceViewContributor.class, null) : ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHILDREN_CHANGED, (Object)new OperationContributor(this.operations, parent), OperationsServiceViewContributor.class);
        Intrinsics.checkNotNull((Object)event);
        this.publish(event);
    }

    public final void operationRemoved(@NotNull SqlProjOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, (Object)operation, OperationsServiceViewContributor.class);
        Intrinsics.checkNotNull((Object)event);
        this.publish(event);
    }

    public final void operationChanged(@NotNull SqlProjOperation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)operation, OperationsServiceViewContributor.class);
        Intrinsics.checkNotNull((Object)event);
        this.publish(event);
    }

    private final void publish(ServiceEventListener.ServiceEvent event) {
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(event);
    }
}

