/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.schemaCompare.ui.participants;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.sqlproj.SqlprojBundle;
import com.jetbrains.rider.sqlproj.schemaCompare.participants.SchemaCompareParticipant;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.participants.tabs.ParticipantSelectionTab;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.participants.tabs.dacpac.DacpacParticipantSelectionTab;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.participants.tabs.database.DatabaseParticipantSelectionTab;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.participants.tabs.project.ProjectParticipantSelectionTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0014J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/sqlproj/schemaCompare/ui/participants/ParticipantSelectionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/ui/tabs/TabsListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "tabs", "", "Lcom/jetbrains/rider/sqlproj/schemaCompare/ui/participants/tabs/ParticipantSelectionTab;", "currentTab", "createCenterPanel", "Ljavax/swing/JComponent;", "getInitialSize", "Ljava/awt/Dimension;", "selectionChanged", "", "oldSelection", "Lcom/intellij/ui/tabs/TabInfo;", "newSelection", "dispose", "getSelectedParticipant", "Lcom/jetbrains/rider/sqlproj/schemaCompare/participants/SchemaCompareParticipant;", "sqlproj-plugin"})
public final class ParticipantSelectionDialog
extends DialogWrapper
implements TabsListener {
    @NotNull
    private final Project project;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final List<ParticipantSelectionTab> tabs;
    @NotNull
    private ParticipantSelectionTab currentTab;

    public ParticipantSelectionDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.lifetimeDefinition = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
        this.lifetime = this.lifetimeDefinition.getLifetime();
        Object[] objectArray = new ParticipantSelectionTab[]{new ProjectParticipantSelectionTab(this.project), new DatabaseParticipantSelectionTab(this.lifetime, this.project), new DacpacParticipantSelectionTab(this.project)};
        this.tabs = CollectionsKt.listOf((Object[])objectArray);
        this.currentTab = this.tabs.get(0);
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
        Window window = this.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        Component component = window;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        permittedModalitiesImpl.allowPumpProtocolForComponent(component, disposable);
        this.setTitle(SqlprojBundle.message("schemaCompare.participantSelection.dialog.title", new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBTabsImpl tabsHolder = new JBTabsImpl(this.project);
        tabsHolder.getComponent().setOpaque(true);
        for (ParticipantSelectionTab tab : this.tabs) {
            TabInfo tabInfo = new TabInfo(tab.getComponent());
            tabInfo.setText(tab.getName());
            tabInfo.setPreferredFocusableComponent(tab.getPreferableFocusComponent());
            tabInfo.setObject((Object)tab);
            tabsHolder.addTab(tabInfo);
        }
        tabsHolder.addListener((TabsListener)this);
        return tabsHolder.getComponent();
    }

    @NotNull
    public Dimension getInitialSize() {
        JBDimension jBDimension = JBUI.size((int)500, (int)500);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return (Dimension)jBDimension;
    }

    public void selectionChanged(@Nullable TabInfo oldSelection, @Nullable TabInfo newSelection) {
        if (newSelection != null) {
            Object object = newSelection.getObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.sqlproj.schemaCompare.ui.participants.tabs.ParticipantSelectionTab");
            this.currentTab = (ParticipantSelectionTab)object;
        }
    }

    protected void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        super.dispose();
    }

    @Nullable
    public final SchemaCompareParticipant getSelectedParticipant() {
        return this.currentTab.getSelectedParticipant();
    }
}

