/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.schemaCompare.ui.options;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.sqlproj.SqlprojBundle;
import com.jetbrains.rider.sqlproj.generated.RdSchemaCompareOption;
import com.jetbrains.rider.sqlproj.generated.RdSchemaCompareOptions;
import com.jetbrains.rider.sqlproj.schemaCompare.dataModel.SchemaCompareDataModel;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.options.nodes.GeneralOptionNode;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.options.nodes.GroupingOptionsNode;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.options.nodes.ObjectTypeOptionNode;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.options.trees.SchemaCompareOptionsTree;
import com.jetbrains.rider.sqlproj.schemaCompare.ui.options.trees.renderers.SchemaCompareOptionsTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u00020\u0014H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/sqlproj/schemaCompare/ui/options/CompareOptionsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/jetbrains/rider/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;)V", "map", "", "Lcom/intellij/ui/CheckedTreeNode;", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "pendingUpdates", "", "options", "Lcom/jetbrains/rider/sqlproj/generated/RdSchemaCompareOptions;", "createCenterPanel", "Ljavax/swing/JComponent;", "addGeneralTab", "", "tabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "addObjectTypesTab", "createGeneralOptions", "createObjectTypeOptions", "createGeneralNode", "Lcom/jetbrains/rider/sqlproj/schemaCompare/ui/options/nodes/GeneralOptionNode;", "option", "Lcom/jetbrains/rider/sqlproj/generated/RdSchemaCompareOption;", "createObjectTypeNode", "Lcom/jetbrains/rider/sqlproj/schemaCompare/ui/options/nodes/ObjectTypeOptionNode;", "markForUpdate", "node", "doOKAction", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nCompareOptionsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareOptionsDialog.kt\ncom/jetbrains/rider/sqlproj/schemaCompare/ui/options/CompareOptionsDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1563#2:129\n1634#2,3:130\n1056#2:133\n1563#2:134\n1634#2,3:135\n1056#2:138\n1563#2:139\n1634#2,3:140\n*S KotlinDebug\n*F\n+ 1 CompareOptionsDialog.kt\ncom/jetbrains/rider/sqlproj/schemaCompare/ui/options/CompareOptionsDialog\n*L\n68#1:129\n68#1:130,3\n68#1:133\n79#1:134\n79#1:135,3\n79#1:138\n120#1:139\n120#1:140,3\n*E\n"})
public final class CompareOptionsDialog
extends DialogWrapper {
    @NotNull
    private final SchemaCompareDataModel session;
    @NotNull
    private final Map<CheckedTreeNode, IOptProperty<Boolean>> map;
    @NotNull
    private final Set<CheckedTreeNode> pendingUpdates;
    @NotNull
    private final RdSchemaCompareOptions options;

    public CompareOptionsDialog(@NotNull Project project, @NotNull SchemaCompareDataModel session) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(project);
        this.session = session;
        this.map = new LinkedHashMap();
        this.pendingUpdates = new LinkedHashSet();
        this.options = this.session.getOptions();
        this.setResizable(true);
        this.setTitle(SqlprojBundle.message("schemaCompare.dialog.options.title", new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBTabbedPane tabbedPane = new JBTabbedPane(1);
        tabbedPane.setTabComponentInsets(null);
        this.addGeneralTab(tabbedPane);
        this.addObjectTypesTab(tabbedPane);
        JBPanelWithEmptyText panel = new JBPanelWithEmptyText((LayoutManager)new BorderLayout());
        panel.add((Component)tabbedPane, (Object)"Center");
        panel.setPreferredSize(new Dimension(JBUIScale.scale((int)400), JBUIScale.scale((int)500)));
        return (JComponent)panel;
    }

    private final void addGeneralTab(JBTabbedPane tabbedPane) {
        SchemaCompareOptionsTree generalOptionsTree2 = new SchemaCompareOptionsTree((Function1<? super CheckedTreeNode, Unit>)((Function1)new Function1<CheckedTreeNode, Unit>((Object)this){

            public final void invoke(CheckedTreeNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CompareOptionsDialog.access$markForUpdate((CompareOptionsDialog)((Object)this.receiver), p0);
            }
        }), SchemaCompareOptionsTreeCellRenderer.INSTANCE, this.createGeneralOptions());
        generalOptionsTree2.setRootVisible(true);
        tabbedPane.add(SqlprojBundle.message("schemaCompare.dialog.options.tabs.general.name", new Object[0]), (Component)new JBScrollPane((Component)((Object)generalOptionsTree2)));
    }

    private final void addObjectTypesTab(JBTabbedPane tabbedPane) {
        SchemaCompareOptionsTree objectTypeOptionsTree2 = new SchemaCompareOptionsTree((Function1<? super CheckedTreeNode, Unit>)((Function1)new Function1<CheckedTreeNode, Unit>((Object)this){

            public final void invoke(CheckedTreeNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CompareOptionsDialog.access$markForUpdate((CompareOptionsDialog)((Object)this.receiver), p0);
            }
        }), SchemaCompareOptionsTreeCellRenderer.INSTANCE, this.createObjectTypeOptions());
        tabbedPane.add(SqlprojBundle.message("schemaCompare.dialog.options.tabs.objectTypes.name", new Object[0]), (Component)new JBScrollPane((Component)((Object)objectTypeOptionsTree2)));
    }

    /*
     * WARNING - void declaration
     */
    private final CheckedTreeNode createGeneralOptions() {
        void $this$mapTo$iv$iv;
        GroupingOptionsNode root = new GroupingOptionsNode(SqlprojBundle.message("schemaCompare.dialog.options.groups.general", new Object[0]));
        Iterable $this$map$iv = (Iterable)this.options.getGeneralOptions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdSchemaCompareOption rdSchemaCompareOption = (RdSchemaCompareOption)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createGeneralNode((RdSchemaCompareOption)it));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List children = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GeneralOptionNode it = (GeneralOptionNode)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (GeneralOptionNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        for (GeneralOptionNode child : children) {
            root.add((MutableTreeNode)((Object)child));
        }
        return root;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckedTreeNode createObjectTypeOptions() {
        void $this$mapTo$iv$iv;
        GroupingOptionsNode root = new GroupingOptionsNode(SqlprojBundle.message("schemaCompare.dialog.options.tabs.objectTypes.name", new Object[0]));
        Iterable $this$map$iv = (Iterable)this.options.getObjectTypesOptions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdSchemaCompareOption rdSchemaCompareOption = (RdSchemaCompareOption)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createObjectTypeNode((RdSchemaCompareOption)it));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List children = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ObjectTypeOptionNode it = (ObjectTypeOptionNode)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ObjectTypeOptionNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        for (ObjectTypeOptionNode child : children) {
            root.add((MutableTreeNode)((Object)child));
        }
        return root;
    }

    private final GeneralOptionNode createGeneralNode(RdSchemaCompareOption option) {
        GeneralOptionNode node = new GeneralOptionNode(option);
        node.setChecked((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)option.getValue())));
        this.map.put(node, option.getValue());
        return node;
    }

    private final ObjectTypeOptionNode createObjectTypeNode(RdSchemaCompareOption option) {
        ObjectTypeOptionNode node = new ObjectTypeOptionNode(option);
        node.setChecked((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)option.getValue())));
        this.map.put(node, option.getValue());
        return node;
    }

    private final void markForUpdate(CheckedTreeNode node) {
        if (node.getChildCount() > 0) {
            return;
        }
        boolean bl = this.pendingUpdates.contains(node) ? this.pendingUpdates.remove(node) : this.pendingUpdates.add(node);
    }

    /*
     * WARNING - void declaration
     */
    protected void doOKAction() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.pendingUpdates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CheckedTreeNode checkedTreeNode = (CheckedTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IOptProperty<Boolean> iOptProperty = this.map.get(it);
            Intrinsics.checkNotNull(iOptProperty);
            collection.add(TuplesKt.to(iOptProperty, (Object)it.isChecked()));
        }
        List pairs = (List)destination$iv$iv;
        this.session.changeOptions(pairs);
        super.doOKAction();
    }

    public static final /* synthetic */ void access$markForUpdate(CompareOptionsDialog $this, CheckedTreeNode node) {
        $this.markForUpdate(node);
    }
}

