/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.schemaCompare.participants;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.driver.ExtensionsKt;
import com.jetbrains.rider.sqlproj.generated.RdActiveDirectoryIntegratedAuthentication;
import com.jetbrains.rider.sqlproj.generated.RdActiveDirectoryInteractiveAuthentication;
import com.jetbrains.rider.sqlproj.generated.RdActiveDirectoryPasswordAuthentication;
import com.jetbrains.rider.sqlproj.generated.RdAuthentication;
import com.jetbrains.rider.sqlproj.generated.RdIntegratedSecurityAuthentication;
import com.jetbrains.rider.sqlproj.generated.RdNoAuthentication;
import com.jetbrains.rider.sqlproj.generated.RdParsedConnectionString;
import com.jetbrains.rider.sqlproj.generated.RdSqlPasswordAuthentication;
import com.jetbrains.rider.sqlproj.schemaCompare.participants.DataSourceEqualityComparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/sqlproj/schemaCompare/participants/SqlProjectsDataSources;", "", "<init>", "()V", "getOrCreateDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "parsedConnectionString", "Lcom/jetbrains/rider/sqlproj/generated/RdParsedConnectionString;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "findExistingDataSource", "newDataSource", "createLocalDataSource", "setAuthProviderAndCredentials", "", "dataSource", "authentication", "Lcom/jetbrains/rider/sqlproj/generated/RdAuthentication;", "getDriver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nSqlProjectsDataSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlProjectsDataSources.kt\ncom/jetbrains/rider/sqlproj/schemaCompare/participants/SqlProjectsDataSources\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n295#2,2:90\n*S KotlinDebug\n*F\n+ 1 SqlProjectsDataSources.kt\ncom/jetbrains/rider/sqlproj/schemaCompare/participants/SqlProjectsDataSources\n*L\n32#1:90,2\n*E\n"})
public final class SqlProjectsDataSources {
    @NotNull
    public static final SqlProjectsDataSources INSTANCE = new SqlProjectsDataSources();

    private SqlProjectsDataSources() {
    }

    @NotNull
    public final LocalDataSource getOrCreateDataSource(@NotNull RdParsedConnectionString parsedConnectionString, @NotNull Project project, @Nullable String name) {
        LocalDataSource existing;
        Intrinsics.checkNotNullParameter((Object)parsedConnectionString, (String)"parsedConnectionString");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LocalDataSource newDataSource = this.createLocalDataSource(parsedConnectionString, name);
        LocalDataSource localDataSource = existing = this.findExistingDataSource(newDataSource, project);
        if (localDataSource != null) {
            return localDataSource;
        }
        LocalDataSourceManager.getInstance((Project)project).addDataSource(newDataSource);
        return newDataSource;
    }

    public static /* synthetic */ LocalDataSource getOrCreateDataSource$default(SqlProjectsDataSources sqlProjectsDataSources, RdParsedConnectionString rdParsedConnectionString, Project project, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return sqlProjectsDataSources.getOrCreateDataSource(rdParsedConnectionString, project, string);
    }

    private final LocalDataSource findExistingDataSource(LocalDataSource newDataSource, Project project) {
        Object v1;
        block1: {
            List list = LocalDataSourceManager.getInstance((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            List dataSources = list;
            Iterable $this$firstOrNull$iv = dataSources;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LocalDataSource it = (LocalDataSource)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!DataSourceEqualityComparator.INSTANCE.areEqual(newDataSource, it)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final LocalDataSource createLocalDataSource(RdParsedConnectionString parsedConnectionString, String name) {
        DatabaseDriver jbDriver = this.getDriver(parsedConnectionString);
        LocalDataSource localDataSource = LocalDataSource.fromDriver((DatabaseDriver)jbDriver, (String)parsedConnectionString.getConnectionString(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"fromDriver(...)");
        LocalDataSource dataSource = localDataSource;
        String string = name;
        if (string == null) {
            string = parsedConnectionString.getServer();
        }
        dataSource.setName(string);
        this.setAuthProviderAndCredentials(dataSource, parsedConnectionString.getAuthentication());
        dataSource.setAutoSynchronize(false);
        dataSource.setConfiguredByUrl(true);
        return dataSource;
    }

    private final void setAuthProviderAndCredentials(LocalDataSource dataSource, RdAuthentication authentication) {
        RdAuthentication rdAuthentication = authentication;
        if (rdAuthentication instanceof RdNoAuthentication) {
            dataSource.setAuthProviderId("no-auth");
        } else if (rdAuthentication instanceof RdIntegratedSecurityAuthentication) {
            dataSource.setAuthProviderId("ms-sso");
        } else if (rdAuthentication instanceof RdSqlPasswordAuthentication) {
            dataSource.setAuthProviderId("user-pass");
            dataSource.setUsername(((RdSqlPasswordAuthentication)authentication).getUser());
            DatabaseCredentials.Companion.getInstance().storePassword((DatabaseConnectionConfig)dataSource, new OneTimeString(((RdSqlPasswordAuthentication)authentication).getPassword()));
        } else if (rdAuthentication instanceof RdActiveDirectoryPasswordAuthentication) {
            dataSource.setAuthProviderId("ms-azure-active-directory-pw");
            dataSource.setUsername(((RdActiveDirectoryPasswordAuthentication)authentication).getUser());
            DatabaseCredentials.Companion.getInstance().storePassword((DatabaseConnectionConfig)dataSource, new OneTimeString(((RdActiveDirectoryPasswordAuthentication)authentication).getPassword()));
        } else if (rdAuthentication instanceof RdActiveDirectoryIntegratedAuthentication) {
            dataSource.setAuthProviderId("ms-azure-active-directory-integrated");
        } else if (rdAuthentication instanceof RdActiveDirectoryInteractiveAuthentication) {
            dataSource.setUsername(((RdActiveDirectoryInteractiveAuthentication)authentication).getUser());
            dataSource.setAuthProviderId("ms-azure-active-directory-interactive");
        }
    }

    private final DatabaseDriver getDriver(RdParsedConnectionString parsedConnectionString) {
        if (StringsKt.contains$default((CharSequence)parsedConnectionString.getServer(), (CharSequence)".database.windows.net", (boolean)false, (int)2, null)) {
            DatabaseDriver databaseDriver = DatabaseDriverManager.getInstance().getDriver("azure.jb");
            Intrinsics.checkNotNullExpressionValue((Object)databaseDriver, (String)"getDriver(...)");
            return databaseDriver;
        }
        DatabaseDriverManager databaseDriverManager = DatabaseDriverManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)databaseDriverManager, (String)"getInstance(...)");
        return ExtensionsKt.getJbDriverForMsSql((DatabaseDriverManager)databaseDriverManager);
    }
}

