/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.schemaCompare.participants;

import com.google.common.base.Objects;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001c\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J<\u0010\u0011\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/sqlproj/schemaCompare/participants/DataSourceEqualityComparator;", "", "<init>", "()V", "areEqual", "", "first", "Lcom/intellij/database/dataSource/LocalDataSource;", "second", "areCredentialsEqual", "areDataSourcesConfigEqual", "sshConfigEqual", "sslConfigEqual", "driversEqual", "a", "Lcom/intellij/database/dataSource/DatabaseDriver;", "b", "equals", "K", "V", "firstMap", "", "secondMap", "sqlproj-plugin"})
public final class DataSourceEqualityComparator {
    @NotNull
    public static final DataSourceEqualityComparator INSTANCE = new DataSourceEqualityComparator();

    private DataSourceEqualityComparator() {
    }

    public final boolean areEqual(@NotNull LocalDataSource first, @NotNull LocalDataSource second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return this.areDataSourcesConfigEqual(first, second) && this.areCredentialsEqual(first, second);
    }

    private final boolean areCredentialsEqual(LocalDataSource first, LocalDataSource second) {
        if (!Intrinsics.areEqual((Object)DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)first), (Object)DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)second))) {
            return false;
        }
        DatabaseCredentials credentials = DatabaseCredentials.Companion.getInstance();
        Object newDataSourceCredentials = DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)first).loadAuthConfig((DatabaseConnectionPoint)first, credentials, false);
        Object existingDataSourceCredentials = DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)second).loadAuthConfig((DatabaseConnectionPoint)second, credentials, false);
        return Objects.equal((Object)newDataSourceCredentials, (Object)existingDataSourceCredentials);
    }

    private final boolean areDataSourcesConfigEqual(LocalDataSource first, LocalDataSource second) {
        if (first.isConfiguredByUrl() != second.isConfiguredByUrl()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)first.getUrl()), (CharSequence)StringUtil.nullize((String)second.getUrl()))) {
            return false;
        }
        if (!this.driversEqual(first.getDatabaseDriver(), second.getDatabaseDriver())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)first.getDriverClass(), (CharSequence)second.getDriverClass())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)first.getAuthProviderId(), (Object)second.getAuthProviderId())) {
            return false;
        }
        Map map2 = LocalDataSource.getAdditionalPropertiesMap((LocalDataSource)first);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAdditionalPropertiesMap(...)");
        Map map3 = LocalDataSource.getAdditionalPropertiesMap((LocalDataSource)second);
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getAdditionalPropertiesMap(...)");
        if (!this.equals(map2, map3)) {
            return false;
        }
        if (!this.sshConfigEqual(first, second)) {
            return false;
        }
        if (!this.sslConfigEqual(first, second)) {
            return false;
        }
        if (first.getPasswordStorage() != second.getPasswordStorage()) {
            return false;
        }
        return Intrinsics.areEqual((Object)first.getUsername(), (Object)second.getUsername());
    }

    private final boolean sshConfigEqual(LocalDataSource first, LocalDataSource second) {
        DataSourceSshTunnelConfiguration firstConfig = first.getSshConfiguration();
        DataSourceSshTunnelConfiguration secondConfig = second.getSshConfiguration();
        if (firstConfig != null && secondConfig != null) {
            return firstConfig.equalConfiguration(secondConfig);
        }
        return firstConfig == null && secondConfig == null;
    }

    private final boolean sslConfigEqual(LocalDataSource first, LocalDataSource second) {
        DataSourceSslConfiguration firstConfig = first.getSslCfg();
        DataSourceSslConfiguration secondConfig = second.getSslCfg();
        if (firstConfig != null && secondConfig != null) {
            return firstConfig.equalConfiguration(secondConfig);
        }
        return firstConfig == null && secondConfig == null;
    }

    private final boolean driversEqual(DatabaseDriver a, DatabaseDriver b) {
        return a == null || b == null ? a == b : Intrinsics.areEqual((Object)a.getId(), (Object)b.getId());
    }

    private final <K, V> boolean equals(Map<K, ? extends V> firstMap, Map<K, ? extends V> secondMap) {
        if (firstMap.size() != secondMap.size()) {
            return false;
        }
        for (K key : firstMap.keySet()) {
            if (!secondMap.containsKey(key)) {
                return false;
            }
            if (Comparing.equal(firstMap.get(key), secondMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

