/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.references;

import com.intellij.openapi.project.Project;
import com.jetbrains.rider.sqlproj.generated.RdLoadedSqlProject;
import com.jetbrains.rider.sqlproj.references.DatabaseReferencesSession;
import com.jetbrains.rider.sqlproj.references.presenters.DatabaseReferencePresenter;
import com.jetbrains.rider.sqlproj.references.presenters.dacpacs.ReferenceToDacpacPresenter;
import com.jetbrains.rider.sqlproj.references.presenters.nuget.ReferenceToNugetPresenter;
import com.jetbrains.rider.sqlproj.references.presenters.projects.ReferenceToDatabaseProjectPresenter;
import com.jetbrains.rider.sqlproj.references.presenters.systemDatabase.ReferenceToSystemDatabasePresenter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/sqlproj/references/PresentersFactory;", "", "<init>", "()V", "createPresenters", "", "Lcom/jetbrains/rider/sqlproj/references/presenters/DatabaseReferencePresenter;", "project", "Lcom/intellij/openapi/project/Project;", "sqlProject", "Lcom/jetbrains/rider/sqlproj/generated/RdLoadedSqlProject;", "session", "Lcom/jetbrains/rider/sqlproj/references/DatabaseReferencesSession;", "sqlproj-plugin"})
public final class PresentersFactory {
    @NotNull
    public static final PresentersFactory INSTANCE = new PresentersFactory();

    private PresentersFactory() {
    }

    @NotNull
    public final List<DatabaseReferencePresenter> createPresenters(@NotNull Project project, @NotNull RdLoadedSqlProject sqlProject, @NotNull DatabaseReferencesSession session) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)sqlProject), (String)"sqlProject");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        List presenters = new ArrayList();
        presenters.add(new ReferenceToDatabaseProjectPresenter(session));
        presenters.add(new ReferenceToSystemDatabasePresenter(sqlProject, session));
        presenters.add(new ReferenceToDacpacPresenter(project, session));
        if (sqlProject.isSdkBased()) {
            presenters.add(new ReferenceToNugetPresenter(session));
        }
        return presenters;
    }
}

