/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.references;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.RdAddDacpacReference;
import com.jetbrains.rd.ide.model.RdAddDatabaseProjectReference;
import com.jetbrains.rd.ide.model.RdAddDatabaseReference;
import com.jetbrains.rd.ide.model.RdAddDatabaseReferenceSession;
import com.jetbrains.rd.ide.model.RdAddNugetPackageReference;
import com.jetbrains.rd.ide.model.RdAddSystemDatabaseReference;
import com.jetbrains.rd.ide.model.RdDatabaseReferenceLocation;
import com.jetbrains.rd.ide.model.RdDatabaseReferenceSource;
import com.jetbrains.rd.ide.model.RdPotentialDatabaseReference;
import com.jetbrains.rd.ide.model.RdSystemDatabase;
import com.jetbrains.rd.ide.model.RdSystemDatabaseReferenceType;
import com.jetbrains.rider.sqlproj.references.presenters.systemDatabase.ReferenceType;
import com.jetbrains.rider.sqlproj.references.presenters.systemDatabase.SystemDatabase;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010#\u001a\u00020$*\u00020\u0016H\u0002J\f\u0010#\u001a\u00020%*\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/sqlproj/references/DatabaseReferencesSession;", "", "rdSession", "Lcom/jetbrains/rd/ide/model/RdAddDatabaseReferenceSession;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdAddDatabaseReferenceSession;Lcom/intellij/openapi/project/Project;)V", "getPossibleReferences", "", "Lcom/jetbrains/rd/ide/model/RdPotentialDatabaseReference;", "source", "Lcom/jetbrains/rd/ide/model/RdDatabaseReferenceSource;", "(Lcom/jetbrains/rd/ide/model/RdDatabaseReferenceSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addReferenceToProject", "", "potentialReferenceId", "", "location", "Lcom/jetbrains/rd/ide/model/RdDatabaseReferenceLocation;", "addReferenceToSystemDatabase", "database", "Lcom/jetbrains/rider/sqlproj/references/presenters/systemDatabase/SystemDatabase;", "referenceType", "Lcom/jetbrains/rider/sqlproj/references/presenters/systemDatabase/ReferenceType;", "addReferenceToDacpac", "path", "", "addNugetReference", "packageId", "packageVersion", "addUnderProgress", "command", "Lcom/jetbrains/rd/ide/model/RdAddDatabaseReference;", "addSync", "toRd", "Lcom/jetbrains/rd/ide/model/RdSystemDatabase;", "Lcom/jetbrains/rd/ide/model/RdSystemDatabaseReferenceType;", "sqlproj-plugin"})
public final class DatabaseReferencesSession {
    @NotNull
    private final RdAddDatabaseReferenceSession rdSession;
    @NotNull
    private final Project project;

    public DatabaseReferencesSession(@NotNull RdAddDatabaseReferenceSession rdSession, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)rdSession), (String)"rdSession");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.rdSession = rdSession;
        this.project = project;
    }

    @Nullable
    public final Object getPossibleReferences(@NotNull RdDatabaseReferenceSource source, @NotNull Continuation<? super List<RdPotentialDatabaseReference>> $completion) {
        return IRdCall.DefaultImpls.startSuspending$default(this.rdSession.getGetReferences(), (Object)((Object)source), null, $completion, (int)2, null);
    }

    public final void addReferenceToProject(int potentialReferenceId, @NotNull RdDatabaseReferenceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        RdAddDatabaseProjectReference command = new RdAddDatabaseProjectReference(potentialReferenceId, location);
        if (PluginManagerCore.isUnitTestMode) {
            this.addSync(command);
        } else {
            this.addUnderProgress(command);
        }
    }

    public final void addReferenceToSystemDatabase(@NotNull SystemDatabase database, @NotNull ReferenceType referenceType, @NotNull RdDatabaseReferenceLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        RdSystemDatabase rdSystemDatabase = this.toRd(database);
        RdSystemDatabaseReferenceType rdSystemDatabaseReferenceType = this.toRd(referenceType);
        RdAddSystemDatabaseReference command = new RdAddSystemDatabaseReference(rdSystemDatabase, rdSystemDatabaseReferenceType, null, location);
        if (PluginManagerCore.isUnitTestMode) {
            this.addSync(command);
        } else {
            this.addUnderProgress(command);
        }
    }

    public final void addReferenceToDacpac(@NotNull String path, @NotNull RdDatabaseReferenceLocation location) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        RdAddDacpacReference command = new RdAddDacpacReference(path, null, location);
        if (PluginManagerCore.isUnitTestMode) {
            this.addSync(command);
        } else {
            this.addUnderProgress(command);
        }
    }

    public final void addNugetReference(@NotNull String packageId, @NotNull String packageVersion, @NotNull RdDatabaseReferenceLocation location) {
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        Intrinsics.checkNotNullParameter((Object)packageVersion, (String)"packageVersion");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        RdAddNugetPackageReference command = new RdAddNugetPackageReference(packageId, packageVersion, null, location);
        if (PluginManagerCore.isUnitTestMode) {
            this.addSync(command);
        } else {
            this.addUnderProgress(command);
        }
    }

    private final void addUnderProgress(RdAddDatabaseReference command) {
        ExtensionsKt.runCommandUnderProgress$default(this.rdSession.getAdd(), (Object)command, (Project)this.project, (String)"Adding database reference...", (boolean)false, (boolean)false, (boolean)false, (int)56, null);
    }

    private final void addSync(RdAddDatabaseReference command) {
        ExtensionsKt.syncFromBackend$default(this.rdSession.getAdd(), (Object)command, (Project)this.project, null, null, (int)12, null);
    }

    private final RdSystemDatabase toRd(SystemDatabase $this$toRd) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toRd.ordinal()]) {
            case 1 -> RdSystemDatabase.Master;
            case 2 -> RdSystemDatabase.Msdb;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final RdSystemDatabaseReferenceType toRd(ReferenceType $this$toRd) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toRd.ordinal()]) {
            case 1 -> RdSystemDatabaseReferenceType.Package;
            case 2 -> RdSystemDatabaseReferenceType.Artifact;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SystemDatabase.values().length];
            try {
                nArray[SystemDatabase.Master.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SystemDatabase.Msdb.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReferenceType.values().length];
            try {
                nArray[ReferenceType.Package.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceType.Artifact.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

