/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.problemsView.problems;

import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.problemsView.RiderProblemsProvider;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.sqlproj.generated.RdSchemaCompareSessionProblem;
import com.jetbrains.rider.sqlproj.generated.RdSqlProjWorkerProblem;
import com.jetbrains.rider.sqlproj.generated.RdSqlProjectProblem;
import com.jetbrains.rider.sqlproj.problemsView.problems.SchemaComparisonFileProblem;
import com.jetbrains.rider.sqlproj.problemsView.problems.SchemaComparisonProblem;
import com.jetbrains.rider.sqlproj.problemsView.problems.SqlProjectFileProblem;
import com.jetbrains.rider.sqlproj.problemsView.problems.SqlProjectProblem;
import com.jetbrains.rider.sqlproj.problemsView.problems.SqlProjectsProblem;
import com.jetbrains.rider.sqlproj.schemaCompare.SchemaCompareHost;
import com.jetbrains.rider.sqlproj.schemaCompare.session.SchemaCompareSession;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0017\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/sqlproj/problemsView/problems/SqlProjectsProblemsFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createProblem", "Lcom/jetbrains/rider/sqlproj/problemsView/problems/SqlProjectsProblem;", "rdProblem", "Lcom/jetbrains/rider/sqlproj/generated/RdSqlProjWorkerProblem;", "createSqlProjectProblem", "Lcom/jetbrains/rider/sqlproj/generated/RdSqlProjectProblem;", "createSchemaComparisonProblem", "Lcom/jetbrains/rider/sqlproj/generated/RdSchemaCompareSessionProblem;", "findProjectForProblem", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "adjustPosition", "", "lineOrColumn", "(Ljava/lang/Integer;)I", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nSqlProjectsProblemsFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlProjectsProblemsFactory.kt\ncom/jetbrains/rider/sqlproj/problemsView/problems/SqlProjectsProblemsFactory\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n17#2,2:88\n1563#3:90\n1634#3,3:91\n808#3,11:94\n295#3,2:105\n*S KotlinDebug\n*F\n+ 1 SqlProjectsProblemsFactory.kt\ncom/jetbrains/rider/sqlproj/problemsView/problems/SqlProjectsProblemsFactory\n*L\n53#1:88,2\n79#1:90\n79#1:91,3\n80#1:94,11\n81#1:105,2\n*E\n"})
public final class SqlProjectsProblemsFactory {
    @NotNull
    private final Project project;

    public SqlProjectsProblemsFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final SqlProjectsProblem createProblem(@NotNull RdSqlProjWorkerProblem rdProblem) {
        SqlProjectsProblem sqlProjectsProblem;
        Intrinsics.checkNotNullParameter((Object)rdProblem, (String)"rdProblem");
        RdSqlProjWorkerProblem rdSqlProjWorkerProblem = rdProblem;
        if (rdSqlProjWorkerProblem instanceof RdSqlProjectProblem) {
            sqlProjectsProblem = this.createSqlProjectProblem((RdSqlProjectProblem)rdProblem);
        } else if (rdSqlProjWorkerProblem instanceof RdSchemaCompareSessionProblem) {
            sqlProjectsProblem = this.createSchemaComparisonProblem((RdSchemaCompareSessionProblem)rdProblem);
        } else {
            throw new Exception();
        }
        return sqlProjectsProblem;
    }

    private final SqlProjectsProblem createSqlProjectProblem(RdSqlProjectProblem rdProblem) {
        VirtualFile virtualFile;
        String document = rdProblem.getDocument();
        RdProjectDescriptor rdProjectDescriptor = this.findProjectForProblem(rdProblem);
        if (rdProjectDescriptor == null) {
            return null;
        }
        RdProjectDescriptor projectDescriptor = rdProjectDescriptor;
        String string = document;
        if (string != null) {
            String it = string;
            boolean bl = false;
            v2 = StringsKt.isBlank((CharSequence)it) ? null : VirtualFileManager.getInstance().findFileByNioPath(Path.of(document, new String[0]));
        } else {
            v2 = virtualFile = null;
        }
        if (virtualFile != null) {
            return new SqlProjectFileProblem(projectDescriptor, (ProblemsProvider)new RiderProblemsProvider(this.project), rdProblem.getText(), rdProblem.getSeverity(), virtualFile, this.adjustPosition(rdProblem.getLine()), this.adjustPosition(rdProblem.getColumn()));
        }
        return new SqlProjectProblem(projectDescriptor, (ProblemsProvider)new RiderProblemsProvider(this.project), rdProblem.getText(), rdProblem.getSeverity());
    }

    private final SqlProjectsProblem createSchemaComparisonProblem(RdSchemaCompareSessionProblem rdProblem) {
        VirtualFile virtualFile;
        String document = rdProblem.getDocument();
        ComponentManager $this$getService$iv = (ComponentManager)this.project;
        boolean $i$f$getService = false;
        Object object = $this$getService$iv.getService(SchemaCompareHost.class);
        if (object == null) {
            throw new IllegalStateException("Service " + SchemaCompareHost.class + " not found in container " + $this$getService$iv);
        }
        SchemaCompareSession schemaCompareSession = ((SchemaCompareHost)object).getSessionById(rdProblem.getSessionId());
        if (schemaCompareSession == null) {
            return null;
        }
        SchemaCompareSession session = schemaCompareSession;
        String string = document;
        if (string != null) {
            String it = string;
            boolean bl = false;
            v3 = StringsKt.isBlank((CharSequence)it) ? null : VirtualFileManager.getInstance().findFileByNioPath(Path.of(document, new String[0]));
        } else {
            v3 = virtualFile = null;
        }
        if (virtualFile != null) {
            return new SchemaComparisonFileProblem(session, (ProblemsProvider)new RiderProblemsProvider(this.project), rdProblem.getText(), rdProblem.getSeverity(), virtualFile, this.adjustPosition(rdProblem.getLine()), this.adjustPosition(rdProblem.getColumn()));
        }
        return new SchemaComparisonProblem(session, (ProblemsProvider)new RiderProblemsProvider(this.project), rdProblem.getText(), rdProblem.getSeverity());
    }

    /*
     * WARNING - void declaration
     */
    private final RdProjectDescriptor findProjectForProblem(RdSqlProjectProblem rdProblem) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
            Iterable $this$map$iv = WorkspaceModelExtensionsKt.findProjects((WorkspaceModel)workspaceModel);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProjectModelEntity projectModelEntity = (ProjectModelEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDescriptor());
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof RdProjectDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RdProjectDescriptor it = (RdProjectDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOriginalGuid(), (Object)rdProblem.getProjectGuid())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    private final int adjustPosition(Integer lineOrColumn) {
        Integer n = lineOrColumn;
        return n == null ? -1 : n - 1;
    }
}

