/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.problemsView.problems;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EDT;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.sqlproj.generated.RdSqlProjWorkerProblemSeverity;
import com.jetbrains.rider.sqlproj.problemsView.filters.ProblemsFilterService;
import com.jetbrains.rider.sqlproj.problemsView.problems.SqlProjectsFileProblem;
import com.jetbrains.rider.sqlproj.problemsView.problems.SqlProjectsProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\fJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001dJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010#\u001a\u00020!J\u0006\u0010$\u001a\u00020\u001fJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u001dJ\u0006\u0010&\u001a\u00020\u001fJ\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\nH\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010/\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/sqlproj/problemsView/problems/ProblemsStorage;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "filterService", "Lcom/jetbrains/rider/sqlproj/problemsView/filters/ProblemsFilterService;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/sqlproj/problemsView/filters/ProblemsFilterService;)V", "problemsPerSeverity", "", "Lcom/jetbrains/rider/sqlproj/generated/RdSqlProjWorkerProblemSeverity;", "", "Lcom/jetbrains/rider/sqlproj/problemsView/problems/SqlProjectsProblem;", "fileProblems", "", "Lcom/jetbrains/rider/sqlproj/problemsView/problems/SqlProjectsFileProblem;", "nonFileProblems", "lock", "_visibleProblemsChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "visibleProblemsChanged", "Lcom/jetbrains/rd/util/reactive/ISource;", "getVisibleProblemsChanged", "()Lcom/jetbrains/rd/util/reactive/ISource;", "addProblem", "problem", "removeProblem", "getProblems", "", "getProblemsCount", "", "getProblemFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProblemsForFile", "file", "getFileProblemsCount", "getNonFileProblems", "getNonFileProblemsCount", "onErrorsVisibilityChanged", "showErrors", "", "onWarningsVisibilityChanged", "showWarnings", "onInfoVisibilityChanged", "showInfo", "hasProblemsWithSeverity", "severity", "getStorageForSeverity", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nProblemsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemsStorage.kt\ncom/jetbrains/rider/sqlproj/problemsView/problems/ProblemsStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n774#2:135\n865#2,2:136\n774#2:138\n865#2,2:139\n774#2:141\n865#2,2:142\n1563#2:144\n1634#2,3:145\n774#2:148\n865#2,2:149\n774#2:151\n865#2,2:152\n774#2:154\n865#2,2:155\n774#2:157\n865#2,2:158\n*S KotlinDebug\n*F\n+ 1 ProblemsStorage.kt\ncom/jetbrains/rider/sqlproj/problemsView/problems/ProblemsStorage\n*L\n55#1:135\n55#1:136,2\n61#1:138\n61#1:139,2\n67#1:141\n67#1:142,2\n67#1:144\n67#1:145,3\n73#1:148\n73#1:149,2\n79#1:151\n79#1:152,2\n85#1:154\n85#1:155,2\n91#1:157\n91#1:158,2\n*E\n"})
public final class ProblemsStorage {
    @NotNull
    private final ProblemsFilterService filterService;
    @NotNull
    private final Map<RdSqlProjWorkerProblemSeverity, List<SqlProjectsProblem>> problemsPerSeverity;
    @NotNull
    private final Set<SqlProjectsFileProblem> fileProblems;
    @NotNull
    private final Set<SqlProjectsProblem> nonFileProblems;
    @NotNull
    private final Object lock;
    @NotNull
    private final Signal<Unit> _visibleProblemsChanged;
    @NotNull
    private final ISource<Unit> visibleProblemsChanged;

    public ProblemsStorage(@NotNull Lifetime lifetime, @NotNull ProblemsFilterService filterService) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)filterService, (String)"filterService");
        this.filterService = filterService;
        this.problemsPerSeverity = new LinkedHashMap();
        this.fileProblems = new LinkedHashSet();
        this.nonFileProblems = new LinkedHashSet();
        this.lock = new Object();
        this._visibleProblemsChanged = new Signal();
        this.visibleProblemsChanged = (ISource)this._visibleProblemsChanged;
        this.filterService.getAreErrorsShown().advise(lifetime, arg_0 -> ProblemsStorage._init_$lambda$0(this, arg_0));
        this.filterService.getAreWarningsShown().advise(lifetime, arg_0 -> ProblemsStorage._init_$lambda$1(this, arg_0));
        this.filterService.isInfoShown().advise(lifetime, arg_0 -> ProblemsStorage._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final ISource<Unit> getVisibleProblemsChanged() {
        return this.visibleProblemsChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addProblem(@NotNull SqlProjectsProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        EDT.assertIsEdt();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.getStorageForSeverity(problem.getSeverity()).add(problem);
            boolean bl2 = problem instanceof SqlProjectsFileProblem ? this.fileProblems.add((SqlProjectsFileProblem)problem) : this.nonFileProblems.add(problem);
        }
        if (this.filterService.isVisible(problem)) {
            this._visibleProblemsChanged.fire((Object)Unit.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProblem(@NotNull SqlProjectsProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        EDT.assertIsEdt();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.getStorageForSeverity(problem.getSeverity()).remove(problem);
            boolean bl2 = problem instanceof SqlProjectsFileProblem ? this.fileProblems.remove(problem) : this.nonFileProblems.remove(problem);
        }
        if (this.filterService.isVisible(problem)) {
            this._visibleProblemsChanged.fire((Object)Unit.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<SqlProjectsProblem> getProblems() {
        Object object = this.lock;
        synchronized (object) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = CollectionsKt.union((Iterable)this.fileProblems, (Iterable)this.nonFileProblems);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SqlProjectsProblem it = (SqlProjectsProblem)element$iv$iv;
                boolean bl2 = false;
                if (!this.filterService.isVisible(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int getProblemsCount() {
        Object object = this.lock;
        synchronized (object) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = CollectionsKt.union((Iterable)this.fileProblems, (Iterable)this.nonFileProblems);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SqlProjectsProblem it = (SqlProjectsProblem)element$iv$iv;
                boolean bl2 = false;
                if (!this.filterService.isVisible(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int n = ((List)destination$iv$iv).size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<VirtualFile> getProblemFiles() {
        Object object = this.lock;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            SqlProjectsFileProblem it;
            Iterable $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.fileProblems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SqlProjectsFileProblem)element$iv$iv;
                boolean bl2 = false;
                if (!this.filterService.isVisible(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SqlProjectsFileProblem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getFile());
            }
            Collection collection = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<SqlProjectsFileProblem> getProblemsForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = this.lock;
        synchronized (object) {
            SqlProjectsFileProblem it;
            Iterable $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.fileProblems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SqlProjectsFileProblem)element$iv$iv;
                boolean bl2 = false;
                if (!this.filterService.isVisible(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SqlProjectsFileProblem)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int getFileProblemsCount() {
        Object object = this.lock;
        synchronized (object) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.fileProblems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SqlProjectsFileProblem it = (SqlProjectsFileProblem)element$iv$iv;
                boolean bl2 = false;
                if (!this.filterService.isVisible(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int n = ((List)destination$iv$iv).size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<SqlProjectsProblem> getNonFileProblems() {
        Object object = this.lock;
        synchronized (object) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.nonFileProblems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SqlProjectsProblem it = (SqlProjectsProblem)element$iv$iv;
                boolean bl2 = false;
                if (!this.filterService.isVisible(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int getNonFileProblemsCount() {
        Object object = this.lock;
        synchronized (object) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.nonFileProblems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SqlProjectsProblem it = (SqlProjectsProblem)element$iv$iv;
                boolean bl2 = false;
                if (!this.filterService.isVisible(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int n = ((List)destination$iv$iv).size();
            return n;
        }
    }

    private final void onErrorsVisibilityChanged(boolean showErrors) {
        EDT.assertIsEdt();
        if (this.hasProblemsWithSeverity(RdSqlProjWorkerProblemSeverity.Error)) {
            this._visibleProblemsChanged.fire((Object)Unit.INSTANCE);
        }
    }

    private final void onWarningsVisibilityChanged(boolean showWarnings) {
        EDT.assertIsEdt();
        if (this.hasProblemsWithSeverity(RdSqlProjWorkerProblemSeverity.Warning)) {
            this._visibleProblemsChanged.fire((Object)Unit.INSTANCE);
        }
    }

    private final void onInfoVisibilityChanged(boolean showInfo) {
        EDT.assertIsEdt();
        if (this.hasProblemsWithSeverity(RdSqlProjWorkerProblemSeverity.Message)) {
            this._visibleProblemsChanged.fire((Object)Unit.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasProblemsWithSeverity(RdSqlProjWorkerProblemSeverity severity) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            List<SqlProjectsProblem> list = this.problemsPerSeverity.get((Object)severity);
            boolean bl2 = list != null ? !((Collection)list).isEmpty() : false;
            return bl2;
        }
    }

    private final List<SqlProjectsProblem> getStorageForSeverity(RdSqlProjWorkerProblemSeverity severity) {
        if (this.problemsPerSeverity.get((Object)severity) == null) {
            this.problemsPerSeverity.put(severity, new ArrayList());
        }
        List<SqlProjectsProblem> list = this.problemsPerSeverity.get((Object)severity);
        Intrinsics.checkNotNull(list);
        return list;
    }

    private static final Unit _init_$lambda$0(ProblemsStorage this$0, boolean it) {
        this$0.onErrorsVisibilityChanged(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ProblemsStorage this$0, boolean it) {
        this$0.onWarningsVisibilityChanged(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ProblemsStorage this$0, boolean it) {
        this$0.onInfoVisibilityChanged(it);
        return Unit.INSTANCE;
    }
}

