/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.operations.environment.parts;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.sqlproj.operations.environment.OperationEnvironmentReader;
import com.jetbrains.rider.sqlproj.operations.environment.OperationEnvironmentWriter;
import com.jetbrains.rider.sqlproj.operations.environment.parts.DataSourceIdPart;
import com.jetbrains.rider.sqlproj.operations.environment.parts.OperationEnvironmentPart;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/sqlproj/operations/environment/parts/LocalDataSourcePart;", "Lcom/jetbrains/rider/sqlproj/operations/environment/parts/OperationEnvironmentPart;", "Lcom/intellij/database/dataSource/LocalDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "set", "", "environment", "Lcom/jetbrains/rider/sqlproj/operations/environment/OperationEnvironmentWriter;", "value", "get", "Lcom/jetbrains/rider/sqlproj/operations/environment/OperationEnvironmentReader;", "sqlproj-plugin"})
public final class LocalDataSourcePart
implements OperationEnvironmentPart<LocalDataSource> {
    @NotNull
    private final Project project;

    public LocalDataSourcePart(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void set(@NotNull OperationEnvironmentWriter environment, @NotNull LocalDataSource value) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        DataSourceIdPart.INSTANCE.set(environment, string);
    }

    @Override
    @Nullable
    public LocalDataSource get(@NotNull OperationEnvironmentReader environment) {
        DbDataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String string = DataSourceIdPart.INSTANCE.get(environment);
        if (string == null) {
            return null;
        }
        String dataSourceId = string;
        DbDataSource dbDataSource = dataSource = DbPsiFacade.getInstance((Project)this.project).findDataSource(dataSourceId);
        RawDataSource rawDataSource = dbDataSource != null ? dbDataSource.getDelegateDataSource() : null;
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }
}

