/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.host;

import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.sqlproj.generated.RdLoadedSqlProject;
import com.jetbrains.rider.sqlproj.generated.RdSqlProject;
import com.jetbrains.rider.sqlproj.generated.RdUnloadedSqlProject;
import com.jetbrains.rider.sqlproj.generated.SqlProjWorkerToFrontendModel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/sqlproj/host/SqlProjectsStorage;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;)V", "loadedProjectPerLocation", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Ljava/nio/file/Path;", "Lcom/jetbrains/rider/sqlproj/generated/RdLoadedSqlProject;", "getLoadedProjectPerLocation", "()Lcom/jetbrains/rd/util/reactive/ViewableMap;", "unloadedProjectPerLocation", "Lcom/jetbrains/rider/sqlproj/generated/RdUnloadedSqlProject;", "getUnloadedProjectPerLocation", "getLoadedProject", "location", "getUnloadedProject", "getProject", "Lcom/jetbrains/rider/sqlproj/generated/RdSqlProject;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isProjectLoaded", "", "sqlproj-plugin"})
public final class SqlProjectsStorage {
    @NotNull
    private final ViewableMap<Path, RdLoadedSqlProject> loadedProjectPerLocation;
    @NotNull
    private final ViewableMap<Path, RdUnloadedSqlProject> unloadedProjectPerLocation;

    public SqlProjectsStorage(@NotNull Lifetime lifetime, @NotNull SqlProjWorkerToFrontendModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.loadedProjectPerLocation = new ViewableMap(null, 1, null);
        this.unloadedProjectPerLocation = new ViewableMap(null, 1, null);
        model.getProjects().view(lifetime, (arg_0, arg_1, arg_2) -> SqlProjectsStorage._init_$lambda$0(this, arg_0, arg_1, arg_2));
    }

    @NotNull
    public final ViewableMap<Path, RdLoadedSqlProject> getLoadedProjectPerLocation() {
        return this.loadedProjectPerLocation;
    }

    @NotNull
    public final ViewableMap<Path, RdUnloadedSqlProject> getUnloadedProjectPerLocation() {
        return this.unloadedProjectPerLocation;
    }

    @Nullable
    public final RdLoadedSqlProject getLoadedProject(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return (RdLoadedSqlProject)((Object)this.loadedProjectPerLocation.get((Object)location));
    }

    @Nullable
    public final RdUnloadedSqlProject getUnloadedProject(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return (RdUnloadedSqlProject)((Object)this.unloadedProjectPerLocation.get((Object)location));
    }

    @Nullable
    public final RdSqlProject getProject(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        RdLoadedSqlProject rdLoadedSqlProject = this.getLoadedProject(location);
        return rdLoadedSqlProject != null ? (RdSqlProject)rdLoadedSqlProject : (RdSqlProject)this.getUnloadedProject(location);
    }

    @Nullable
    public final RdSqlProject getProject(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = entity.getUrl();
        if (object == null || (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) == null || (object = object.toNioPath()) == null) {
            return null;
        }
        Object path = object;
        return this.getProject((Path)path);
    }

    @Nullable
    public final RdLoadedSqlProject getLoadedProject(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = entity.getUrl();
        if (object == null || (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) == null || (object = object.toNioPath()) == null) {
            return null;
        }
        Object path = object;
        return this.getLoadedProject((Path)path);
    }

    public final boolean isProjectLoaded(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.getProject(entity) != null;
    }

    private static final Unit _init_$lambda$0(SqlProjectsStorage this$0, Lifetime projectLifetime, int n, RdSqlProject project) {
        Intrinsics.checkNotNullParameter((Object)projectLifetime, (String)"projectLifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)project), (String)"project");
        Path path = Paths.get(project.getProjectFilePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path;
        RdSqlProject rdSqlProject = project;
        if (rdSqlProject instanceof RdLoadedSqlProject) {
            CollectionExKt.addUnique((Map)((Map)this$0.loadedProjectPerLocation), (Lifetime)projectLifetime, (Object)path2, (Object)((Object)project));
        } else if (rdSqlProject instanceof RdUnloadedSqlProject) {
            CollectionExKt.addUnique((Map)((Map)this$0.unloadedProjectPerLocation), (Lifetime)projectLifetime, (Object)path2, (Object)((Object)project));
        }
        return Unit.INSTANCE;
    }
}

