/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.host;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.rd.framework.IIdentities;
import com.jetbrains.rd.framework.ISerializers;
import com.jetbrains.rd.framework.IWire;
import com.jetbrains.rd.framework.IdKind;
import com.jetbrains.rd.framework.Identities;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.RdContext;
import com.jetbrains.rd.framework.Serializers;
import com.jetbrains.rd.framework.SocketWire;
import com.jetbrains.rd.framework.SocketWireKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.protocol.RdDispatcher;
import com.jetbrains.rider.AssemblyExecutionContext;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotnetSelfProfilingProcesses;
import com.jetbrains.rider.protocol.LocaleHelper;
import com.jetbrains.rider.sqlproj.SqlprojPlugin;
import com.jetbrains.rider.sqlproj.generated.SqlProjWorkerToFrontendModel;
import com.jetbrains.rider.sqlproj.host.SqlProjWorkerModelManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/sqlproj/host/SqlProjWorkerProcess;", "Lcom/intellij/execution/process/KillableProcessHandler;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "model", "Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlinx/coroutines/CoroutineScope;Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "getModel", "()Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "Companion", "TextAndTerminationListener", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nSqlProjWorkerProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlProjWorkerProcess.kt\ncom/jetbrains/rider/sqlproj/host/SqlProjWorkerProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n13#2:133\n*S KotlinDebug\n*F\n+ 1 SqlProjWorkerProcess.kt\ncom/jetbrains/rider/sqlproj/host/SqlProjWorkerProcess\n*L\n108#1:133\n*E\n"})
public final class SqlProjWorkerProcess
extends KillableProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final SqlProjWorkerToFrontendModel model;
    @NotNull
    private static final Logger logger;

    public SqlProjWorkerProcess(@NotNull Lifetime lifetime, @NotNull CoroutineScope scope, @NotNull SqlProjWorkerToFrontendModel model, @NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super(commandLine);
        this.lifetime = lifetime;
        this.scope = scope;
        this.model = model;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final SqlProjWorkerToFrontendModel getModel() {
        return this.model;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
        return options;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SqlProjWorkerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SqlProjWorkerProcess.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/sqlproj/host/SqlProjWorkerProcess$Companion;", "", "<init>", "()V", "start", "Lcom/jetbrains/rider/sqlproj/host/SqlProjWorkerProcess;", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "createWorkerProcess", "processLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "processScope", "createProtocol", "Lcom/jetbrains/rd/framework/Protocol;", "lifetime", "createWorkerCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "protocolPort", "", "addToKnowRiderProcesses", "", "prepareLoggingDirectory", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sqlproj-plugin"})
    @SourceDebugExtension(value={"SMAP\nSqlProjWorkerProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlProjWorkerProcess.kt\ncom/jetbrains/rider/sqlproj/host/SqlProjWorkerProcess$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SqlProjWorkerProcess start(@NotNull Lifetime parentLifetime, @NotNull CoroutineScope parentScope, @NotNull Project project) {
            SqlProjWorkerProcess sqlProjWorkerProcess;
            Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LifetimeDefinition processLifetimeDefinition = parentLifetime.createNested();
            CoroutineScope processScope = CoroutineScopeKt.childScope$default((CoroutineScope)parentScope, (String)"SqlProjWorker", null, (boolean)false, (int)6, null);
            LifetimeCoroutineUtilKt.synchronizeWith$default((LifetimeDefinition)processLifetimeDefinition, (CoroutineScope)processScope, (boolean)false, (int)2, null);
            Ref.ObjectRef process = new Ref.ObjectRef();
            processLifetimeDefinition.onTermination(() -> Companion.start$lambda$0(process));
            SqlProjWorkerProcess it = sqlProjWorkerProcess = this.createWorkerProcess(processLifetimeDefinition, processScope, project);
            boolean bl = false;
            process.element = it;
            return sqlProjWorkerProcess;
        }

        private final SqlProjWorkerProcess createWorkerProcess(LifetimeDefinition processLifetimeDefinition, CoroutineScope processScope, Project project) {
            SqlProjWorkerProcess sqlProjWorkerProcess;
            Protocol protocol = this.createProtocol(processLifetimeDefinition.getLifetime());
            SqlProjWorkerToFrontendModel model = SqlProjWorkerModelManager.Companion.createSqlProjWorkerModel((Lifetime)processLifetimeDefinition, project, protocol);
            GeneralCommandLine commandLine = this.createWorkerCommandLine(SocketWireKt.getServerPort((IWire)protocol.getWire()));
            SqlProjWorkerProcess $this$createWorkerProcess_u24lambda_u242 = sqlProjWorkerProcess = new SqlProjWorkerProcess(processLifetimeDefinition.getLifetime(), processScope, model, commandLine);
            boolean bl = false;
            $this$createWorkerProcess_u24lambda_u242.addProcessListener((ProcessListener)new TextAndTerminationListener(processLifetimeDefinition));
            Companion.addToKnowRiderProcesses($this$createWorkerProcess_u24lambda_u242);
            $this$createWorkerProcess_u24lambda_u242.startNotify();
            return sqlProjWorkerProcess;
        }

        private final Protocol createProtocol(Lifetime lifetime) {
            RdDispatcher scheduler = new RdDispatcher(lifetime);
            return new Protocol("Rider Frontend to Sql Projects Worker", (ISerializers)new Serializers(), (IIdentities)new Identities(IdKind.Server), (IScheduler)scheduler, (IWire)new SocketWire.Server(lifetime, (IScheduler)scheduler, null, "FrontendToSqlProjWorker", false, 16, null), lifetime, new RdContext[0]);
        }

        private final GeneralCommandLine createWorkerCommandLine(int protocolPort) {
            GeneralCommandLine commandLine;
            GeneralCommandLine generalCommandLine;
            File workerDll = SqlprojPlugin.INSTANCE.getWorkerFolder().resolve("Rider.Sqlproj.Worker.dll").toFile();
            String parentPid = String.valueOf(ProcessHandle.current().pid());
            GeneralCommandLine $this$createWorkerCommandLine_u24lambda_u243 = generalCommandLine = new GeneralCommandLine();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)workerDll);
            AssemblyExecutionContext.Companion.create(workerDll, new String[0]).fillCommandLine($this$createWorkerCommandLine_u24lambda_u243);
            GeneralCommandLine $this$createWorkerCommandLine_u24lambda_u245 = generalCommandLine = (commandLine = generalCommandLine);
            boolean bl2 = false;
            Map map2 = $this$createWorkerCommandLine_u24lambda_u245.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironment(...)");
            Map map3 = map2;
            String string = "RESHARPER_HOST_LOG_DIR";
            String string2 = Companion.prepareLoggingDirectory();
            map3.put(string, string2);
            Map map4 = $this$createWorkerCommandLine_u24lambda_u245.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"getEnvironment(...)");
            map3 = map4;
            string = "RESHARPER_LOG_CONF";
            string2 = RiderEnvironment.INSTANCE.getLogBackendConf();
            map3.put(string, string2);
            String string3 = LocaleHelper.INSTANCE.getCurrentLocale();
            if (string3 != null) {
                String it = string3;
                boolean bl3 = false;
                Map map5 = $this$createWorkerCommandLine_u24lambda_u245.getEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map5, (String)"getEnvironment(...)");
                Map map6 = map5;
                map6.put("JET_BACKEND_CULTURE", it);
            }
            $this$createWorkerCommandLine_u24lambda_u245.addParameter(String.valueOf(protocolPort));
            $this$createWorkerCommandLine_u24lambda_u245.addParameter(parentPid);
            return generalCommandLine;
        }

        private final void addToKnowRiderProcesses(SqlProjWorkerProcess $this$addToKnowRiderProcesses) {
            RiderEnvironment.INSTANCE.addRiderAuxiliaryProcess((BaseOSProcessHandler)$this$addToKnowRiderProcesses);
            DotnetSelfProfilingProcesses.INSTANCE.add($this$addToKnowRiderProcesses.getLifetime(), "SqlProjects.Worker", (int)$this$addToKnowRiderProcesses.getProcess().pid());
        }

        private final String prepareLoggingDirectory() {
            String currentTimeString = new SimpleDateFormat("yyyy_M_dd_HH_mm_ss").format(new Date());
            File workerLogDir = FilesKt.resolve((File)new File(RiderEnvironment.INSTANCE.getLogDirectory(), "SqlProjectsWorker"), (String)("SqlProjectsWorker." + currentTimeString));
            workerLogDir.mkdirs();
            String string = workerLogDir.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }

        private static final Unit start$lambda$0(Ref.ObjectRef $process) {
            SqlProjWorkerProcess sqlProjWorkerProcess = (SqlProjWorkerProcess)((Object)$process.element);
            if (sqlProjWorkerProcess == null) {
                return Unit.INSTANCE;
            }
            SqlProjWorkerProcess processToKill = sqlProjWorkerProcess;
            if (!processToKill.isProcessTerminating() && !processToKill.isProcessTerminated()) {
                processToKill.killProcess();
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/sqlproj/host/SqlProjWorkerProcess$TextAndTerminationListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "definition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "escapeDecodes", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "sqlproj-plugin"})
    private static final class TextAndTerminationListener
    extends ProcessAdapter {
        @NotNull
        private final LifetimeDefinition definition;
        @NotNull
        private final AnsiEscapeDecoder escapeDecodes;

        public TextAndTerminationListener(@NotNull LifetimeDefinition definition) {
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            this.definition = definition;
            this.escapeDecodes = new AnsiEscapeDecoder();
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.escapeDecodes.escapeText(((Object)StringsKt.trim((CharSequence)string)).toString(), outputType, (arg_0, arg_1) -> TextAndTerminationListener.onTextAvailable$lambda$0(outputType, arg_0, arg_1));
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            logger.info("Sql Project Worker process terminated");
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.definition, (boolean)false, (int)1, null);
        }

        private static final void onTextAvailable$lambda$0(Key $outputType, String text, Key key) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)key, (String)"<unused var>");
            Key key2 = $outputType;
            if (Intrinsics.areEqual((Object)key2, (Object)ProcessOutputTypes.STDOUT)) {
                logger.info("SqlProjWorker - stdout: " + text);
            } else if (Intrinsics.areEqual((Object)key2, (Object)ProcessOutputTypes.SYSTEM)) {
                logger.info("SqlProjWorker - system: " + text);
            } else if (Intrinsics.areEqual((Object)key2, (Object)ProcessOutputTypes.STDERR)) {
                logger.warn("SqlProjWorker - stderr: " + text);
            } else {
                logger.info("SqlProjWorker - unknown: " + text);
            }
        }
    }
}

