/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj.host;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.sqlproj.generated.RdLoadedSqlProject;
import com.jetbrains.rider.sqlproj.generated.RdSqlProject;
import com.jetbrains.rider.sqlproj.generated.RdUnloadedSqlProject;
import com.jetbrains.rider.sqlproj.generated.RdUpdateProjectFromDatabaseParams;
import com.jetbrains.rider.sqlproj.generated.SqlProjWorkerToFrontendModel;
import com.jetbrains.rider.sqlproj.host.PublishHost;
import com.jetbrains.rider.sqlproj.host.SqlProjectsOperations;
import com.jetbrains.rider.sqlproj.host.SqlProjectsStorage;
import com.jetbrains.rider.sqlproj.publish.PublishSession;
import com.jetbrains.rider.sqlproj.schemaCompare.SchemaCompareHost;
import com.jetbrains.rider.sqlproj.schemaCompare.session.SchemaCompareSession;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0001>B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u0004\u0018\u00010\u001f2\u0006\u0010*\u001a\u00020+J\u000e\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+J\u001e\u0010/\u001a\u0002002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0086@\u00a2\u0006\u0002\u00103J*\u00104\u001a\u0002052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+2\n\b\u0002\u00101\u001a\u0004\u0018\u000102H\u0086@\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0016\u0010;\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0086@\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u000208H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020#0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u0011\u0010%\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006?"}, d2={"Lcom/jetbrains/rider/sqlproj/host/SqlProjHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "model", "Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlinx/coroutines/CoroutineScope;Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "getModel", "()Lcom/jetbrains/rider/sqlproj/generated/SqlProjWorkerToFrontendModel;", "schemaCompareHost", "Lcom/jetbrains/rider/sqlproj/schemaCompare/SchemaCompareHost;", "publishHost", "Lcom/jetbrains/rider/sqlproj/host/PublishHost;", "projectsStorage", "Lcom/jetbrains/rider/sqlproj/host/SqlProjectsStorage;", "operations", "Lcom/jetbrains/rider/sqlproj/host/SqlProjectsOperations;", "loadedProjects", "Lcom/jetbrains/rd/util/reactive/IViewableMap;", "Ljava/nio/file/Path;", "Lcom/jetbrains/rider/sqlproj/generated/RdLoadedSqlProject;", "getLoadedProjects", "()Lcom/jetbrains/rd/util/reactive/IViewableMap;", "unloadedProjects", "Lcom/jetbrains/rider/sqlproj/generated/RdUnloadedSqlProject;", "getUnloadedProjects", "databaseOperations", "getDatabaseOperations", "()Lcom/jetbrains/rider/sqlproj/host/SqlProjectsOperations;", "getSqlProject", "Lcom/jetbrains/rider/sqlproj/generated/RdSqlProject;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getLoadedSqlProject", "isProjectLoaded", "", "createSchemaCompareSession", "Lcom/jetbrains/rider/sqlproj/schemaCompare/session/SchemaCompareSession;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPublishSession", "Lcom/jetbrains/rider/sqlproj/publish/PublishSession;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateProjectFromDatabase", "", "parameters", "Lcom/jetbrains/rider/sqlproj/generated/RdUpdateProjectFromDatabaseParams;", "makeProjectCrossPlatform", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribeToErrorsFromWorker", "Companion", "sqlproj-plugin"})
@SourceDebugExtension(value={"SMAP\nSqlProjHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlProjHost.kt\ncom/jetbrains/rider/sqlproj/host/SqlProjHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,63:1\n13#2:64\n*S KotlinDebug\n*F\n+ 1 SqlProjHost.kt\ncom/jetbrains/rider/sqlproj/host/SqlProjHost\n*L\n24#1:64\n*E\n"})
public final class SqlProjHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final SqlProjWorkerToFrontendModel model;
    @NotNull
    private final SchemaCompareHost schemaCompareHost;
    @NotNull
    private final PublishHost publishHost;
    @NotNull
    private final SqlProjectsStorage projectsStorage;
    @NotNull
    private final SqlProjectsOperations operations;
    @NotNull
    private final IViewableMap<Path, RdLoadedSqlProject> loadedProjects;
    @NotNull
    private final IViewableMap<Path, RdUnloadedSqlProject> unloadedProjects;
    @NotNull
    private final SqlProjectsOperations databaseOperations;
    @NotNull
    private static final Logger logger;

    public SqlProjHost(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull CoroutineScope scope, @NotNull SqlProjWorkerToFrontendModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.project = project;
        this.lifetime = lifetime;
        this.scope = scope;
        this.model = model;
        this.schemaCompareHost = new SchemaCompareHost(this.project, this.model);
        this.publishHost = new PublishHost(this.model);
        this.projectsStorage = new SqlProjectsStorage(this.lifetime, this.model);
        this.operations = new SqlProjectsOperations(this.project, this.lifetime, this.scope, this.model);
        this.subscribeToErrorsFromWorker();
        this.loadedProjects = (IViewableMap)this.projectsStorage.getLoadedProjectPerLocation();
        this.unloadedProjects = (IViewableMap)this.projectsStorage.getUnloadedProjectPerLocation();
        this.databaseOperations = this.operations;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final SqlProjWorkerToFrontendModel getModel() {
        return this.model;
    }

    @NotNull
    public final IViewableMap<Path, RdLoadedSqlProject> getLoadedProjects() {
        return this.loadedProjects;
    }

    @NotNull
    public final IViewableMap<Path, RdUnloadedSqlProject> getUnloadedProjects() {
        return this.unloadedProjects;
    }

    @NotNull
    public final SqlProjectsOperations getDatabaseOperations() {
        return this.databaseOperations;
    }

    @Nullable
    public final RdSqlProject getSqlProject(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.projectsStorage.getProject(entity);
    }

    @Nullable
    public final RdLoadedSqlProject getLoadedSqlProject(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.projectsStorage.getLoadedProject(entity);
    }

    public final boolean isProjectLoaded(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.projectsStorage.isProjectLoaded(entity);
    }

    @Nullable
    public final Object createSchemaCompareSession(@NotNull Lifetime lifetime, @NotNull VirtualFile file, @NotNull Continuation<? super SchemaCompareSession> $completion) {
        return this.schemaCompareHost.createCompareSession(lifetime, file, $completion);
    }

    @Nullable
    public final Object createPublishSession(@NotNull Lifetime lifetime, @NotNull ProjectModelEntity entity, @Nullable VirtualFile file, @NotNull Continuation<? super PublishSession> $completion) {
        return this.publishHost.createPublishSession(lifetime, entity, file, $completion);
    }

    public static /* synthetic */ Object createPublishSession$default(SqlProjHost sqlProjHost, Lifetime lifetime, ProjectModelEntity projectModelEntity, VirtualFile virtualFile, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            virtualFile = null;
        }
        return sqlProjHost.createPublishSession(lifetime, projectModelEntity, virtualFile, (Continuation<? super PublishSession>)continuation);
    }

    public final void updateProjectFromDatabase(@NotNull RdUpdateProjectFromDatabaseParams parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.model.getUpdateProjectFromDatabase().fire((Object)parameters);
    }

    @Nullable
    public final Object makeProjectCrossPlatform(@NotNull ProjectModelEntity entity, @NotNull Continuation<? super Boolean> $completion) {
        Object object = entity.getUrl();
        if (object == null || (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) == null || (object = object.getPath()) == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        Object path = object;
        return IRdCall.DefaultImpls.startSuspending$default(this.model.getMakeProjectCrossPlatform(), (Lifetime)this.lifetime, (Object)path, null, $completion, (int)4, null);
    }

    private final void subscribeToErrorsFromWorker() {
        this.model.getError().advise(this.lifetime, SqlProjHost::subscribeToErrorsFromWorker$lambda$0);
    }

    private static final Unit subscribeToErrorsFromWorker$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.error("Error in sqlproj worker: " + it);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SqlProjHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SqlProjHost.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/sqlproj/host/SqlProjHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sqlproj-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

