/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mssql.AzureDialect;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.sqlproj.generated.RdLoadedSqlProject;
import com.jetbrains.rider.sqlproj.generated.RdTargetPlatform;
import com.jetbrains.rider.sqlproj.host.SqlProjHost;
import com.jetbrains.rider.sqlproj.host.extensions.SqlprojHostStartedListener;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/sqlproj/SqlProjectDialectConfigurator;", "Lcom/jetbrains/rider/sqlproj/host/extensions/SqlprojHostStartedListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "onCreated", "", "host", "Lcom/jetbrains/rider/sqlproj/host/SqlProjHost;", "getDialectFromTargetPlatform", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "targetPlatform", "Lcom/jetbrains/rider/sqlproj/generated/RdTargetPlatform;", "sqlproj-plugin"})
public final class SqlProjectDialectConfigurator
implements SqlprojHostStartedListener {
    @NotNull
    private final Project project;

    public SqlProjectDialectConfigurator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void onCreated(@NotNull SqlProjHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        host.getLoadedProjects().view(host.getLifetime(), (arg_0, arg_1) -> SqlProjectDialectConfigurator.onCreated$lambda$1(this, arg_0, arg_1));
    }

    private final SqlLanguageDialect getDialectFromTargetPlatform(RdTargetPlatform targetPlatform) {
        RdTargetPlatform rdTargetPlatform = targetPlatform;
        return switch (rdTargetPlatform == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rdTargetPlatform.ordinal()]) {
            case 1 -> {
                MsDialect v1 = MsDialect.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"INSTANCE");
                yield (SqlLanguageDialect)v1;
            }
            case 2 -> {
                AzureDialect v3 = AzureDialect.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"INSTANCE");
                yield (SqlLanguageDialect)v3;
            }
            case 3 -> {
                AzureDialect v4 = AzureDialect.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"INSTANCE");
                yield (SqlLanguageDialect)v4;
            }
            case -1 -> {
                MsDialect v5 = MsDialect.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"INSTANCE");
                yield (SqlLanguageDialect)v5;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit onCreated$lambda$1$lambda$0(SqlProjectDialectConfigurator this$0, VirtualFile $projectFolder, RdTargetPlatform rdPlatform) {
        SqlLanguageDialect newDialect = this$0.getDialectFromTargetPlatform(rdPlatform);
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getInstance((Project)this$0.project).getMapping($projectFolder);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getMapping(...)");
        SqlLanguageDialect existingDialect = sqlLanguageDialect;
        if (Intrinsics.areEqual((Object)newDialect, (Object)existingDialect)) {
            return Unit.INSTANCE;
        }
        SqlDialectMappings.getInstance((Project)this$0.project).setMapping($projectFolder, (Object)newDialect);
        return Unit.INSTANCE;
    }

    private static final Unit onCreated$lambda$1(SqlProjectDialectConfigurator this$0, Lifetime projectLifetime, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)projectLifetime, (String)"projectLifetime");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Path path = (Path)entry.getKey();
        RdLoadedSqlProject sqlProject = (RdLoadedSqlProject)((Object)entry.getValue());
        VirtualFile virtualFile = VfsUtil.findFile((Path)path.getParent(), (boolean)false);
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile projectFolder = virtualFile;
        sqlProject.getTargetPlatform().advise(projectLifetime, arg_0 -> SqlProjectDialectConfigurator.onCreated$lambda$1$lambda$0(this$0, projectFolder, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdTargetPlatform.values().length];
            try {
                nArray[RdTargetPlatform.SqlServer.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTargetPlatform.Azure.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTargetPlatform.Synapse.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

