/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.sqlproj;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.sqlproj.utils.DatabaseExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/sqlproj/SqlProjInspectionSuppressor;", "Lcom/intellij/codeInspection/InspectionSuppressor;", "<init>", "()V", "isSuppressedFor", "", "element", "Lcom/intellij/psi/PsiElement;", "toolId", "", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "isInspectionCandidateForSuppression", "sqlproj-plugin"})
public final class SqlProjInspectionSuppressor
implements InspectionSuppressor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        if (!this.isInspectionCandidateForSuppression(toolId)) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile);
        if (!DatabaseExtensionsKt.isFileWithMsDialect(psiFile)) return false;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DatabaseExtensionsKt.projectEntityNeedsBinding(virtualFile, project)) return false;
        return true;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        return new SuppressQuickFix[0];
    }

    private final boolean isInspectionCandidateForSuppression(String toolId) {
        return Intrinsics.areEqual((Object)toolId, (Object)"SqlResolve");
    }
}

