/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.statistics;

import com.intellij.cwm.plugin.common.telephony.TelephonySession;
import com.intellij.cwm.plugin.common.telephony.TelephonySessionListener;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/cwm/plugin/common/statistics/TelephonySessionStatisticsListener;", "Lcom/intellij/cwm/plugin/common/telephony/TelephonySessionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "telephonySessionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/cwm/plugin/common/telephony/TelephonySession;", "statisticsHandler", "activityDefinition", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "Companion", "intellij.cwm.plugin.common"})
@SourceDebugExtension(value={"SMAP\nTelephonySessionStatisticsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelephonySessionStatisticsListener.kt\ncom/intellij/cwm/plugin/common/statistics/TelephonySessionStatisticsListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,52:1\n13#2:53\n*S KotlinDebug\n*F\n+ 1 TelephonySessionStatisticsListener.kt\ncom/intellij/cwm/plugin/common/statistics/TelephonySessionStatisticsListener\n*L\n16#1:53\n*E\n"})
public final class TelephonySessionStatisticsListener
implements TelephonySessionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public TelephonySessionStatisticsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void telephonySessionCreated(@NotNull Lifetime lifetime, @NotNull TelephonySession session) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)session.getCameraEnabled()), (Lifetime)lifetime, arg_0 -> TelephonySessionStatisticsListener.telephonySessionCreated$lambda$0(this, arg_0));
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)session.getMicrophoneEnabled()), (Lifetime)lifetime, arg_0 -> TelephonySessionStatisticsListener.telephonySessionCreated$lambda$1(this, arg_0));
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)session.getConferenceJoined()), (Lifetime)lifetime, arg_0 -> TelephonySessionStatisticsListener.telephonySessionCreated$lambda$2(this, arg_0));
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)session.getScreenSharingEnabled()), (Lifetime)lifetime, arg_0 -> TelephonySessionStatisticsListener.telephonySessionCreated$lambda$3(this, arg_0));
    }

    private final void statisticsHandler(Lifetime lifetime, IdeActivityDefinition activityDefinition) {
        Ref.ObjectRef activity = new Ref.ObjectRef();
        lifetime.bracketIfAlive(() -> TelephonySessionStatisticsListener.statisticsHandler$lambda$0(activity, activityDefinition, this), () -> TelephonySessionStatisticsListener.statisticsHandler$lambda$1(activity));
    }

    private static final Unit telephonySessionCreated$lambda$0(TelephonySessionStatisticsListener this$0, Lifetime cameraEnabledLifetime) {
        Intrinsics.checkNotNullParameter((Object)cameraEnabledLifetime, (String)"cameraEnabledLifetime");
        this$0.statisticsHandler(cameraEnabledLifetime, CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.getCAMERA_ENABLED());
        return Unit.INSTANCE;
    }

    private static final Unit telephonySessionCreated$lambda$1(TelephonySessionStatisticsListener this$0, Lifetime microphoneEnabledLifetime) {
        Intrinsics.checkNotNullParameter((Object)microphoneEnabledLifetime, (String)"microphoneEnabledLifetime");
        this$0.statisticsHandler(microphoneEnabledLifetime, CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.getMICROPHONE_ENABLED());
        return Unit.INSTANCE;
    }

    private static final Unit telephonySessionCreated$lambda$2(TelephonySessionStatisticsListener this$0, Lifetime conferenceJoinedLifetime) {
        Intrinsics.checkNotNullParameter((Object)conferenceJoinedLifetime, (String)"conferenceJoinedLifetime");
        this$0.statisticsHandler(conferenceJoinedLifetime, CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.getVOICE_CALL_JOINED());
        return Unit.INSTANCE;
    }

    private static final Unit telephonySessionCreated$lambda$3(TelephonySessionStatisticsListener this$0, Lifetime screenSharingEnabledLifetime) {
        Intrinsics.checkNotNullParameter((Object)screenSharingEnabledLifetime, (String)"screenSharingEnabledLifetime");
        this$0.statisticsHandler(screenSharingEnabledLifetime, CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.getSCREEN_SHARING_ENABLED());
        return Unit.INSTANCE;
    }

    private static final Unit statisticsHandler$lambda$0(Ref.ObjectRef $activity, IdeActivityDefinition $activityDefinition, TelephonySessionStatisticsListener this$0) {
        $activity.element = IdeActivityDefinition.started$default((IdeActivityDefinition)$activityDefinition, (Project)this$0.project, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit statisticsHandler$lambda$1(Ref.ObjectRef $activity) {
        block1: {
            if ($activity.element == null) {
                logger.warn("Cwm telephony statistics has issue. Statistics activity is 'null'.");
            }
            StructuredIdeActivity structuredIdeActivity = (StructuredIdeActivity)$activity.element;
            if (structuredIdeActivity == null) break block1;
            StructuredIdeActivity.finished$default((StructuredIdeActivity)structuredIdeActivity, null, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TelephonySessionStatisticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TelephonySessionStatisticsListener.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cwm/plugin/common/statistics/TelephonySessionStatisticsListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.plugin.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

