/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.v2.diagrams.typeDependency.utils;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdDependencyKind;
import com.jetbrains.rd.ide.model.RdDiagramDependencyEdge;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rider.ui.RiderColorKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000b0\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/v2/diagrams/typeDependency/utils/RiderCollapsedEdgeTooltipHtmlGenerator;", "", "<init>", "()V", "MAX_VALUES", "", "getDependencyKindBlock", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "dependencyKind", "Lcom/jetbrains/rd/ide/model/RdDependencyKind;", "dependencyInfos", "", "Lcom/jetbrains/rd/ide/model/RdDiagramDependencyEdge;", "color", "Ljava/awt/Color;", "generateTable", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "tableElements", "Lcom/intellij/openapi/util/text/HtmlChunk;", "intellij.rider.plugins.diagram"})
public final class RiderCollapsedEdgeTooltipHtmlGenerator {
    @NotNull
    public static final RiderCollapsedEdgeTooltipHtmlGenerator INSTANCE = new RiderCollapsedEdgeTooltipHtmlGenerator();
    private static final int MAX_VALUES = 6;

    private RiderCollapsedEdgeTooltipHtmlGenerator() {
    }

    @NotNull
    public final HtmlBuilder getDependencyKindBlock(@NotNull RdDependencyKind dependencyKind, @NotNull List<RdDiagramDependencyEdge> dependencyInfos, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)dependencyKind, (String)"dependencyKind");
        Intrinsics.checkNotNullParameter(dependencyInfos, (String)"dependencyInfos");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        HtmlBuilder builder = new HtmlBuilder();
        builder.append((HtmlChunk)HtmlChunk.text((String)dependencyKind.name()).bold());
        List tableElements = new ArrayList();
        int n = Math.min(6, dependencyInfos.size());
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new HtmlChunk[3];
            HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.icon((String)dependencyInfos.get(i).getSource().getName(), (Icon)UtilKt.fromModel((IconModel)dependencyInfos.get(i).getSource().getIcon())), HtmlChunk.text((String)dependencyInfos.get(i).getSource().getName())};
            objectArray[0] = HtmlChunk.fragment((HtmlChunk[])htmlChunkArray);
            objectArray[1] = HtmlChunk.text((String)" \u2192 ").wrapWith(HtmlChunk.font((String)RiderColorKt.toHtml((Color)color)));
            htmlChunkArray = new HtmlChunk[]{HtmlChunk.icon((String)dependencyInfos.get(i).getTarget().getName(), (Icon)UtilKt.fromModel((IconModel)dependencyInfos.get(i).getTarget().getIcon())), HtmlChunk.text((String)dependencyInfos.get(i).getTarget().getName())};
            objectArray[2] = HtmlChunk.fragment((HtmlChunk[])htmlChunkArray);
            tableElements.add(CollectionsKt.mutableListOf((Object[])objectArray));
        }
        builder.append((HtmlChunk)this.generateTable(tableElements));
        if (dependencyInfos.size() > 6) {
            builder.append(HtmlChunk.text((String)("And " + (dependencyInfos.size() - 6) + " more")));
        }
        return builder;
    }

    private final HtmlChunk.Element generateTable(List<? extends List<? extends HtmlChunk>> tableElements) {
        HtmlBuilder builder = new HtmlBuilder();
        for (List<? extends HtmlChunk> list : tableElements) {
            HtmlBuilder row = new HtmlBuilder();
            for (HtmlChunk htmlChunk : list) {
                row.append((HtmlChunk)htmlChunk.wrapWith("td"));
            }
            builder.append((HtmlChunk)row.wrapWith("tr"));
        }
        builder.wrapWith("table");
        HtmlChunk.Element element = builder.wrapWith("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"wrapWith(...)");
        return element;
    }
}

