/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.v2.diagrams.typeDependency.actions.showDependencies;

import com.intellij.diagram.v2.actions.GraphChartToolbarAction;
import com.intellij.diagram.v2.handles.GraphChartHandle;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.RdDependencyKind;
import com.jetbrains.rd.ide.model.RdDiagramClrNode;
import com.jetbrains.rd.ide.model.RdDiagramDependencyEdge;
import com.jetbrains.rider.diagrams.architecture.v2.DiagramHost;
import com.jetbrains.rider.diagrams.architecture.v2.diagrams.typeDependency.fus.RiderTypeDependencyDiagramLogger;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH&J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/v2/diagrams/typeDependency/actions/showDependencies/ShowDependenciesAction;", "Lcom/intellij/diagram/v2/actions/GraphChartToolbarAction$GraphChartToolbarToggleAction;", "Lcom/jetbrains/rd/ide/model/RdDiagramClrNode;", "Lcom/jetbrains/rd/ide/model/RdDiagramDependencyEdge;", "fqn", "", "<init>", "(Ljava/lang/String;)V", "host", "Lcom/jetbrains/rider/diagrams/architecture/v2/DiagramHost;", "getDependencyKind", "Lcom/jetbrains/rd/ide/model/RdDependencyKind;", "getIcon", "Ljavax/swing/Icon;", "setupTemplatePresentation", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "chart", "Lcom/intellij/diagram/v2/handles/GraphChartHandle;", "isSelected", "", "onToggle", "newState", "intellij.rider.plugins.diagram"})
public abstract class ShowDependenciesAction
implements GraphChartToolbarAction.GraphChartToolbarToggleAction<RdDiagramClrNode, RdDiagramDependencyEdge> {
    @NotNull
    private final String fqn;
    @Nullable
    private DiagramHost host;

    public ShowDependenciesAction(@NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        this.fqn = fqn;
    }

    @NotNull
    public abstract RdDependencyKind getDependencyKind();

    @NotNull
    public abstract Icon getIcon();

    public void setupTemplatePresentation(@NotNull Presentation presentation, @NotNull GraphChartHandle<RdDiagramClrNode, RdDiagramDependencyEdge> chart) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        Project project = chart.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.host = DiagramHost.Companion.getInstance(project);
        presentation.setIcon(this.getIcon());
        presentation.setText(this.getDependencyKind().toString());
    }

    public boolean isSelected() {
        DiagramHost diagramHost = this.host;
        Intrinsics.checkNotNull((Object)((Object)diagramHost));
        return diagramHost.isDependencyKindActivated(this.fqn, this.getDependencyKind());
    }

    public void onToggle(@NotNull GraphChartHandle<RdDiagramClrNode, RdDiagramDependencyEdge> chart, boolean newState) {
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        if (this.host == null) {
            return;
        }
        if (!this.isSelected()) {
            DiagramHost diagramHost = this.host;
            Intrinsics.checkNotNull((Object)((Object)diagramHost));
            diagramHost.activateDependencyKind(this.fqn, this.getDependencyKind());
        } else {
            DiagramHost diagramHost = this.host;
            Intrinsics.checkNotNull((Object)((Object)diagramHost));
            diagramHost.deactivateDependencyKind(this.fqn, this.getDependencyKind());
        }
        RiderTypeDependencyDiagramLogger.INSTANCE.logDependencyFiltrationAction(this.getDependencyKind(), this.isSelected());
    }
}

