/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.graph;

import com.google.common.collect.BiMap;
import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataModelWrapper;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeMap;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.base.NodeMap;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.threading.GraphThreadingType;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.rider.diagrams.architecture.DiagramHost;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramDataModel;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphGroupManager;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphLayouter;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphUtil;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramNode;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderGroupableDiagramNode;
import com.jetbrains.rider.diagrams.architecture.infrastructure.RiderGraphEditMode;
import com.jetbrains.rider.diagrams.architecture.infrastructure.RiderGraphEditModeFactoryImpl;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u009f\u00012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00012\u00020\u00042\u00020\u00052\u00020\u0006:\u0002\u009f\u0001B=\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u001cH\u0016J\b\u0010.\u001a\u00020\u0019H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0016J&\u00102\u001a\u00020)2\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u00022\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0014J\u0006\u0010:\u001a\u00020)J\b\u0010;\u001a\u00020)H\u0002J\u0018\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u001eH\u0016J\b\u0010?\u001a\u00020\u0013H\u0016J\b\u0010@\u001a\u00020)H\u0016J\b\u0010A\u001a\u00020\u0013H\u0016J\u001c\u0010B\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030CH\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u0010H\u0016J\n\u0010F\u001a\u0004\u0018\u00010GH\u0016J\b\u0010H\u001a\u00020)H\u0016J\n\u0010I\u001a\u0004\u0018\u00010JH\u0002J\n\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u0010\u0010M\u001a\u00020)2\u0006\u0010N\u001a\u00020LH\u0016J\u0010\u0010O\u001a\u00020)2\u0006\u0010P\u001a\u00020\u001eH\u0016J\f\u0010Q\u001a\u0006\u0012\u0002\b\u00030RH\u0016J\b\u0010S\u001a\u00020TH\u0016J\n\u0010U\u001a\u0004\u0018\u000101H\u0016J\u001c\u0010V\u001a\u00020)2\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010W\u001a\u00020\u001eH\u0016J\b\u0010X\u001a\u00020)H\u0016J\u0006\u0010Y\u001a\u00020)J\u0018\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020&2\u0006\u0010]\u001a\u00020^H\u0002J\u0006\u0010_\u001a\u00020)J\b\u0010`\u001a\u00020)H\u0016JD\u0010a\u001a\u00020)2\u001c\u0010b\u001a\u0018\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\b\u0001\u0012\u00020%\u0018\u00010c2\u001c\u0010d\u001a\u0018\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\b\u0001\u0012\u00020e\u0018\u00010cH\u0016J\u001e\u0010f\u001a\u00020)2\u0006\u0010g\u001a\u00020\u001e2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020)0iH\u0002J\u001c\u0010j\u001a\u00020)2\u0006\u0010k\u001a\u0002052\n\u0010l\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0014\u0010m\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020n0\u0017H\u0002J\u001c\u0010o\u001a\u00020)2\u0012\u0010p\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020n0\u0017H\u0002J\b\u0010q\u001a\u00020)H\u0002J\u0018\u0010r\u001a\u0004\u0018\u00010s2\f\u0010l\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002H\u0002J\b\u0010t\u001a\u00020)H\u0016J\b\u0010u\u001a\u00020\u001eH\u0016J \u0010v\u001a\u00020)2\u000e\u0010w\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030C2\u0006\u0010x\u001a\u00020\u0018H\u0016J \u0010y\u001a\u00020)2\u000e\u0010w\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030C2\u0006\u0010x\u001a\u00020\u0018H\u0016J\b\u0010z\u001a\u00020)H\u0016J\u0014\u0010{\u001a\b\u0012\u0004\u0012\u00020%0|2\u0006\u0010}\u001a\u00020~J\u001b\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020%0\u001b2\r\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020%0|J\r\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020%0|J\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020%0|J\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020&0|J\u001c\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020%0\u001b2\r\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020&0|J\u0019\u0010\u0086\u0001\u001a\u0004\u0018\u00010&2\u0006\u00103\u001a\u00020%H\u0002\u00a2\u0006\u0003\u0010\u0087\u0001J\u0014\u0010\u0088\u0001\u001a\u0004\u0018\u00010%2\u0007\u0010\u0089\u0001\u001a\u00020&H\u0002J\u0017\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020%0|2\u0006\u00103\u001a\u00020%H\u0002J9\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020%0|2\u0006\u0010}\u001a\u00020~2 \u0010\u008c\u0001\u001a\u001b\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u001b\u0012\u0004\u0012\u00020)0\u008d\u0001H\u0002J\u0011\u0010\u008e\u0001\u001a\u00020\u001e2\u0006\u00103\u001a\u00020%H\u0002J\u001b\u0010\u008f\u0001\u001a\u00020)2\u0012\u0010\u0090\u0001\u001a\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0091\u0001J\t\u0010\u0092\u0001\u001a\u00020)H\u0002J\u0013\u0010\u0093\u0001\u001a\u00020)2\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u0002J\t\u0010\u0096\u0001\u001a\u00020)H\u0014J\t\u0010\u0097\u0001\u001a\u00020)H\u0002J\t\u0010\u0098\u0001\u001a\u00020)H\u0002J\t\u0010\u0099\u0001\u001a\u00020)H\u0002J\u0006\u0010g\u001a\u00020)J\u0007\u0010\u009a\u0001\u001a\u00020)J\u001a\u0010\u009b\u0001\u001a\u00020)2\u0006\u00103\u001a\u00020%2\u0007\u0010\u009c\u0001\u001a\u00020\u001eH\u0014J\u0007\u0010\u009d\u0001\u001a\u00020)J\u0013\u0010\u009e\u0001\u001a\u0004\u0018\u0001052\u0006\u0010x\u001a\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020%0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a0\u0001"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder;", "Lcom/intellij/openapi/graph/impl/builder/GraphBuilderImpl;", "Lcom/intellij/diagram/DiagramNode;", "Lcom/intellij/diagram/DiagramEdge;", "Lcom/intellij/diagram/DiagramBuilder;", "Lcom/intellij/openapi/graph/builder/event/GraphBuilderListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "myProject", "Lcom/intellij/openapi/project/Project;", "myGraph", "Lcom/intellij/openapi/graph/view/Graph2D;", "myView", "Lcom/intellij/openapi/graph/view/Graph2DView;", "myLayouter", "Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphLayouter;", "myGraphDataModel", "Lcom/intellij/diagram/DiagramDataModel;", "Lcom/jetbrains/rider/diagrams/architecture/graphElements/RiderDiagramNode;", "myGraphPresentationModel", "Lcom/intellij/diagram/DiagramPresentationModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/graph/view/Graph2D;Lcom/intellij/openapi/graph/view/Graph2DView;Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphLayouter;Lcom/intellij/diagram/DiagramDataModel;Lcom/intellij/diagram/DiagramPresentationModel;)V", "states", "", "Lcom/intellij/openapi/graph/builder/event/GraphBuilderEvent;", "Lcom/intellij/diagram/presentation/DiagramState;", "updaters", "", "Lcom/intellij/openapi/graph/builder/CustomGraphUpdater;", "popupMode", "", "myListener", "Lcom/intellij/openapi/graph/view/Graph2DSelectionListener;", "hiddenEdges", "edgesToPartialUpdate", "nodeIdsMap", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/intellij/openapi/graph/base/Node;", "", "groupIdNodeMap", "initialize", "", "getRiderDataModel", "Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramDataModel;", "addCustomUpdater", "updater", "getPresentation", "setEditor", "editor", "Lcom/intellij/diagram/DiagramFileEditor;", "createDraggedNode", "node", "nodeName", "", "point", "Ljava/awt/Point;", "createDefaultEditMode", "Lcom/intellij/openapi/graph/view/EditMode;", "updateEdges", "updateEdgeRealizers", "update", "increaseModTrackerCounter", "updateLayout", "getGraphPresentationModel", "relayout", "getPresentationModel", "getGraphBuilder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "getDataModel", "", "getDocumentReference", "Lcom/intellij/openapi/command/undo/DocumentReference;", "notifyOtherBuilders", "getEditorFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "setPopup", "popup", "setAllowEdgeCreation", "allow", "getProvider", "Lcom/intellij/diagram/DiagramProvider;", "getColorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getEditor", "setSelected", "selected", "updateView", "updateEdgesView", "convertToYFilesLineType", "Lcom/intellij/openapi/graph/view/LineType;", "width", "type", "Lcom/intellij/diagram/presentation/DiagramLineType;", "updateDataModelAndGroups", "updateDataModel", "updateDataModelWithCustomMapping", "nodeMapping", "Ljava/util/function/Function;", "edgeMapping", "Lcom/intellij/openapi/graph/base/Edge;", "updateViewWithCustomLayouting", "doLayout", "layout", "Lkotlin/Function0;", "addNode", "name", "nodeObject", "saveGroupRealizers", "Lcom/intellij/openapi/graph/view/NodeRealizer;", "restoreGroupRealizers", "map", "deduplicateEdges", "getInnerGraph", "Lcom/intellij/openapi/graph/base/Graph;", "requestFocus", "isPopupMode", "beforeActionPerformed", "builder", "event", "actionPerformed", "dispose", "getSelectedNodesByCursor", "", "cursor", "Lcom/intellij/openapi/graph/base/NodeCursor;", "getSelectedNodesFromPlain", "nodes", "getSelectedNodes", "getSelectedNodesPlain", "getSelectedNodesIdsPlain", "getSelectedNodesByIds", "ids", "getNodeId", "(Lcom/intellij/openapi/graph/base/Node;)Ljava/lang/Integer;", "getNodeById", "id", "getInnerNodes", "collectNodesFromCursor", "collector", "Lkotlin/Function2;", "isGroupNode", "addEdgesToUpdate", "edges", "", "updateEdgeLabels", "clearLabels", "edgeRealizer", "Lcom/intellij/openapi/graph/view/EdgeRealizer;", "updateGroups", "clearGraph", "clearNodes", "clearEdges", "doAnimatedLayout", "updateNodeRealizer", "doNodeSizeUpdate", "groupRelayout", "getGroupId", "Companion", "intellij.rider.plugins.diagram"})
@SourceDebugExtension(value={"SMAP\nRiderGraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderGraphBuilder.kt\ncom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,623:1\n13402#2,2:624\n13402#2,2:628\n13402#2,2:630\n13402#2,2:644\n13402#2:663\n13402#2,2:664\n13403#2:666\n3829#2:667\n4344#2,2:668\n13402#2,2:670\n1863#3,2:626\n1863#3,2:632\n1863#3,2:636\n1863#3,2:638\n1863#3,2:640\n1863#3,2:642\n1863#3,2:646\n1611#3,9:648\n1863#3:657\n1864#3:659\n1620#3:660\n1863#3,2:661\n216#4,2:634\n1#5:658\n*S KotlinDebug\n*F\n+ 1 RiderGraphBuilder.kt\ncom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder\n*L\n149#1:624,2\n186#1:628,2\n189#1:630,2\n386#1:644,2\n554#1:663\n558#1:664,2\n554#1:666\n578#1:667\n578#1:668,2\n224#1:670,2\n159#1:626,2\n270#1:632,2\n327#1:636,2\n355#1:638,2\n366#1:640,2\n377#1:642,2\n463#1:646,2\n489#1:648,9\n489#1:657\n489#1:659\n489#1:660\n494#1:661,2\n308#1:634,2\n489#1:658\n*E\n"})
public final class RiderGraphBuilder
extends GraphBuilderImpl<DiagramNode<?>, DiagramEdge<?>>
implements DiagramBuilder,
GraphBuilderListener,
DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Graph2D myGraph;
    @NotNull
    private final RiderGraphLayouter myLayouter;
    @NotNull
    private final DiagramDataModel<RiderDiagramNode> myGraphDataModel;
    @NotNull
    private final Map<GraphBuilderEvent, DiagramState> states;
    @NotNull
    private final List<CustomGraphUpdater> updaters;
    private boolean popupMode;
    @NotNull
    private final Graph2DSelectionListener myListener;
    @NotNull
    private final List<DiagramEdge<?>> hiddenEdges;
    @NotNull
    private final List<DiagramEdge<?>> edgesToPartialUpdate;
    @NotNull
    private final BidirectionalMap<Node, Integer> nodeIdsMap;
    @NotNull
    private BidirectionalMap<Integer, Node> groupIdNodeMap;
    @NotNull
    private static final Key<DiagramFileEditor> UML_FILE_EDITOR;
    @NotNull
    private static final Key<VirtualFile> EDITOR_FILE;

    public RiderGraphBuilder(@NotNull Project myProject, @NotNull Graph2D myGraph, @NotNull Graph2DView myView, @NotNull RiderGraphLayouter myLayouter, @NotNull DiagramDataModel<RiderDiagramNode> myGraphDataModel, @NotNull DiagramPresentationModel myGraphPresentationModel) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myGraph, (String)"myGraph");
        Intrinsics.checkNotNullParameter((Object)myView, (String)"myView");
        Intrinsics.checkNotNullParameter((Object)myLayouter, (String)"myLayouter");
        Intrinsics.checkNotNullParameter(myGraphDataModel, (String)"myGraphDataModel");
        Intrinsics.checkNotNullParameter((Object)myGraphPresentationModel, (String)"myGraphPresentationModel");
        super(myProject, myGraph, myView, (GraphDataModel)new DiagramDataModelWrapper(myGraphDataModel), (GraphPresentationModel)myGraphPresentationModel, GraphThreadingType.OLD_EDT_BASED, null);
        this.myGraph = myGraph;
        this.myLayouter = myLayouter;
        this.myGraphDataModel = myGraphDataModel;
        this.states = new LinkedHashMap();
        this.updaters = new ArrayList();
        this.myListener = arg_0 -> RiderGraphBuilder.myListener$lambda$0(myGraphPresentationModel, arg_0);
        this.hiddenEdges = new ArrayList();
        this.edgesToPartialUpdate = new ArrayList();
        this.nodeIdsMap = new BidirectionalMap();
        this.groupIdNodeMap = new BidirectionalMap();
        myGraphPresentationModel.setGraphBuilder((GraphBuilder)this);
        this.myGraphDataModel.putUserData(DiagramDataKeys.GRAPH_BUILDER, (Object)this);
        this.myGraph.addGraph2DSelectionListener(this.myListener);
        this.addGraphBuilderListener(this, (Disposable)this);
    }

    public void initialize() {
        super.initialize();
        this.updateGraph(false, CollectionsKt.emptyList());
    }

    private final RiderProjectDiagramDataModel getRiderDataModel() {
        DiagramDataModel<RiderDiagramNode> diagramDataModel = this.myGraphDataModel;
        return diagramDataModel instanceof RiderProjectDiagramDataModel ? (RiderProjectDiagramDataModel)diagramDataModel : null;
    }

    public void addCustomUpdater(@NotNull CustomGraphUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        this.updaters.add(updater);
    }

    @NotNull
    public DiagramState getPresentation() {
        DiagramState diagramState = this.getGraphPresentationModel().getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)diagramState, (String)"getPresentation(...)");
        return diagramState;
    }

    public void setEditor(@NotNull DiagramFileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.putUserData(UML_FILE_EDITOR, editor);
        editor.putUserData(Utils.GRAPH_BUILDER, (Object)this);
    }

    public void createDraggedNode(@NotNull DiagramNode<?> node, @Nullable String nodeName, @NotNull Point point) {
        block1: {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Node nodeObj = NodeFactory.getInstance().createDraggedNode((GraphBuilder)this, node, node.getTooltip(), point);
            this.getDataModel().refreshDataModel();
            if (nodeObj == null) break block1;
            NodeLayout nodeLayout = this.getGraph().getNodeLayout((Object)nodeObj);
            if (nodeLayout != null) {
                nodeLayout.setLocation((double)point.x, (double)point.y);
            }
        }
    }

    @NotNull
    protected EditMode createDefaultEditMode() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        EditMode editMode = RiderGraphEditModeFactoryImpl.Companion.getInstance(project).createEditMode((GraphBuilder)this);
        editMode.assignNodeLabel(false);
        editMode.allowResizeNodes(true);
        editMode.allowNodeCreation(false);
        editMode.allowEdgeCreation(true);
        editMode.allowMoveLabels(true);
        editMode.allowMovePorts(true);
        editMode.allowMoveSelection(true);
        editMode.allowMovingWithPopup(true);
        editMode.showNodeTips(true);
        editMode.showEdgeTips(true);
        return editMode;
    }

    public final void updateEdges() {
        this.updateEdgeRealizers();
        this.doLayout();
        this.getGraph().updateViews();
    }

    private final void updateEdgeRealizers() {
        Edge[] edgeArray = this.getGraph().getEdgeArray();
        Intrinsics.checkNotNullExpressionValue((Object)edgeArray, (String)"getEdgeArray(...)");
        Object[] $this$forEach$iv = edgeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EdgeRealizer realizer;
            Edge it = (Edge)element$iv;
            boolean bl = false;
            DiagramEdge edgeObjects = (DiagramEdge)this.getEdgeObject(it);
            Intrinsics.checkNotNullExpressionValue((Object)this.getGraphPresentationModel().getEdgeRealizer((Object)edgeObjects), (String)"getEdgeRealizer(...)");
            this.getGraph().setRealizer(it, realizer);
        }
    }

    public void update(boolean increaseModTrackerCounter, boolean updateLayout) {
        if (increaseModTrackerCounter) {
            this.getGraphPresentationModel().update();
            Collection collection = this.getEdgeObjects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEdgeObjects(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DiagramEdge it = (DiagramEdge)element$iv;
                boolean bl = false;
                Edge edge = this.getEdge(it);
                Utils.assertForgetToRemoveEdge((Edge)edge, (DiagramEdge)it, (DiagramBuilder)this);
                if (!updateLayout) continue;
                this.getGraph().getRealizer(edge).clearBends();
            }
        }
        this.updateGraph(false);
        if (updateLayout) {
            JBPopup popup;
            this.relayout();
            if (this.isPopupMode() && (popup = (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP)) != null && popup.isDisposed()) {
                GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, (GraphBuilder)this);
            }
        }
    }

    @NotNull
    public DiagramPresentationModel getGraphPresentationModel() {
        GraphPresentationModel graphPresentationModel = super.getGraphPresentationModel();
        Intrinsics.checkNotNull((Object)graphPresentationModel, (String)"null cannot be cast to non-null type com.intellij.diagram.DiagramPresentationModel");
        return (DiagramPresentationModel)graphPresentationModel;
    }

    public void relayout() {
        Edge it;
        NodeMap nodeMap = this.getGraphUpdateModel().getNodeUpdatesDataMap();
        Intrinsics.checkNotNullExpressionValue((Object)nodeMap, (String)"getNodeUpdatesDataMap(...)");
        NodeMap nodeMap2 = nodeMap;
        EdgeMap edgeMap = this.getGraphUpdateModel().getEdgeUpdatesDataMap();
        Intrinsics.checkNotNullExpressionValue((Object)edgeMap, (String)"getEdgeUpdatesDataMap(...)");
        EdgeMap edgeMap2 = edgeMap;
        Edge[] edgeArray = this.getGraph().getEdgeArray();
        Intrinsics.checkNotNullExpressionValue((Object)edgeArray, (String)"getEdgeArray(...)");
        Object[] $this$forEach$iv = edgeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Edge)element$iv;
            boolean bl = false;
            edgeMap2.set((Object)it, null);
        }
        Node[] nodeArray = this.getGraph().getNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"getNodeArray(...)");
        $this$forEach$iv = nodeArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Node)element$iv;
            boolean bl = false;
            nodeMap2.set((Object)it, null);
        }
        RiderGraphUtil.Companion.doLayout((GraphBuilder)this);
        if (this.getGraphPresentationModel().getSettings().isFitContentAfterLayout()) {
            this.fitContent(true);
        }
    }

    @NotNull
    public DiagramPresentationModel getPresentationModel() {
        return this.getGraphPresentationModel();
    }

    @NotNull
    public GraphBuilder<DiagramNode<?>, DiagramEdge<?>> getGraphBuilder() {
        return (GraphBuilder)this;
    }

    @NotNull
    public DiagramDataModel<Object> getDataModel() {
        GraphDataModel graphDataModel = this.getGraphDataModel();
        Intrinsics.checkNotNull((Object)graphDataModel, (String)"null cannot be cast to non-null type com.intellij.diagram.DiagramDataModelWrapper");
        DiagramDataModel diagramDataModel = ((DiagramDataModelWrapper)graphDataModel).getModel();
        Intrinsics.checkNotNullExpressionValue((Object)diagramDataModel, (String)"getModel(...)");
        return diagramDataModel;
    }

    @Nullable
    public DocumentReference getDocumentReference() {
        if (this.getEditor() != null) {
            VirtualFile file;
            DiagramFileEditor diagramFileEditor = this.getEditor();
            Object object = file = diagramFileEditor != null ? diagramFileEditor.getOriginalVirtualFile() : null;
            if (file != null && file.isValid()) {
                return DocumentReferenceManager.getInstance().create(file);
            }
        }
        return null;
    }

    public void notifyOtherBuilders() {
        VirtualFile file = this.getEditorFile();
        if (file != null) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.getProject()).getAllEditors(file);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            FileEditor[] editors = fileEditorArray;
            if (editors.length < 2) {
                return;
            }
            DiagramState state = new DiagramState((DiagramBuilder)this);
            Runnable notify = () -> RiderGraphBuilder.notifyOtherBuilders$lambda$6(editors, this, state);
            ApplicationManager.getApplication().invokeLater(notify, this.getProject().getDisposed());
        }
    }

    private final VirtualFile getEditorFile() {
        return (VirtualFile)this.getUserData(EDITOR_FILE);
    }

    @Nullable
    public JBPopup getPopup() {
        return (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP);
    }

    public void setPopup(@NotNull JBPopup popup) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        this.putUserData(DiagramDataKeys.UML_POPUP, popup);
        this.popupMode = true;
    }

    public void setAllowEdgeCreation(boolean allow) {
        this.getEditMode().allowEdgeCreation(allow);
    }

    @NotNull
    public DiagramProvider<?> getProvider() {
        Object object = this.getUserData(Utils.UML_PROVIDER);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.diagram.DiagramProvider<*>");
        return (DiagramProvider)object;
    }

    @NotNull
    public EditorColorsScheme getColorScheme() {
        if (GraphExportService.getInstance().isPrintMode()) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme(EditorColorsScheme.getDefaultSchemeName());
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getScheme(...)");
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        return editorColorsScheme;
    }

    @Nullable
    public DiagramFileEditor getEditor() {
        return (DiagramFileEditor)this.getUserData(UML_FILE_EDITOR);
    }

    public void setSelected(@NotNull DiagramNode<?> node, boolean selected) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Node n = this.getNode(node);
        this.getGraph().setSelected(n, selected);
    }

    public void updateView() {
        this.updateViewWithCustomLayouting(false, (Function0<Unit>)((Function0)() -> RiderGraphBuilder.updateView$lambda$7(this)));
    }

    public final void updateEdgesView() {
        BiMap map = this.getDataMaps().getEdgeObjectDataBiMap().inverse();
        Collection collection = this.getDataModel().getEdges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEdges(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DiagramEdge it = (DiagramEdge)element$iv;
            boolean bl = false;
            Edge edge = (Edge)map.get((Object)it);
            if (edge == null) continue;
            this.getProvider().getColorManager().getEdgeColor((DiagramBuilder)this, it);
            this.getGraph().getRealizer(edge).setLineColor(this.getProvider().getColorManager().getEdgeColor((DiagramBuilder)this, it));
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(edge);
            int n = it.getRelationship().getWidth();
            DiagramLineType diagramLineType = it.getRelationship().getLineType();
            Intrinsics.checkNotNull((Object)diagramLineType);
            edgeRealizer.setLineType(this.convertToYFilesLineType(n, diagramLineType));
            BiMap biMap = this.getDataMaps().getEdgeObjectDataBiMap();
            Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"getEdgeObjectDataBiMap(...)");
            ((Map)biMap).put(edge, it);
        }
        this.getGraph().updateViews();
    }

    private final LineType convertToYFilesLineType(int width, DiagramLineType type) {
        LineType lineType;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                LineType lineType2 = LineType.Statics.getLineType((int)width, (byte)LineType.LINE_1.getLineStyle());
                lineType = lineType2;
                Intrinsics.checkNotNullExpressionValue((Object)lineType2, (String)"getLineType(...)");
                break;
            }
            case 2: {
                LineType lineType3 = LineType.Statics.getLineType((int)width, (byte)LineType.DASHED_1.getLineStyle());
                lineType = lineType3;
                Intrinsics.checkNotNullExpressionValue((Object)lineType3, (String)"getLineType(...)");
                break;
            }
            case 3: {
                LineType lineType4 = LineType.Statics.getLineType((int)width, (byte)LineType.DOTTED_2.getLineStyle());
                lineType = lineType4;
                Intrinsics.checkNotNullExpressionValue((Object)lineType4, (String)"getLineType(...)");
                break;
            }
            case 4: {
                LineType lineType5 = LineType.Statics.getLineType((int)width, (byte)LineType.DASHED_DOTTED_1.getLineStyle());
                lineType = lineType5;
                Intrinsics.checkNotNullExpressionValue((Object)lineType5, (String)"getLineType(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return lineType;
    }

    public final void updateDataModelAndGroups() {
        boolean bl;
        String fqn;
        RiderProjectDiagramDataModel riderProjectDiagramDataModel = this.getRiderDataModel();
        String string = fqn = riderProjectDiagramDataModel != null ? riderProjectDiagramDataModel.getFqn() : null;
        if (fqn != null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            bl = DiagramHost.Companion.getInstance(project).isShowGroups(fqn);
        } else {
            bl = false;
        }
        boolean showGroups = bl;
        this.clearGraph();
        this.updateDataModel();
        if (showGroups) {
            this.updateGroups();
        }
    }

    public void updateDataModel() {
        this.clearGraph();
        super.updateDataModel();
    }

    public void updateDataModelWithCustomMapping(@Nullable Function<? super DiagramNode<?>, ? extends Node> nodeMapping, @Nullable Function<? super DiagramEdge<?>, ? extends Edge> edgeMapping) {
        super.updateDataModelWithCustomMapping(nodeMapping, edgeMapping);
        BiMap biMap = this.getDataMaps().getNodeObjectDataBiMap();
        Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"getNodeObjectDataBiMap(...)");
        Map $this$forEach$iv = (Map)biMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            DiagramNode nodeObj = (DiagramNode)it.getValue();
            if (!(nodeObj instanceof RiderDiagramNode)) continue;
            ((Map)this.nodeIdsMap).put(it.getKey(), ((RiderDiagramNode)nodeObj).getId());
        }
    }

    private final void updateViewWithCustomLayouting(boolean doLayout, Function0<Unit> layout) {
        Map<Node, NodeRealizer> realizerMap = this.saveGroupRealizers();
        this.updateRealizers(false);
        this.restoreGroupRealizers(realizerMap);
        this.updateEdgeLabels();
        this.updateGrid();
        this.deduplicateEdges();
        if (doLayout) {
            layout.invoke();
        }
        Iterable $this$forEach$iv = this.updaters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CustomGraphUpdater it = (CustomGraphUpdater)element$iv;
            boolean bl = false;
            it.update(this.getGraph(), this.getView());
        }
        this.getGraph().updateViews();
    }

    public void addNode(@NotNull String name, @NotNull DiagramNode<?> nodeObject) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(nodeObject, (String)"nodeObject");
        Object[] objectArray = new DiagramNode[]{nodeObject};
        Node node = GraphImplUtil.getExistedNode((GraphDataMaps)this.getDataMaps(), (String)name, (Object[])objectArray);
        if (node != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node)) {
                this.getGraphUpdateModel().setNodeWasViewed(node);
                GraphImplUtil.setNodeName((GraphDataMaps)this.getDataMaps(), (Node)node, (String)name);
            }
        } else {
            objectArray = new Object[1];
            DiagramNode[] diagramNodeArray = new DiagramNode[]{nodeObject};
            objectArray[0] = diagramNodeArray;
            node = GraphImplUtil.createNode((Graph)((Graph)this.getGraph()), (Graph)this.getInnerGraph(nodeObject), (GraphDataMaps)this.getDataMaps(), (String)name, (Object[])objectArray);
            this.getGraphUpdateModel().setNodeWasCreated(node);
        }
        GraphImplUtil.setNodeObject((GraphDataMaps)this.getDataMaps(), (Node)node, nodeObject);
        if (nodeObject instanceof RiderDiagramNode) {
            ((Map)this.nodeIdsMap).put(node, ((RiderDiagramNode)nodeObject).getId());
        }
    }

    private final Map<Node, NodeRealizer> saveGroupRealizers() {
        Map map = new LinkedHashMap();
        List list = GraphImplUtil.getNodes((Graph)((Graph)this.getGraph()));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNodes(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeRealizer realizer;
            Node it = (Node)element$iv;
            boolean bl = false;
            if (!this.getHierarchyManager().isGroupNode(it) && !this.getHierarchyManager().isFolderNode(it) || (realizer = this.getGraph().getRealizer(it)) == null) continue;
            map.put(it, realizer);
        }
        return map;
    }

    private final void restoreGroupRealizers(Map<Node, NodeRealizer> map) {
        List list = GraphImplUtil.getNodes((Graph)((Graph)this.getGraph()));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNodes(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeRealizer realizer;
            Node it = (Node)element$iv;
            boolean bl = false;
            if (!this.getHierarchyManager().isGroupNode(it) && !this.getHierarchyManager().isFolderNode(it) || (realizer = map.get(it)) == null) continue;
            this.getGraph().setRealizer(it, realizer);
        }
    }

    private final void deduplicateEdges() {
        Set connectionSet = new LinkedHashSet();
        Object[] $this$forEach$iv = (Object[])this.hiddenEdges;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            EdgeRealizer realizer;
            Edge edge;
            DiagramEdge it = (DiagramEdge)t;
            boolean bl = false;
            if (this.getNode(it.getSource()) == null || this.getNode(it.getTarget()) == null) continue;
            Object[] objectArray = new DiagramEdge[]{it};
            Intrinsics.checkNotNullExpressionValue((Object)this.addEdge(it.getSource(), it.getTarget(), "", it, objectArray, null), (String)"addEdge(...)");
            Intrinsics.checkNotNullExpressionValue((Object)this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge)), (String)"getEdgeRealizer(...)");
            this.getGraph().setRealizer(edge, realizer);
        }
        this.hiddenEdges.clear();
        Edge[] edgeArray = this.myGraph.getEdgeArray();
        Intrinsics.checkNotNullExpressionValue((Object)edgeArray, (String)"getEdgeArray(...)");
        $this$forEach$iv = edgeArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Edge it = (Edge)element$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.source(), (Object)it.target());
            if (connectionSet.contains(pair)) {
                DiagramEdge edgeObject = (DiagramEdge)this.getEdgeObject(it);
                if (edgeObject != null) {
                    this.hiddenEdges.add(edgeObject);
                }
                this.getActionExecutor().runWriteAction(() -> RiderGraphBuilder.deduplicateEdges$lambda$15$lambda$14(this, edgeObject));
                continue;
            }
            connectionSet.add(pair);
        }
    }

    private final Graph getInnerGraph(DiagramNode<?> nodeObject) {
        NodeGroupDescriptor group = this.getGraphDataModel().getGroup(nodeObject);
        if (group != null) {
            Node node = GraphImplUtil.getOrCreateGroupNode((Graph2D)this.getGraph(), (HierarchyManager)this.getHierarchyManager(), (NodeGroupDescriptor)group, (GraphDataMaps)this.getDataMaps());
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getOrCreateGroupNode(...)");
            Node groupNode = node;
            if (this.getHierarchyManager().isFolderNode(groupNode)) {
                return this.getHierarchyManager().getInnerGraph(groupNode);
            }
        }
        return null;
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.getView().getCanvasComponent(), true);
    }

    public boolean isPopupMode() {
        return this.popupMode;
    }

    public void beforeActionPerformed(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphBuilderEvent event) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)((Object)this), builder) && !this.states.containsKey(event)) {
            this.states.put(event, new DiagramState((DiagramBuilder)this));
        }
    }

    public void actionPerformed(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphBuilderEvent event) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)((Object)this), builder) && this.states.containsKey(event)) {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).withName(event.toString()).withGroupId(this.getGroupId(event)).run(() -> RiderGraphBuilder.actionPerformed$lambda$16(this, builder, event));
        }
    }

    public void dispose() {
        DocumentReference ref = this.getDocumentReference();
        if (ref != null) {
            UndoManager undoManager = UndoManager.getInstance((Project)this.getProject());
            Intrinsics.checkNotNull((Object)undoManager, (String)"null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
            ((UndoManagerImpl)undoManager).invalidateActionsFor(ref);
        }
        this.getGraph().removeGraph2DSelectionListener(this.myListener);
        EditMode editMode = this.getEditMode();
        Intrinsics.checkNotNullExpressionValue((Object)editMode, (String)"getEditMode(...)");
        EditMode em = editMode;
        if (em instanceof RiderGraphEditMode) {
            ((RiderGraphEditMode)em).dispose();
        }
        super.dispose();
    }

    @NotNull
    public final List<Node> getSelectedNodesByCursor(@NotNull NodeCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        return this.collectNodesFromCursor(cursor, (Function2<? super Node, ? super List<Node>, Unit>)((Function2)(arg_0, arg_1) -> RiderGraphBuilder.getSelectedNodesByCursor$lambda$17(this, arg_0, arg_1)));
    }

    @NotNull
    public final List<Node> getSelectedNodesFromPlain(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        List acc = new ArrayList();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Node it = (Node)element$iv;
            boolean bl2 = false;
            if (this.isGroupNode(it)) {
                List<Node> innerList = this.getInnerNodes(it);
                bl = acc.addAll((Collection)innerList);
                continue;
            }
            bl = acc.add(it);
        }
        return acc;
    }

    @NotNull
    public final List<Node> getSelectedNodes() {
        NodeCursor cursor = this.getGraph().selectedNodes();
        Intrinsics.checkNotNull((Object)cursor);
        return this.getSelectedNodesByCursor(cursor);
    }

    @NotNull
    public final List<Node> getSelectedNodesPlain() {
        NodeCursor cursor = this.getGraph().selectedNodes();
        Intrinsics.checkNotNull((Object)cursor);
        return this.collectNodesFromCursor(cursor, (Function2<? super Node, ? super List<Node>, Unit>)((Function2)RiderGraphBuilder::getSelectedNodesPlain$lambda$19));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getSelectedNodesIdsPlain() {
        void $this$mapNotNullTo$iv$iv;
        NodeCursor cursor = this.getGraph().selectedNodes();
        Intrinsics.checkNotNull((Object)cursor);
        Iterable $this$mapNotNull$iv = this.collectNodesFromCursor(cursor, (Function2<? super Node, ? super List<Node>, Unit>)((Function2)RiderGraphBuilder::getSelectedNodesIdsPlain$lambda$20));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Node it = (Node)element$iv$iv;
            boolean bl2 = false;
            if (this.getNodeId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Node> getSelectedNodesByIds(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        List acc = new ArrayList();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            int it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            Node node = this.getNodeById(it);
            if (node == null) continue;
            if (this.isGroupNode(node)) {
                List<Node> innerList = this.getInnerNodes(node);
                bl = acc.addAll((Collection)innerList);
                continue;
            }
            bl = acc.add(node);
        }
        return acc;
    }

    private final Integer getNodeId(Node node) {
        Integer nodeId = (Integer)this.nodeIdsMap.get((Object)node);
        Integer n = nodeId;
        if (n == null) {
            List list = this.groupIdNodeMap.getKeysByValue((Object)node);
            n = list != null ? (Integer)CollectionsKt.first((List)list) : null;
        }
        return n;
    }

    private final Node getNodeById(int id) {
        List list = this.nodeIdsMap.getKeysByValue((Object)id);
        Object node = list != null ? (Node)CollectionsKt.first((List)list) : null;
        Node node2 = node;
        if (node2 == null) {
            node2 = (Node)this.groupIdNodeMap.get((Object)id);
        }
        return node2;
    }

    private final List<Node> getInnerNodes(Node node) {
        if (!this.isGroupNode(node)) {
            return CollectionsKt.emptyList();
        }
        NodeCursor children = this.getHierarchyManager().getChildren(node);
        Intrinsics.checkNotNull((Object)children);
        return this.collectNodesFromCursor(children, (Function2<? super Node, ? super List<Node>, Unit>)((Function2)(arg_0, arg_1) -> RiderGraphBuilder.getInnerNodes$lambda$23(this, arg_0, arg_1)));
    }

    private final List<Node> collectNodesFromCursor(NodeCursor cursor, Function2<? super Node, ? super List<Node>, Unit> collector) {
        List result = new ArrayList();
        while (cursor.ok()) {
            Node currNode = cursor.node();
            Intrinsics.checkNotNull((Object)currNode);
            collector.invoke((Object)currNode, (Object)result);
            cursor.next();
        }
        return result;
    }

    private final boolean isGroupNode(Node node) {
        return this.getHierarchyManager().isGroupNode(node) || this.getHierarchyManager().isFolderNode(node);
    }

    public final void addEdgesToUpdate(@NotNull Collection<? extends DiagramEdge<?>> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        this.edgesToPartialUpdate.addAll(edges);
    }

    private final void updateEdgeLabels() {
        Edge[] edgeArray = this.getGraph().getEdgeArray();
        Intrinsics.checkNotNullExpressionValue((Object)edgeArray, (String)"getEdgeArray(...)");
        Object[] $this$forEach$iv = edgeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EdgeLabel[] edgeLabels;
            Edge it = (Edge)element$iv;
            boolean bl = false;
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(it);
            Intrinsics.checkNotNull((Object)edgeRealizer);
            this.clearLabels(edgeRealizer);
            Intrinsics.checkNotNullExpressionValue((Object)this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(it), GraphImplUtil.getEdgeName((GraphDataMaps)this.getDataMaps(), (Edge)it)), (String)"getEdgeLabels(...)");
            EdgeLabel[] $this$forEach$iv2 = edgeLabels;
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                EdgeLabel element$iv2;
                EdgeLabel el = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                edgeRealizer.addLabel(el);
            }
        }
    }

    private final void clearLabels(EdgeRealizer edgeRealizer) {
        int n = edgeRealizer.labelCount();
        for (int i = 0; i < n; ++i) {
            edgeRealizer.removeLabel(edgeRealizer.getLabel(i));
        }
        edgeRealizer.setLabelText("");
    }

    /*
     * WARNING - void declaration
     */
    protected void updateGroups() {
        void $this$filterTo$iv$iv;
        RiderProjectDiagramDataModel riderProjectDiagramDataModel = this.getRiderDataModel();
        if (riderProjectDiagramDataModel == null) {
            return;
        }
        RiderProjectDiagramDataModel dataModel = riderProjectDiagramDataModel;
        String fqn = dataModel.getFqn();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean showGroups = DiagramHost.Companion.getInstance(project).isShowGroups(fqn);
        if (!showGroups) {
            return;
        }
        RiderGraphGroupManager grm = new RiderGraphGroupManager(this.groupIdNodeMap);
        Node[] nodeArray = this.getGraph().getNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"getNodeArray(...)");
        Object[] $this$filter$iv = nodeArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            if (!(this.getNodeObject(it) instanceof RiderGroupableDiagramNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List riderNodeArray = (List)destination$iv$iv;
        HierarchyManager hierarchyManager = this.getHierarchyManager();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchyManager, (String)"getHierarchyManager(...)");
        this.groupIdNodeMap = grm.groupGraph(this.myGraph, hierarchyManager, dataModel, riderNodeArray, this, (Map)this.nodeIdsMap);
    }

    private final void clearGraph() {
        this.getGraph().clear();
        this.clearNodes();
        this.clearEdges();
    }

    private final void clearNodes() {
        this.getDataMaps().getNodeObjectDataBiMap().clear();
        this.getDataMaps().getNodeNameDataMap().clear();
        this.getDataMaps().getNodeEqualityDataMap().clear();
        this.groupIdNodeMap.clear();
        this.nodeIdsMap.clear();
    }

    private final void clearEdges() {
        this.getDataMaps().getEdgeNameDataMap().clear();
        this.getDataMaps().getEdgeEqualityDataMap().clear();
        this.getDataMaps().getEdgeObjectDataBiMap().clear();
        this.hiddenEdges.clear();
    }

    public final void doLayout() {
        Graph2D graph2D = this.getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D, (String)"getGraph(...)");
        Graph2DView graph2DView = this.getView();
        Intrinsics.checkNotNullExpressionValue((Object)graph2DView, (String)"getView(...)");
        this.myLayouter.doLayout(graph2D, graph2DView, this);
    }

    public final void doAnimatedLayout() {
        Graph2D graph2D = this.getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D, (String)"getGraph(...)");
        Graph2DView graph2DView = this.getView();
        Intrinsics.checkNotNullExpressionValue((Object)graph2DView, (String)"getView(...)");
        this.myLayouter.doAnimatedLayout(graph2D, graph2DView, this);
    }

    protected void updateNodeRealizer(@NotNull Node node, boolean doNodeSizeUpdate) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.getHierarchyManager().isGroupNode(node) || this.getHierarchyManager().isFolderNode(node)) {
            return;
        }
        super.updateNodeRealizer(node, doNodeSizeUpdate);
    }

    public final void groupRelayout() {
        this.deduplicateEdges();
        this.doAnimatedLayout();
    }

    private final String getGroupId(GraphBuilderEvent event) {
        if (event == GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD) {
            return event.toString();
        }
        return null;
    }

    private static final void myListener$lambda$0(DiagramPresentationModel $myGraphPresentationModel, Graph2DSelectionEvent e) {
        if (e != null && e.isNodeSelection()) {
            $myGraphPresentationModel.onSelectionChanged(e);
        }
    }

    private static final void notifyOtherBuilders$lambda$6(FileEditor[] $editors, RiderGraphBuilder this$0, DiagramState $state) {
        FileEditor[] $this$forEach$iv = $editors;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            DiagramBuilder diagramBuilder;
            FileEditor element$iv;
            FileEditor it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!(it instanceof UmlFileEditorImpl) || Intrinsics.areEqual((Object)((UmlFileEditorImpl)it).getBuilder(), (Object)((Object)this$0))) continue;
            ((UmlFileEditorImpl)it).setUmlState($state);
            DiagramBuilder diagramBuilder2 = ((UmlFileEditorImpl)it).getBuilder();
            if (diagramBuilder2 != null) {
                diagramBuilder2.update(false, false);
            }
            if ((diagramBuilder = ((UmlFileEditorImpl)it).getBuilder()) == null || (diagramBuilder = diagramBuilder.getGraphBuilder()) == null) continue;
            diagramBuilder.updateView();
        }
    }

    private static final Unit updateView$lambda$7(RiderGraphBuilder this$0) {
        this$0.doAnimatedLayout();
        return Unit.INSTANCE;
    }

    private static final void deduplicateEdges$lambda$15$lambda$14(RiderGraphBuilder this$0, DiagramEdge $edgeObject) {
        this$0.removeEdge($edgeObject);
    }

    private static final void actionPerformed$lambda$16(RiderGraphBuilder this$0, GraphBuilder $builder, GraphBuilderEvent $event) {
        DiagramActionsManager.getInstance((Project)this$0.getProject()).notifyUmlListeners((DiagramBuilder)$builder, this$0.states.remove($event), new PsiFile[0]);
        this$0.notifyOtherBuilders();
    }

    private static final Unit getSelectedNodesByCursor$lambda$17(RiderGraphBuilder this$0, Node curr, List acc) {
        Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        if (this$0.isGroupNode(curr)) {
            List<Node> innerList = this$0.getInnerNodes(curr);
            v0 = acc.addAll((Collection)innerList);
        } else {
            v0 = acc.add(curr);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getSelectedNodesPlain$lambda$19(Node curr, List acc) {
        Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        acc.add(curr);
        return Unit.INSTANCE;
    }

    private static final Unit getSelectedNodesIdsPlain$lambda$20(Node curr, List acc) {
        Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        acc.add(curr);
        return Unit.INSTANCE;
    }

    private static final Unit getInnerNodes$lambda$23(RiderGraphBuilder this$0, Node curr, List acc) {
        Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        if (this$0.isGroupNode(curr)) {
            List<Node> innerList = this$0.getInnerNodes(curr);
            v0 = acc.addAll((Collection)innerList);
        } else {
            v0 = acc.add(curr);
        }
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"UML_FILE_EDITOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        UML_FILE_EDITOR = key;
        Key key2 = Key.create((String)"diagram.editor.file");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        EDITOR_FILE = key2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder$Companion;", "", "<init>", "()V", "UML_FILE_EDITOR", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/diagram/DiagramFileEditor;", "EDITOR_FILE", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.diagram"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagramLineType.values().length];
            try {
                nArray[DiagramLineType.SOLID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramLineType.DASHED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramLineType.DOTTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagramLineType.DASHED_DOTTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

