/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.graph;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramDataModel;
import com.jetbrains.rider.diagrams.architecture.graph.RiderDiagramUpdater;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphBuilder;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramEdge;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\u001b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u001e\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u000f0\u0011J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u001e\u0010\u0010\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u000f0\u0011J\u0014\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0019\u001a\u00020\u000bJ\u001b\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020\u000bH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataModel", "Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramDataModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramDataModel;)V", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "runUpdate", "", "()Lkotlin/Unit;", "runEdgesChanges", "", "Lcom/jetbrains/rider/diagrams/architecture/graphElements/RiderDiagramEdge;", "edges", "", "Lkotlin/Pair;", "", "runEdgesChangeLight", "", "runFullEdgeChanges", "updateGraph", "updateEdges", "groupRelayout", "createUpdate", "com/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater$createUpdate$1", "updateAction", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Lcom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater$createUpdate$1;", "throttleUpdateGraph", "throttleUpdateEdges", "edgesDifferent", "", "old", "new", "intellij.rider.plugins.diagram"})
@SourceDebugExtension(value={"SMAP\nRiderDiagramUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDiagramUpdater.kt\ncom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1863#2,2:81\n*S KotlinDebug\n*F\n+ 1 RiderDiagramUpdater.kt\ncom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater\n*L\n37#1:81,2\n*E\n"})
public final class RiderDiagramUpdater {
    @NotNull
    private final Project project;
    @NotNull
    private final RiderProjectDiagramDataModel dataModel;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;

    public RiderDiagramUpdater(@NotNull Project project, @NotNull RiderProjectDiagramDataModel dataModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)dataModel), (String)"dataModel");
        this.project = project;
        this.dataModel = dataModel;
        this.mergingUpdateQueue = new MergingUpdateQueue("Diagram Scope Manager", 500, true, null, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), null, (int)1, null), null, false, 96, null);
    }

    @Nullable
    public final Unit runUpdate() {
        return this.updateGraph();
    }

    @NotNull
    public final List<RiderDiagramEdge> runEdgesChanges(@NotNull Map<Pair<Integer, Integer>, ? extends RiderDiagramEdge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        int n = ((Collection)this.dataModel.getModelEdges()).size();
        for (int i = 0; i < n; ++i) {
            RiderDiagramEdge edge = this.dataModel.getModelEdges().get(i);
            RiderDiagramEdge changedEdge = edges.get(new Pair((Object)edge.getSource().getId(), (Object)edge.getTarget().getId()));
            if (changedEdge == null || !this.edgesDifferent(edge, changedEdge)) continue;
            this.dataModel.getModelEdges().set(i, changedEdge);
        }
        this.throttleUpdateGraph();
        return this.dataModel.getModelEdges();
    }

    @NotNull
    public final List<RiderDiagramEdge> runEdgesChangeLight(@NotNull Map<Pair<Integer, Integer>, ? extends RiderDiagramEdge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        Iterable $this$forEach$iv = this.dataModel.getModelEdges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RiderDiagramEdge it = (RiderDiagramEdge)((Object)element$iv);
            boolean bl = false;
            RiderDiagramEdge changedEdge = edges.get(new Pair((Object)it.getSource().getId(), (Object)it.getTarget().getId()));
            if (changedEdge == null) continue;
            it.setWeight(changedEdge.getWeight());
            it.setRelationship(changedEdge.getRelationship());
            it.setDirty(true);
        }
        this.throttleUpdateEdges();
        return this.dataModel.getModelEdges();
    }

    public final void runFullEdgeChanges(@NotNull List<RiderDiagramEdge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        this.dataModel.updateEdges(edges);
        this.throttleUpdateEdges();
    }

    private final Unit updateGraph() {
        Unit unit;
        RiderGraphBuilder riderGraphBuilder = this.dataModel.getRiderGraphBuilder();
        if (riderGraphBuilder != null) {
            riderGraphBuilder.update(true, true);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit updateEdges() {
        Unit unit;
        RiderGraphBuilder riderGraphBuilder = this.dataModel.getRiderGraphBuilder();
        if (riderGraphBuilder != null) {
            riderGraphBuilder.updateEdgesView();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void groupRelayout() {
        block0: {
            DiagramBuilder diagramBuilder = this.dataModel.getBuilder();
            RiderGraphBuilder riderGraphBuilder = diagramBuilder instanceof RiderGraphBuilder ? (RiderGraphBuilder)diagramBuilder : null;
            if (riderGraphBuilder == null) break block0;
            riderGraphBuilder.groupRelayout();
        }
    }

    private final createUpdate.1 createUpdate(Function0<Unit> updateAction) {
        return new Update(this, updateAction){
            final /* synthetic */ RiderDiagramUpdater this$0;
            final /* synthetic */ Function0<Unit> $updateAction;
            {
                this.this$0 = $receiver;
                this.$updateAction = $updateAction;
                super((Object)"", false, 0, 6, null);
            }

            public void run() {
                if (!RiderDiagramUpdater.access$getProject$p(this.this$0).isDisposed()) {
                    this.$updateAction.invoke();
                }
            }
        };
    }

    private final void throttleUpdateGraph() {
        this.mergingUpdateQueue.queue((Update)this.createUpdate((Function0<Unit>)((Function0)() -> RiderDiagramUpdater.throttleUpdateGraph$lambda$1(this))));
    }

    private final void throttleUpdateEdges() {
        this.mergingUpdateQueue.queue((Update)this.createUpdate((Function0<Unit>)((Function0)() -> RiderDiagramUpdater.throttleUpdateEdges$lambda$2(this))));
    }

    private final boolean edgesDifferent(RiderDiagramEdge old, RiderDiagramEdge riderDiagramEdge) {
        return old.getWeight() != riderDiagramEdge.getWeight() ? true : (old.getRelationship().getLineType() != riderDiagramEdge.getRelationship().getLineType() ? true : !Intrinsics.areEqual((Object)old.getRelationship().getName(), (Object)riderDiagramEdge.getRelationship().getName()));
    }

    private static final Unit throttleUpdateGraph$lambda$1(RiderDiagramUpdater this$0) {
        this$0.updateGraph();
        return Unit.INSTANCE;
    }

    private static final Unit throttleUpdateEdges$lambda$2(RiderDiagramUpdater this$0) {
        this$0.updateEdges();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(RiderDiagramUpdater $this) {
        return $this.project;
    }
}

