/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.noesis.preview;

import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerManagerListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.noesis.NoesisPluginBundle;
import com.jetbrains.rider.noesis.preview.NoesisLspServerManagerListener;
import com.jetbrains.rider.noesis.preview.NoesisPreviewEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/noesis/preview/NoesisPreview;", "", "editor", "Lcom/jetbrains/rider/noesis/preview/NoesisPreviewEditor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rider/noesis/preview/NoesisPreviewEditor;Lcom/intellij/openapi/project/Project;)V", "getEditor", "()Lcom/jetbrains/rider/noesis/preview/NoesisPreviewEditor;", "imageLabel", "Ljavax/swing/JLabel;", "getImageLabel", "()Ljavax/swing/JLabel;", "setImageLabel", "(Ljavax/swing/JLabel;)V", "footer", "Ljavax/swing/JPanel;", "getFooter", "()Ljavax/swing/JPanel;", "setFooter", "(Ljavax/swing/JPanel;)V", "panel", "getPanel", "setPanel", "cleanupPreview", "", "reloadPreview", "generatePreviewFilePath", "Ljava/nio/file/Path;", "uriPath", "", "uriScheme", "intellij.rider.plugins.noesis"})
public final class NoesisPreview {
    @NotNull
    private final NoesisPreviewEditor editor;
    @NotNull
    private JLabel imageLabel;
    @NotNull
    private JPanel footer;
    @NotNull
    private JPanel panel;

    public NoesisPreview(@NotNull NoesisPreviewEditor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)editor), (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.editor = editor;
        this.imageLabel = new JLabel();
        this.footer = (JPanel)BuilderKt.panel(arg_0 -> NoesisPreview.footer$lambda$2(project, arg_0));
        this.panel = (JPanel)BuilderKt.panel(arg_0 -> NoesisPreview.panel$lambda$7(this, arg_0));
        LspServerManager.Companion.getInstance(project).addLspServerManagerListener((LspServerManagerListener)new NoesisLspServerManagerListener(this), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.editor)), null, (int)1, null), true);
        UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.editor)).onTermination(() -> NoesisPreview._init_$lambda$8(this));
    }

    @NotNull
    public final NoesisPreviewEditor getEditor() {
        return this.editor;
    }

    @NotNull
    public final JLabel getImageLabel() {
        return this.imageLabel;
    }

    public final void setImageLabel(@NotNull JLabel jLabel) {
        Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
        this.imageLabel = jLabel;
    }

    @NotNull
    public final JPanel getFooter() {
        return this.footer;
    }

    public final void setFooter(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.footer = jPanel;
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    public final void setPanel(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.panel = jPanel;
    }

    public final void cleanupPreview() {
        this.imageLabel.setVisible(false);
        this.footer.setVisible(true);
        Files.deleteIfExists(NoesisPreview.generatePreviewFilePath$default(this, this.editor.getVirtualFilePath(), null, 2, null));
    }

    public final void reloadPreview() {
        String string = this.editor.getCurrentFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path imagePath = NoesisPreview.generatePreviewFilePath$default(this, string, null, 2, null);
        this.imageLabel.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(((Object)imagePath).toString())));
        this.imageLabel.setVisible(true);
        this.footer.setVisible(false);
    }

    @NotNull
    public final Path generatePreviewFilePath(@NotNull String uriPath, @NotNull String uriScheme) {
        Intrinsics.checkNotNullParameter((Object)uriPath, (String)"uriPath");
        Intrinsics.checkNotNullParameter((Object)uriScheme, (String)"uriScheme");
        String tmpDir = null;
        String sep = "/";
        tmpDir = SystemInfo.isWindows ? System.getProperty("java.io.tmpdir") : "/tmp";
        Object previewFilePath = uriPath;
        if (Intrinsics.areEqual((Object)uriScheme, (Object)"untitled")) {
            previewFilePath = "zuntitledz" + sep + (String)previewFilePath;
        }
        while (StringsKt.indexOf$default((CharSequence)((CharSequence)previewFilePath), (String)sep, (int)0, (boolean)false, (int)6, null) == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)((String)previewFilePath).substring(1), (String)"substring(...)");
        }
        previewFilePath = StringsKt.replace$default((String)previewFilePath, (String)sep, (String)"-_", (boolean)false, (int)4, null);
        previewFilePath = StringsKt.replace$default((String)previewFilePath, (String)":", (String)"_", (boolean)false, (int)4, null);
        String[] stringArray = new String[]{"noesis", (String)previewFilePath + ".png"};
        Path path = Paths.get(tmpDir, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    public static /* synthetic */ Path generatePreviewFilePath$default(NoesisPreview noesisPreview, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return noesisPreview.generatePreviewFilePath(string, string2);
    }

    private static final Unit footer$lambda$2$lambda$1$lambda$0(Project $project, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowSettingsUtil.getInstance().showSettingsDialog($project, NoesisPluginBundle.Companion.message("configurable.name.noesis", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit footer$lambda$2$lambda$1(Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new JLabel(NoesisPluginBundle.Companion.message("noesis.preview.label.loading", new Object[0])));
        $this$row.link(NoesisPluginBundle.Companion.message("noesis.preview.open.settings.label", new Object[0]), arg_0 -> NoesisPreview.footer$lambda$2$lambda$1$lambda$0($project, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit footer$lambda$2(Project $project, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NoesisPreview.footer$lambda$2$lambda$1($project, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit panel$lambda$7$lambda$5(NoesisPreview this$0, Row $this$row) {
        void $this$panel_u24lambda_u247_u24lambda_u245_u24lambda_u243;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)this$0.imageLabel, 21, 31);
        Row row = $this$row;
        boolean bl = false;
        $this$panel_u24lambda_u247_u24lambda_u245_u24lambda_u243.setBorder(null);
        JBScrollPane $this$panel_u24lambda_u247_u24lambda_u245_u24lambda_u244 = jBScrollPane = row.cell((JComponent)jBScrollPane);
        boolean bl2 = false;
        ((JBScrollPane)$this$panel_u24lambda_u247_u24lambda_u245_u24lambda_u244.getComponent()).setPreferredSize(new Dimension(10, 10));
        jBScrollPane.align(Align.FILL).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$7$lambda$6(NoesisPreview this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.footer).align((Align)AlignX.CENTER.INSTANCE).align((Align)AlignY.BOTTOM.INSTANCE).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$7(NoesisPreview this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NoesisPreview.panel$lambda$7$lambda$5(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NoesisPreview.panel$lambda$7$lambda$6(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(NoesisPreview this$0) {
        Files.deleteIfExists(NoesisPreview.generatePreviewFilePath$default(this$0, this$0.editor.getVirtualFilePath(), null, 2, null));
        return Unit.INSTANCE;
    }
}

